/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.repository.query.Predicates;
import org.springframework.data.gemfire.repository.query.QueryBuilder;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

class GemfireQueryCreator
extends AbstractQueryCreator<QueryString, Predicates> {
    private static final Log LOG = LogFactory.getLog(GemfireQueryCreator.class);
    private Iterator<Integer> indexes;
    private final QueryBuilder queryBuilder;

    public GemfireQueryCreator(PartTree tree, GemfirePersistentEntity<?> entity) {
        super(tree);
        this.queryBuilder = new QueryBuilder(entity, tree);
        this.indexes = new IndexProvider();
    }

    public QueryString createQuery(Sort dynamicSort) {
        this.indexes = new IndexProvider();
        return (QueryString)super.createQuery(dynamicSort);
    }

    protected Predicates create(Part part, Iterator<Object> iterator) {
        return Predicates.create(part, this.indexes);
    }

    protected Predicates and(Part part, Predicates base, Iterator<Object> iterator) {
        return base.and(Predicates.create(part, this.indexes));
    }

    protected Predicates or(Predicates base, Predicates criteria) {
        return base.or(criteria);
    }

    protected QueryString complete(Predicates criteria, Sort sort) {
        QueryString query = this.queryBuilder.create(criteria).orderBy(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Created Query [%s]", query.toString()));
        }
        return query;
    }

    private static class IndexProvider
    implements Iterator<Integer> {
        private int index = 1;

        @Override
        public boolean hasNext() {
            return this.index <= Integer.MAX_VALUE;
        }

        @Override
        public Integer next() {
            return this.index++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

