/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.Optional;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.data.gemfire.function.execution.GemfireFunctionProxyFactoryBean;
import org.springframework.util.StringUtils;

abstract class ServerBasedFunctionExecutionBeanDefinitionBuilder
extends AbstractFunctionExecutionBeanDefinitionBuilder {
    ServerBasedFunctionExecutionBeanDefinitionBuilder(FunctionExecutionConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected BeanDefinitionBuilder getGemfireFunctionOperationsBeanDefinitionBuilder(BeanDefinitionRegistry registry) {
        String resolvedCacheBeanName = Optional.ofNullable(this.configuration.getAttribute("cache")).map(String::valueOf).filter(StringUtils::hasText).orElse("gemfireCache");
        Optional<String> poolBeanName = Optional.ofNullable(this.configuration.getAttribute("pool")).map(String::valueOf).filter(StringUtils::hasText);
        BeanDefinitionBuilder functionTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getGemfireFunctionOperationsClass());
        functionTemplateBuilder.addConstructorArgReference(resolvedCacheBeanName);
        poolBeanName.ifPresent(it -> {
            functionTemplateBuilder.addDependsOn(it);
            functionTemplateBuilder.addPropertyReference("pool", it);
        });
        return functionTemplateBuilder;
    }

    @Override
    protected Class<?> getFunctionProxyFactoryBeanClass() {
        return GemfireFunctionProxyFactoryBean.class;
    }

    protected abstract Class<?> getGemfireFunctionOperationsClass();
}

