/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.Map;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;

class FunctionExecutionConfiguration {
    private Class<?> functionExecutionInterface;
    private final AnnotationAttributes annotationAttributes;
    private final String annotationType;

    FunctionExecutionConfiguration() {
        this.annotationType = null;
        this.annotationAttributes = null;
    }

    FunctionExecutionConfiguration(ScannedGenericBeanDefinition beanDefinition, String annotationType) {
        try {
            this.annotationType = annotationType;
            this.annotationAttributes = AnnotationAttributes.fromMap((Map)beanDefinition.getMetadata().getAnnotationAttributes(annotationType, true));
            this.functionExecutionInterface = beanDefinition.resolveBeanClass(beanDefinition.getClass().getClassLoader());
            this.assertFunctionExecutionInterfaceIsValid(annotationType);
        }
        catch (ClassNotFoundException cause) {
            throw new RuntimeException(cause);
        }
    }

    private void assertFunctionExecutionInterfaceIsValid(String annotationType) {
        boolean valid = this.functionExecutionInterface != null && this.functionExecutionInterface.isInterface();
        Assert.isTrue((boolean)valid, (String)String.format("The annotation [%1$s] only applies to an interface; It is not valid for type [%2$s]", annotationType, SpringUtils.nullSafeName(this.functionExecutionInterface)));
    }

    String getAnnotationType() {
        return this.annotationType;
    }

    Object getAttribute(String name) {
        return this.annotationAttributes.get((Object)name);
    }

    AnnotationAttributes getAttributes() {
        return this.annotationAttributes;
    }

    Class<?> getFunctionExecutionInterface() {
        return this.functionExecutionInterface;
    }
}

