/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.admin;

import java.util.Arrays;
import org.springframework.data.gemfire.config.schema.SchemaObjectDefinition;
import org.springframework.data.gemfire.config.schema.definitions.IndexDefinition;
import org.springframework.data.gemfire.config.schema.definitions.RegionDefinition;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;

public interface GemfireAdminOperations {
    public Iterable<String> getAvailableServerRegions();

    public Iterable<String> getAvailableServerRegionIndexes();

    public void createRegion(RegionDefinition var1);

    default public void createRegions(RegionDefinition ... regionDefinitions) {
        Arrays.stream(ArrayUtils.nullSafeArray(regionDefinitions, RegionDefinition.class)).forEach(this::createRegion);
    }

    default public void createRegions(Iterable<RegionDefinition> regionDefinitions) {
        CollectionUtils.nullSafeIterable(regionDefinitions).forEach(this::createRegion);
    }

    public void createLuceneIndex(SchemaObjectDefinition var1);

    default public void createLuceneIndexes(SchemaObjectDefinition ... luceneIndexDefinitions) {
        Arrays.stream(ArrayUtils.nullSafeArray(luceneIndexDefinitions, SchemaObjectDefinition.class)).forEach(this::createLuceneIndex);
    }

    default public void createLuceneIndexes(Iterable<SchemaObjectDefinition> luceneIndexDefinitions) {
        CollectionUtils.nullSafeIterable(luceneIndexDefinitions).forEach(this::createLuceneIndex);
    }

    public void createIndex(IndexDefinition var1);

    default public void createIndexes(IndexDefinition ... indexDefinitions) {
        Arrays.stream(ArrayUtils.nullSafeArray(indexDefinitions, IndexDefinition.class)).forEach(this::createIndex);
    }

    default public void createIndexes(Iterable<IndexDefinition> indexDefinitions) {
        CollectionUtils.nullSafeIterable(indexDefinitions).forEach(this::createIndex);
    }

    public void createDiskStore(SchemaObjectDefinition var1);

    default public void createDiskStores(SchemaObjectDefinition ... diskStoreDefinitions) {
        Arrays.stream(ArrayUtils.nullSafeArray(diskStoreDefinitions, SchemaObjectDefinition.class)).forEach(this::createDiskStore);
    }

    default public void createDiskStores(Iterable<SchemaObjectDefinition> diskStoreDefinitions) {
        CollectionUtils.nullSafeIterable(diskStoreDefinitions).forEach(this::createDiskStore);
    }
}

