/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.function.config.EnableGemfireFunctionExecutions;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AnnotationFunctionExecutionConfigurationSource
extends AbstractFunctionExecutionConfigurationSource {
    private static final String BASE_PACKAGES = "basePackages";
    private static final String BASE_PACKAGE_CLASSES = "basePackageClasses";
    private static final String VALUE = "value";
    private final AnnotationMetadata metadata;
    private final AnnotationAttributes attributes;

    public AnnotationFunctionExecutionConfigurationSource(AnnotationMetadata metadata) {
        Assert.notNull((Object)metadata, (String)"AnnotationMetadata must not be null");
        this.attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(EnableGemfireFunctionExecutions.class.getName()));
        this.metadata = metadata;
    }

    @Override
    public Object getSource() {
        return this.metadata;
    }

    @Override
    public Iterable<String> getBasePackages() {
        String[] value = this.attributes.getStringArray(VALUE);
        String[] basePackages = this.attributes.getStringArray(BASE_PACKAGES);
        Class[] basePackageClasses = this.attributes.getClassArray(BASE_PACKAGE_CLASSES);
        if (this.areAllEmpty(value, basePackages, basePackageClasses)) {
            String className = this.metadata.getClassName();
            return Collections.singleton(className.substring(0, className.lastIndexOf(46)));
        }
        HashSet<String> packages = new HashSet<String>();
        packages.addAll(Arrays.asList(value));
        packages.addAll(Arrays.asList(basePackages));
        Arrays.stream(ArrayUtils.nullSafeArray(basePackageClasses, Class.class)).map(ClassUtils::getPackageName).forEach(packages::add);
        return packages;
    }

    private boolean areAllEmpty(Object[] ... arrays) {
        for (Object[] array : arrays) {
            if (ArrayUtils.isEmpty(array)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<TypeFilter> getExcludeFilters() {
        return this.parseFilters("excludeFilters");
    }

    @Override
    public Iterable<TypeFilter> getIncludeFilters() {
        return this.parseFilters("includeFilters");
    }

    private Set<TypeFilter> parseFilters(String attributeName) {
        AnnotationAttributes[] filters = this.attributes.getAnnotationArray(attributeName);
        HashSet<TypeFilter> result = new HashSet<TypeFilter>();
        for (AnnotationAttributes filter : filters) {
            result.addAll(this.typeFiltersFor(filter));
        }
        return result;
    }

    private List<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        block5: for (Class filterClass : filterAttributes.getClassArray(VALUE)) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)"An error occured when processing a @ComponentScan ANNOTATION type filter: ");
                    Class annoClass = filterClass;
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(annoClass));
                    continue block5;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    continue block5;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)"An error occured when processing a @ComponentScan CUSTOM type filter: ");
                    typeFilters.add((TypeFilter)BeanUtils.instantiateClass((Class)filterClass, TypeFilter.class));
                    continue block5;
                }
                default: {
                    throw RuntimeExceptionFactory.newIllegalArgumentException("Unknown filter type [*s]", filterType);
                }
            }
        }
        return typeFilters;
    }
}

