/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.data.gemfire.search.lucene.LuceneIndexFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class LuceneIndexParser
extends AbstractSingleBeanDefinitionParser {
    LuceneIndexParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return LuceneIndexFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        ParsingUtils.setCacheReference(element, builder);
        ParsingUtils.setPropertyValue(element, builder, "name", "indexName");
        ParsingUtils.setPropertyValue(element, builder, "destroy");
        ParsingUtils.setPropertyReference(element, builder, "lucene-service-ref", "luceneService");
        ParsingUtils.setPropertyReference(element, builder, "region-ref", "region");
        ParsingUtils.setPropertyValue(element, builder, "region-path");
        Optional.ofNullable(element.getAttribute("fields")).filter(StringUtils::hasText).ifPresent(fields -> builder.addPropertyValue("fields", Arrays.stream(fields.split(",")).map(String::trim).collect(Collectors.toList())));
        Optional.ofNullable(DomUtils.getChildElementByTagName((Element)element, (String)"field-analyzers")).ifPresent(fieldAnalyzersElement -> builder.addPropertyValue("fieldAnalyzers", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(fieldAnalyzersElement, parserContext, builder)));
    }
}

