/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.admin.functions;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.query.Index;
import org.springframework.data.gemfire.function.annotation.GemfireFunction;
import org.springframework.data.gemfire.util.CollectionUtils;

public class ListIndexesFunction {
    public static final String LIST_INDEXES_FUNCTION_ID = "ListQqlIndexesFunction";

    @GemfireFunction(id="ListQqlIndexesFunction")
    public Set<String> listIndexes() {
        return Optional.ofNullable(this.resolveCache()).map(cache -> cache.getQueryService()).map(queryService -> CollectionUtils.nullSafeCollection(queryService.getIndexes()).stream().map(Index::getName).collect(Collectors.toSet())).orElseGet(Collections::emptySet);
    }

    protected Cache resolveCache() {
        return CacheFactory.getAnyInstance();
    }
}

