/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.util.List;
import org.apache.geode.cache.FixedPartitionAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.partition.PartitionListener;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.util.CollectionUtils;

public class PartitionAttributesFactoryBean<K, V>
implements FactoryBean<PartitionAttributes<K, V>>,
InitializingBean {
    private List<PartitionListener> partitionListeners;
    private PartitionAttributes<K, V> partitionAttributes;
    private final PartitionAttributesFactory<K, V> partitionAttributesFactory = new PartitionAttributesFactory();

    public void afterPropertiesSet() throws Exception {
        for (PartitionListener listener : CollectionUtils.nullSafeList(this.partitionListeners)) {
            this.partitionAttributesFactory.addPartitionListener(listener);
        }
        this.partitionAttributes = this.partitionAttributesFactory.create();
    }

    public PartitionAttributes getObject() throws Exception {
        return this.partitionAttributes;
    }

    public Class<?> getObjectType() {
        return this.partitionAttributes != null ? this.partitionAttributes.getClass() : PartitionAttributes.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setColocatedWith(String collocatedWith) {
        this.partitionAttributesFactory.setColocatedWith(collocatedWith);
    }

    public void setFixedPartitionAttributes(List<FixedPartitionAttributes> fixedPartitionAttributes) {
        for (FixedPartitionAttributes fixedPartitionAttributesElement : CollectionUtils.nullSafeList(fixedPartitionAttributes)) {
            this.partitionAttributesFactory.addFixedPartitionAttributes(fixedPartitionAttributesElement);
        }
    }

    public void setLocalMaxMemory(int mb) {
        this.partitionAttributesFactory.setLocalMaxMemory(mb);
    }

    public void setPartitionListeners(List<PartitionListener> partitionListeners) {
        this.partitionListeners = partitionListeners;
    }

    public void setPartitionResolver(PartitionResolver resolver) {
        this.partitionAttributesFactory.setPartitionResolver(resolver);
    }

    public void setRecoveryDelay(long recoveryDelay) {
        this.partitionAttributesFactory.setRecoveryDelay(recoveryDelay);
    }

    public void setRedundantCopies(int redundantCopies) {
        this.partitionAttributesFactory.setRedundantCopies(redundantCopies);
    }

    public void setStartupRecoveryDelay(long startupRecoveryDelay) {
        this.partitionAttributesFactory.setStartupRecoveryDelay(startupRecoveryDelay);
    }

    public void setTotalMaxMemory(long mb) {
        this.partitionAttributesFactory.setTotalMaxMemory(mb);
    }

    public void setTotalNumBuckets(int numBuckets) {
        this.partitionAttributesFactory.setTotalNumBuckets(numBuckets);
    }
}

