/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.query.GemfireQueryCreator;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.gemfire.repository.query.StringBasedGemfireRepositoryQuery;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeGemfireRepositoryQuery
extends GemfireRepositoryQuery {
    private final GemfireQueryMethod method;
    private final PartTree tree;
    private final GemfireTemplate template;

    public PartTreeGemfireRepositoryQuery(GemfireQueryMethod method, GemfireTemplate template) {
        super(method);
        Class domainClass = method.getEntityInformation().getJavaType();
        this.tree = new PartTree(method.getName(), domainClass);
        this.method = method;
        this.template = template;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor parameterAccessor = new ParametersParameterAccessor(this.method.getParameters(), parameters);
        QueryString query = new GemfireQueryCreator(this.tree, this.method.getPersistentEntity()).createQuery(parameterAccessor.getSort());
        GemfireRepositoryQuery repositoryQuery = this.newRepositoryQuery(query, this.method, this.template);
        return repositoryQuery.execute(this.prepareStringParameters(parameters));
    }

    private GemfireRepositoryQuery newRepositoryQuery(QueryString query, GemfireQueryMethod queryMethod, GemfireTemplate template) {
        StringBasedGemfireRepositoryQuery repositoryQuery = new StringBasedGemfireRepositoryQuery(query.toString(), queryMethod, template);
        repositoryQuery.register(this.getQueryPostProcessor());
        return repositoryQuery;
    }

    private Object[] prepareStringParameters(Object[] parameters) {
        Iterator partsIterator = this.tree.getParts().iterator();
        ArrayList<Object> stringParameters = new ArrayList<Object>(parameters.length);
        block5: for (Object parameter : parameters) {
            if (parameter == null || parameter instanceof Sort) {
                stringParameters.add(parameter);
                continue;
            }
            switch (((Part)partsIterator.next()).getType()) {
                case CONTAINING: {
                    stringParameters.add(String.format("%%%s%%", parameter.toString()));
                    continue block5;
                }
                case STARTING_WITH: {
                    stringParameters.add(String.format("%s%%", parameter.toString()));
                    continue block5;
                }
                case ENDING_WITH: {
                    stringParameters.add(String.format("%%%s", parameter.toString()));
                    continue block5;
                }
                default: {
                    stringParameters.add(parameter);
                }
            }
        }
        return stringParameters.toArray();
    }
}

