/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.AbstractCacheConfiguration;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class EmbeddedServiceConfigurationSupport
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    public static final Integer DEFAULT_PORT = 0;
    public static final String DEFAULT_HOST = "localhost";
    @Autowired
    private AbstractCacheConfiguration cacheConfiguration;
    private BeanFactory beanFactory;

    protected <T extends AbstractCacheConfiguration> T cacheConfiguration() {
        Assert.state((this.cacheConfiguration != null ? 1 : 0) != 0, (String)"AbstractCacheConfiguration was not properly initialized");
        return (T)this.cacheConfiguration;
    }

    protected abstract Class getAnnotationType();

    protected String getAnnotationTypeName() {
        return this.getAnnotationType().getName();
    }

    protected String getAnnotationTypeSimpleName() {
        return this.getAnnotationType().getSimpleName();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory was not properly initialized");
        return this.beanFactory;
    }

    public final void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            Map<String, Object> annotationAttributes = this.getAnnotationAttributes(importingClassMetadata);
            this.registerBeanDefinitions(importingClassMetadata, annotationAttributes, registry);
            this.setGemFireProperties(importingClassMetadata, annotationAttributes, registry);
        }
    }

    protected void registerBeanDefinitions(AnnotationMetadata importingClassMetaData, Map<String, Object> annotationAttributes, BeanDefinitionRegistry registry) {
    }

    protected void setGemFireProperties(AnnotationMetadata importingClassMetadata, Map<String, Object> annotationAttributes, BeanDefinitionRegistry registry) {
        Properties gemfireProperties = this.toGemFireProperties(annotationAttributes);
        if (this.hasProperties(gemfireProperties)) {
            try {
                ((AbstractCacheConfiguration)this.cacheConfiguration()).add(gemfireProperties);
            }
            catch (Exception ignore) {
                this.registerGemFirePropertiesBeanPostProcessor(registry, gemfireProperties);
            }
        }
    }

    protected abstract Properties toGemFireProperties(Map<String, Object> var1);

    protected boolean isAnnotationPresent(AnnotationMetadata importingClassMetadata) {
        return importingClassMetadata.hasAnnotation(this.getAnnotationTypeName());
    }

    protected boolean hasProperties(Properties properties) {
        return !CollectionUtils.isEmpty((Map)properties);
    }

    protected Map<String, Object> getAnnotationAttributes(AnnotationMetadata importingClassMetadata) {
        return importingClassMetadata.getAnnotationAttributes(this.getAnnotationTypeName());
    }

    protected void registerGemFirePropertiesBeanPostProcessor(BeanDefinitionRegistry registry, Properties customGemFireProperties) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GemFirePropertiesBeanPostProcessor.class);
        builder.addConstructorArgValue((Object)customGemFireProperties);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)this.newBeanDefinitionHolder(builder), (BeanDefinitionRegistry)registry);
    }

    protected BeanDefinitionHolder newBeanDefinitionHolder(BeanDefinitionBuilder builder) {
        return new BeanDefinitionHolder((BeanDefinition)builder.getBeanDefinition(), this.generateBeanName());
    }

    protected String generateBeanName() {
        return this.generateBeanName(this.getAnnotationTypeSimpleName());
    }

    protected String generateBeanName(Class<?> typeQualifier) {
        return this.generateBeanName(typeQualifier.getSimpleName());
    }

    protected String generateBeanName(String nameQualifier) {
        return String.format("%1$s.%2$s", this.getClass().getName(), nameQualifier);
    }

    protected <T> T resolveBean(Class<T> beanType) {
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            AutowireCapableBeanFactory autowiringBeanFactory = (AutowireCapableBeanFactory)beanFactory;
            NamedBeanHolder beanHolder = autowiringBeanFactory.resolveNamedBean(beanType);
            return (T)autowiringBeanFactory.configureBean(beanHolder.getBeanInstance(), beanHolder.getBeanName());
        }
        return (T)beanFactory.getBean(beanType);
    }

    protected String resolveHost(String hostname) {
        return this.resolveHost(hostname, DEFAULT_HOST);
    }

    protected String resolveHost(String hostname, String defaultHostname) {
        return StringUtils.hasText((String)hostname) ? hostname : defaultHostname;
    }

    protected Integer resolvePort(Integer port) {
        return this.resolvePort(port, DEFAULT_PORT);
    }

    protected Integer resolvePort(Integer port, Integer defaultPort) {
        return port != null ? port : defaultPort;
    }

    protected static class GemFirePropertiesBeanPostProcessor
    implements BeanPostProcessor {
        protected static final String GEMFIRE_PROPERTIES_BEAN_NAME = "gemfireProperties";
        private final Properties gemfireProperties;

        protected GemFirePropertiesBeanPostProcessor(Properties gemfireProperties) {
            Assert.notEmpty((Map)gemfireProperties, (String)"GemFire Properties must not be null or empty");
            this.gemfireProperties = gemfireProperties;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof Properties && GEMFIRE_PROPERTIES_BEAN_NAME.equals(beanName)) {
                Properties gemfirePropertiesBean = (Properties)bean;
                gemfirePropertiesBean.putAll((Map<?, ?>)this.gemfireProperties);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

