/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableAuth;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class AuthConfiguration
extends EmbeddedServiceConfigurationSupport {
    public static final int DEFAULT_PEER_VERIFY_MEMBER_TIMEOUT = 1000;
    public static final String DEFAULT_SECURITY_LOG_LEVEL = "config";

    @Override
    protected Class getAnnotationType() {
        return EnableAuth.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        gemfireProperties.setProperty("gemfireSecurityPropertyFile", annotationAttributes.get("securityPropertiesFile"));
        gemfireProperties.setProperty("security-client-accessor", annotationAttributes.get("clientAccessor"));
        gemfireProperties.setProperty("security-client-accessor-pp", annotationAttributes.get("clientAccessPostOperation"));
        gemfireProperties.setProperty("security-client-auth-init", annotationAttributes.get("clientAuthenticationInitializer"));
        gemfireProperties.setProperty("security-client-authenticator", annotationAttributes.get("clientAuthenticator"));
        gemfireProperties.setProperty("security-client-dhalgo", annotationAttributes.get("clientDiffieHellmanAlgorithm"));
        gemfireProperties.setProperty("security-peer-auth-init", annotationAttributes.get("peerAuthenticationInitializer"));
        gemfireProperties.setProperty("security-peer-authenticator", annotationAttributes.get("peerAuthenticator"));
        gemfireProperties.setPropertyIfNotDefault("security-peer-verifymember-timeout", annotationAttributes.get("peerVerifyMemberTimeout"), 1000);
        gemfireProperties.setProperty("security-log-file", annotationAttributes.get("securityLogFile"));
        gemfireProperties.setPropertyIfNotDefault("security-log-level", annotationAttributes.get("securityLogLevel"), DEFAULT_SECURITY_LOG_LEVEL);
        return gemfireProperties.build();
    }
}

