/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import com.gemstone.gemfire.cache.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QueryString {
    protected static final Pattern HINT_PATTERN = Pattern.compile("<HINT '\\w+'(, '\\w+')*>");
    protected static final Pattern IMPORT_PATTERN = Pattern.compile("IMPORT .+;");
    protected static final Pattern LIMIT_PATTERN = Pattern.compile("LIMIT \\d+");
    protected static final Pattern TRACE_PATTERN = Pattern.compile("<TRACE>");
    private static final String HINTS_QUERY_TEMPLATE = "<HINT %1$s> %2$s";
    private static final String IMPORT_QUERY_TEMPLATE = "IMPORT %1$s; %2$s";
    private static final String LIMIT_QUERY_TEMPLATE = "%1$s LIMIT %2$d";
    private static final String SELECT_QUERY_TEMPLATE = "SELECT %1$s FROM /%2$s";
    private static final String TRACE_QUERY_TEMPLATE = "<TRACE> %1$s";
    private static final String IN_PATTERN = "(?<=IN (SET|LIST) )\\$\\d";
    private static final String IN_PARAMETER_PATTERN = "(?<=IN (SET|LIST) \\$)\\d";
    private static final String REGION_PATTERN = "\\/(\\/?\\w)+";
    private final String query;

    public QueryString(String source) {
        Assert.hasText((String)source, (String)"The OQL statement (Query) to execute must be specified!");
        this.query = source;
    }

    public QueryString(Class<?> domainClass) {
        this(domainClass, false);
    }

    public QueryString(Class<?> domainClass, boolean isCountQuery) {
        this(String.format(SELECT_QUERY_TEMPLATE, isCountQuery ? "count(*)" : "*", domainClass.getSimpleName()));
    }

    public QueryString bindIn(Collection<?> values) {
        if (values != null) {
            String valueString = StringUtils.collectionToDelimitedString(values, (String)", ", (String)"'", (String)"'");
            return new QueryString(this.query.replaceFirst(IN_PATTERN, String.format("(%s)", valueString)));
        }
        return this;
    }

    public QueryString forRegion(Class<?> domainClass, Region<?, ?> region) {
        return new QueryString(this.query.replaceAll(REGION_PATTERN, region.getFullPath()));
    }

    public Iterable<Integer> getInParameterIndexes() {
        Pattern pattern = Pattern.compile(IN_PARAMETER_PATTERN);
        Matcher matcher = pattern.matcher(this.query);
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (matcher.find()) {
            result.add(Integer.parseInt(matcher.group()));
        }
        return result;
    }

    public QueryString orderBy(Sort sort) {
        if (sort != null) {
            StringBuilder orderClause = new StringBuilder("ORDER BY ");
            int count = 0;
            for (Sort.Order order : sort) {
                orderClause.append(count++ > 0 ? ", " : "");
                orderClause.append(String.format("%1$s %2$s", order.getProperty(), order.getDirection()));
            }
            return new QueryString(String.format("%1$s %2$s", this.query, orderClause.toString()));
        }
        return this;
    }

    public QueryString withHints(String ... hints) {
        if (!ObjectUtils.isEmpty((Object[])hints)) {
            StringBuilder builder = new StringBuilder();
            for (String hint : hints) {
                builder.append(builder.length() > 0 ? ", " : "");
                builder.append(String.format("'%1$s'", hint));
            }
            return new QueryString(String.format(HINTS_QUERY_TEMPLATE, builder.toString(), this.query));
        }
        return this;
    }

    public QueryString withImport(String importExpression) {
        return StringUtils.hasText((String)importExpression) ? new QueryString(String.format(IMPORT_QUERY_TEMPLATE, importExpression, this.query)) : this;
    }

    public QueryString withLimit(Integer limit) {
        return limit != null ? new QueryString(String.format(LIMIT_QUERY_TEMPLATE, this.query, limit)) : this;
    }

    public QueryString withTrace() {
        return new QueryString(String.format(TRACE_QUERY_TEMPLATE, this.query));
    }

    public String toString() {
        return this.query;
    }
}

