/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.LossAction;
import com.gemstone.gemfire.cache.MembershipAttributes;
import com.gemstone.gemfire.cache.ResumptionAction;
import com.gemstone.gemfire.cache.Scope;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.config.EvictionAttributesFactoryBean;
import org.springframework.data.gemfire.config.EvictionType;
import org.springframework.data.gemfire.config.SubscriptionAttributesFactoryBean;
import org.springframework.data.gemfire.config.SubscriptionType;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class ParsingUtils {
    private static final Log log = LogFactory.getLog(ParsingUtils.class);

    ParsingUtils() {
    }

    static void setPropertyReference(Element element, BeanDefinitionBuilder builder, String attributeName, String propertyName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyReference(propertyName, attributeValue);
        }
    }

    static void setPropertyReference(Element element, BeanDefinitionBuilder builder, String attributeName) {
        ParsingUtils.setPropertyReference(element, builder, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attributeName, String propertyName, Object defaultValue) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyValue(propertyName, (Object)attributeValue);
        } else if (defaultValue != null) {
            builder.addPropertyValue(propertyName, defaultValue);
        }
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attributeName, String propertyName) {
        ParsingUtils.setPropertyValue(element, builder, attributeName, propertyName, null);
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attributeName) {
        ParsingUtils.setPropertyValue(element, builder, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    static void setPropertyValue(BeanDefinitionBuilder builder, BeanDefinition source, String propertyName, boolean withDependsOn) {
        PropertyValue propertyValue = source.getPropertyValues().getPropertyValue(propertyName);
        if (propertyValue != null) {
            builder.addPropertyValue(propertyValue.getName(), propertyValue.getValue());
            if (withDependsOn && propertyValue.getValue() instanceof RuntimeBeanReference) {
                builder.addDependsOn(((RuntimeBeanReference)propertyValue.getValue()).getBeanName());
            }
        }
    }

    static void setPropertyValue(BeanDefinitionBuilder builder, BeanDefinition source, String propertyName) {
        ParsingUtils.setPropertyValue(builder, source, propertyName, false);
    }

    static Object parseRefOrNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, element, builder, "ref", false);
    }

    static Object getBeanReference(ParserContext parserContext, Element element, String refAttributeName) {
        String refAttributeValue = element.getAttribute(refAttributeName);
        List childElements = DomUtils.getChildElements((Element)element);
        if (StringUtils.hasText((String)refAttributeValue)) {
            if (!childElements.isEmpty()) {
                parserContext.getReaderContext().error(String.format("Use either the '%1$s' attribute or a nested bean declaration for '%2$s' element, but not both.", refAttributeName, element.getLocalName()), (Object)element);
            }
            return new RuntimeBeanReference(refAttributeValue);
        }
        return null;
    }

    static Object parseRefOrNestedCustomElement(ParserContext parserContext, Element element, BeanDefinitionBuilder builder) {
        Object beanRef = ParsingUtils.getBeanReference(parserContext, element, "bean");
        return beanRef != null ? beanRef : parserContext.getDelegate().parseCustomElement(element, (BeanDefinition)builder.getBeanDefinition());
    }

    static Object parseRefOrSingleNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, element, builder, "ref", true);
    }

    static Object parseRefOrNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder, String refAttributeName) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, element, builder, refAttributeName, false);
    }

    static Object parseRefOrNestedBeanDeclaration(ParserContext parserContext, Element element, BeanDefinitionBuilder builder, String refAttributeName, boolean single) {
        Object beanReference = ParsingUtils.getBeanReference(parserContext, element, refAttributeName);
        if (beanReference != null) {
            return beanReference;
        }
        List childElements = DomUtils.getChildElements((Element)element);
        if (childElements.size() == 1) {
            return parserContext.getDelegate().parsePropertySubElement((Element)childElements.get(0), (BeanDefinition)builder.getRawBeanDefinition());
        }
        if (single) {
            parserContext.getReaderContext().error(String.format("The element '%1$s' does not support multiple nested bean definitions.", element.getLocalName()), (Object)element);
        }
        ManagedList list = new ManagedList();
        for (Element childElement : childElements) {
            list.add(parserContext.getDelegate().parsePropertySubElement(childElement, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        return list;
    }

    static boolean parseEviction(ParserContext parserContext, Element element, BeanDefinitionBuilder regionAttributesBuilder) {
        Element evictionElement = DomUtils.getChildElementByTagName((Element)element, (String)"eviction");
        if (evictionElement != null) {
            Element objectSizerElement;
            BeanDefinitionBuilder evictionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(EvictionAttributesFactoryBean.class);
            ParsingUtils.setPropertyValue(evictionElement, evictionAttributesBuilder, "action");
            ParsingUtils.setPropertyValue(evictionElement, evictionAttributesBuilder, "threshold");
            String evictionType = evictionElement.getAttribute("type");
            if (StringUtils.hasText((String)evictionType)) {
                evictionAttributesBuilder.addPropertyValue("type", (Object)EvictionType.valueOf(evictionType.toUpperCase()));
            }
            if ((objectSizerElement = DomUtils.getChildElementByTagName((Element)evictionElement, (String)"object-sizer")) != null) {
                Object sizer = ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, objectSizerElement, evictionAttributesBuilder);
                evictionAttributesBuilder.addPropertyValue("ObjectSizer", sizer);
            }
            regionAttributesBuilder.addPropertyValue("evictionAttributes", (Object)evictionAttributesBuilder.getBeanDefinition());
            return true;
        }
        return false;
    }

    static boolean parseSubscription(ParserContext parserContext, Element element, BeanDefinitionBuilder regionAttributesBuilder) {
        Element subscriptionElement = DomUtils.getChildElementByTagName((Element)element, (String)"subscription");
        if (subscriptionElement != null) {
            BeanDefinitionBuilder subscriptionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(SubscriptionAttributesFactoryBean.class);
            String type = subscriptionElement.getAttribute("type");
            if (StringUtils.hasText((String)type)) {
                subscriptionAttributesBuilder.addPropertyValue("type", (Object)SubscriptionType.valueOf(type.toUpperCase()));
            }
            regionAttributesBuilder.addPropertyValue("subscriptionAttributes", (Object)subscriptionAttributesBuilder.getBeanDefinition());
            return true;
        }
        return false;
    }

    static void parseTransportFilters(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element transportFilterElement = DomUtils.getChildElementByTagName((Element)element, (String)"transport-filter");
        if (transportFilterElement != null) {
            builder.addPropertyValue("transportFilters", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, transportFilterElement, builder));
        }
    }

    static void parseStatistics(Element element, BeanDefinitionBuilder attrBuilder) {
        ParsingUtils.setPropertyValue(element, attrBuilder, "statistics", "statisticsEnabled");
    }

    static boolean parseExpiration(ParserContext parserContext, Element element, BeanDefinitionBuilder regionAttributesBuilder) {
        boolean result = ParsingUtils.parseExpiration(element, "region-ttl", "regionTimeToLive", regionAttributesBuilder);
        result |= ParsingUtils.parseExpiration(element, "region-tti", "regionIdleTimeout", regionAttributesBuilder);
        result |= ParsingUtils.parseExpiration(element, "entry-ttl", "entryTimeToLive", regionAttributesBuilder);
        result |= ParsingUtils.parseExpiration(element, "entry-tti", "entryIdleTimeout", regionAttributesBuilder);
        result |= ParsingUtils.parseCustomExpiration(element, parserContext, "custom-entry-ttl", "customEntryTimeToLive", regionAttributesBuilder);
        if (result |= ParsingUtils.parseCustomExpiration(element, parserContext, "custom-entry-tti", "customEntryIdleTimeout", regionAttributesBuilder)) {
            regionAttributesBuilder.addPropertyValue("statisticsEnabled", (Object)Boolean.TRUE);
        }
        return result;
    }

    static void parseOptionalRegionAttributes(ParserContext parserContext, Element element, BeanDefinitionBuilder regionAttributesBuilder) {
        String concurrencyChecksEnabled;
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "cloning-enabled");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "concurrency-level");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "disk-synchronous");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "enable-async-conflation");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "enable-subscription-conflation");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "ignore-jta", "ignoreJTA");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "initial-capacity");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "is-lock-grantor", "lockGrantor");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "key-constraint");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "load-factor");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "multicast-enabled");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "publisher");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "value-constraint");
        String indexUpdateType = element.getAttribute("index-update-type");
        if (StringUtils.hasText((String)indexUpdateType)) {
            regionAttributesBuilder.addPropertyValue("indexMaintenanceSynchronous", (Object)"synchronous".equals(indexUpdateType));
        }
        if (StringUtils.hasText((String)(concurrencyChecksEnabled = element.getAttribute("concurrency-checks-enabled")))) {
            if (GemfireUtils.isGemfireVersion7OrAbove()) {
                ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "concurrency-checks-enabled");
            } else {
                log.warn((Object)"Setting 'concurrency-checks-enabled' is only available in Gemfire 7.0 or above!");
            }
        }
    }

    static void parseMembershipAttributes(ParserContext parserContext, Element element, BeanDefinitionBuilder regionAttributesBuilder) {
        Element membershipAttributes = DomUtils.getChildElementByTagName((Element)element, (String)"membership-attributes");
        if (membershipAttributes != null) {
            String[] requiredRoles = StringUtils.commaDelimitedListToStringArray((String)membershipAttributes.getAttribute("required-roles"));
            String lossActionValue = membershipAttributes.getAttribute("loss-action");
            LossAction lossAction = StringUtils.hasText((String)lossActionValue) ? LossAction.fromName((String)lossActionValue.toUpperCase().replace("-", "_")) : LossAction.NO_ACCESS;
            String resumptionActionValue = membershipAttributes.getAttribute("resumption-action");
            ResumptionAction resumptionAction = StringUtils.hasText((String)resumptionActionValue) ? ResumptionAction.fromName((String)resumptionActionValue.toUpperCase().replace("-", "_")) : ResumptionAction.REINITIALIZE;
            regionAttributesBuilder.addPropertyValue("membershipAttributes", (Object)new MembershipAttributes(requiredRoles, lossAction, resumptionAction));
        }
    }

    static void throwExceptionIfNotGemfireV7(String elementName, String attributeName, ParserContext parserContext) {
        if (!GemfireUtils.isGemfireVersion7OrAbove()) {
            String messagePrefix = attributeName != null ? String.format("Attribute '%1$s' of element '%2$s'", attributeName, elementName) : String.format("Element '%1$s'", elementName);
            parserContext.getReaderContext().error(String.format("%1$s requires GemFire version 7 or later. The current version is %2$s.", messagePrefix, GemfireUtils.GEMFIRE_VERSION), null);
        }
    }

    static void parseScope(Element element, BeanDefinitionBuilder builder) {
        String scopeAttributeValue = element.getAttribute("scope");
        if (StringUtils.hasText((String)scopeAttributeValue)) {
            builder.addPropertyValue("scope", (Object)Scope.fromString((String)scopeAttributeValue.toUpperCase().replace("-", "_")));
        }
    }

    private static boolean parseExpiration(Element rootElement, String elementName, String propertyName, BeanDefinitionBuilder regionAttributesBuilder) {
        Element expirationElement = DomUtils.getChildElementByTagName((Element)rootElement, (String)elementName);
        if (expirationElement != null) {
            String timeoutAttribute = expirationElement.getAttribute("timeout");
            String expirationTimeout = StringUtils.hasText((String)timeoutAttribute) ? timeoutAttribute : null;
            String actionAttribute = StringUtils.trimAllWhitespace((String)expirationElement.getAttribute("action"));
            ExpirationAction expirationAction = "DESTROY".equalsIgnoreCase(actionAttribute) ? ExpirationAction.DESTROY : ("LOCAL_DESTROY".equalsIgnoreCase(actionAttribute) ? ExpirationAction.LOCAL_DESTROY : ("LOCAL_INVALIDATE".equalsIgnoreCase(actionAttribute) ? ExpirationAction.LOCAL_INVALIDATE : ExpirationAction.INVALIDATE));
            BeanDefinitionBuilder expirationAttributes = BeanDefinitionBuilder.genericBeanDefinition(ExpirationAttributes.class);
            expirationAttributes.addConstructorArgValue((Object)expirationTimeout);
            expirationAttributes.addConstructorArgValue((Object)expirationAction);
            regionAttributesBuilder.addPropertyValue(propertyName, (Object)expirationAttributes.getBeanDefinition());
            return true;
        }
        return false;
    }

    private static boolean parseCustomExpiration(Element rootElement, ParserContext parserContext, String elementName, String propertyName, BeanDefinitionBuilder regionAttributesBuilder) {
        Element expirationElement = DomUtils.getChildElementByTagName((Element)rootElement, (String)elementName);
        if (expirationElement != null) {
            Object customExpiry = ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, expirationElement, regionAttributesBuilder);
            regionAttributesBuilder.addPropertyValue(propertyName, customExpiry);
            return true;
        }
        return false;
    }

    static String resolveCacheReference(String cacheRef) {
        return StringUtils.hasText((String)cacheRef) ? cacheRef : "gemfireCache";
    }
}

