/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.support.StringObjectMap;
import org.springframework.util.Assert;

public class DefaultStringObjectMap<T extends StringObjectMap<T>>
implements StringObjectMap<T> {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final LinkedHashMap<String, Object> delegate;

    public DefaultStringObjectMap() {
        this(new LinkedHashMap());
    }

    public DefaultStringObjectMap(Map<String, ?> map) {
        this.delegate = new LinkedHashMap(map);
    }

    @Override
    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot render document to JSON", e);
        }
    }

    @Override
    public T fromJson(String json) {
        Assert.notNull((Object)json, (String)"JSON must not be null");
        this.delegate.clear();
        try {
            this.delegate.putAll((Map)OBJECT_MAPPER.readerFor(Map.class).readValue(json));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot parse JSON", e);
        }
        return (T)this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public @Nullable Object get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public Object put(String key, Object value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.delegate.forEach(action);
    }

    public String toString() {
        return "DefaultStringObjectMap: " + this.toJson();
    }

    public @Nullable Object path(String path) {
        Assert.notNull((Object)path, (String)"path must not be null");
        Map<String, Object> current = this;
        String[] segments = path.split("\\.");
        for (int i = 0; i < segments.length; ++i) {
            Object currentObject;
            String segment = segments[i];
            if (current.containsKey(segment)) {
                currentObject = current.get(segment);
                if (i == segments.length - 1) {
                    return currentObject;
                }
                if (!(currentObject instanceof Map)) {
                    return null;
                }
            } else {
                return null;
            }
            current = (Map)currentObject;
        }
        return null;
    }
}

