/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.annotations.Dynamic;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.mapping.Alias;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.FieldNamingStrategy;

public interface ElasticsearchPersistentEntity<T>
extends PersistentEntity<T, ElasticsearchPersistentProperty> {
    public IndexCoordinates getIndexCoordinates();

    public Set<Alias> getAliases();

    public short getShards();

    public short getReplicas();

    public boolean isUseServerConfiguration();

    public @Nullable String getRefreshInterval();

    public @Nullable String getIndexStoreType();

    public @Nullable ElasticsearchPersistentProperty getVersionProperty();

    public @Nullable String settingPath();

    public  @Nullable Document.VersionType getVersionType();

    public boolean isCreateIndexAndMapping();

    public @Nullable ElasticsearchPersistentProperty getPersistentPropertyWithFieldName(String var1);

    public boolean hasSeqNoPrimaryTermProperty();

    public boolean hasJoinFieldProperty();

    public @Nullable ElasticsearchPersistentProperty getSeqNoPrimaryTermProperty();

    public @Nullable ElasticsearchPersistentProperty getJoinFieldProperty();

    default public ElasticsearchPersistentProperty getRequiredSeqNoPrimaryTermProperty() {
        ElasticsearchPersistentProperty property = this.getSeqNoPrimaryTermProperty();
        if (property != null) {
            return property;
        }
        throw new IllegalStateException(String.format("Required SeqNoPrimaryTerm property not found for %s!", this.getType()));
    }

    public @Nullable ElasticsearchPersistentProperty getIndexedIndexNameProperty();

    public Settings getDefaultSettings();

    public @Nullable String resolveRouting(T var1);

    public FieldNamingStrategy getFieldNamingStrategy();

    public boolean writeTypeHints();

    public Dynamic dynamic();

    public boolean storeIdInSource();

    public boolean storeVersionInSource();

    public boolean isAlwaysWriteMapping();
}

