/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

public class AliasActionParameters {
    private final String[] indices;
    private final @Nullable String[] aliases;
    private final @Nullable Query filterQuery;
    private final @Nullable Class<?> filterQueryClass;
    private final @Nullable Boolean isHidden;
    private final @Nullable Boolean isWriteIndex;
    private final @Nullable String routing;
    private final @Nullable String indexRouting;
    private final @Nullable String searchRouting;

    private AliasActionParameters(String[] indices, @Nullable String[] aliases, @Nullable Boolean isHidden, @Nullable Boolean isWriteIndex, @Nullable String routing, @Nullable String indexRouting, @Nullable String searchRouting, @Nullable Query filterQuery, @Nullable Class<?> filterQueryClass) {
        this.indices = indices;
        this.aliases = aliases;
        this.isHidden = isHidden;
        this.isWriteIndex = isWriteIndex;
        this.routing = routing;
        this.indexRouting = indexRouting;
        this.searchRouting = searchRouting;
        this.filterQuery = filterQuery;
        this.filterQueryClass = filterQueryClass;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderForTemplate() {
        return new Builder().withIndices("");
    }

    public String[] getIndices() {
        return this.indices;
    }

    public String @Nullable [] getAliases() {
        return this.aliases;
    }

    public @Nullable Boolean getHidden() {
        return this.isHidden;
    }

    public @Nullable Boolean getWriteIndex() {
        return this.isWriteIndex;
    }

    public @Nullable String getRouting() {
        return this.routing;
    }

    public @Nullable String getIndexRouting() {
        return this.indexRouting;
    }

    public @Nullable String getSearchRouting() {
        return this.searchRouting;
    }

    public @Nullable Query getFilterQuery() {
        return this.filterQuery;
    }

    public @Nullable Class<?> getFilterQueryClass() {
        return this.filterQueryClass;
    }

    public static final class Builder {
        private String @Nullable [] indices;
        private String @Nullable [] aliases;
        private @Nullable Query filterQuery;
        private @Nullable Class<?> filterQueryClass;
        private @Nullable Boolean isHidden;
        private @Nullable Boolean isWriteIndex;
        private @Nullable String routing;
        private @Nullable String indexRouting;
        private @Nullable String searchRouting;

        private Builder() {
        }

        public Builder withIndices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public Builder withAliases(String ... aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder withFilterQuery(Query filterQuery) {
            return this.withFilterQuery(filterQuery, null);
        }

        public Builder withFilterQuery(Query filterQuery, @Nullable Class<?> filterQueryClass) {
            this.filterQuery = filterQuery;
            this.filterQueryClass = filterQueryClass;
            return this;
        }

        public Builder withIsHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        public Builder withIsWriteIndex(Boolean isWriteIndex) {
            this.isWriteIndex = isWriteIndex;
            return this;
        }

        public Builder withRouting(String routing) {
            this.routing = routing;
            return this;
        }

        public Builder withIndexRouting(String indexRouting) {
            this.indexRouting = indexRouting;
            return this;
        }

        public Builder withSearchRouting(String searchRouting) {
            this.searchRouting = searchRouting;
            return this;
        }

        public AliasActionParameters build() {
            Assert.notNull((Object)this.indices, (String)"indices must be set");
            return new AliasActionParameters(this.indices, this.aliases, this.isHidden, this.isWriteIndex, this.routing, this.indexRouting, this.searchRouting, this.filterQuery, this.filterQueryClass);
        }
    }
}

