/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.elasticsearch.annotations.Alias;
import org.springframework.data.elasticsearch.annotations.Dynamic;
import org.springframework.data.elasticsearch.annotations.WriteTypeHint;

@Persistent
@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface Document {
    public String indexName();

    public boolean createIndex() default true;

    public boolean alwaysWriteMapping() default false;

    public VersionType versionType() default VersionType.EXTERNAL;

    public WriteTypeHint writeTypeHint() default WriteTypeHint.DEFAULT;

    public Dynamic dynamic() default Dynamic.INHERIT;

    public boolean storeIdInSource() default true;

    public boolean storeVersionInSource() default true;

    public Alias[] aliases() default {};

    public static enum VersionType {
        INTERNAL("internal"),
        EXTERNAL("external"),
        EXTERNAL_GTE("external_gte");

        private final String esName;

        private VersionType(String esName) {
            this.esName = esName;
        }

        public String getEsName() {
            return this.esName;
        }
    }
}

