/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.rest5_client.Rest5ClientOptions;
import co.elastic.clients.transport.rest5_client.low_level.RequestOptions;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchClients;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.rest5_client.Rest5Clients;
import org.springframework.data.elasticsearch.config.ElasticsearchConfigurationSupport;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.util.Assert;

public abstract class ReactiveElasticsearchConfiguration
extends ElasticsearchConfigurationSupport {
    @Bean(name={"elasticsearchClientConfiguration"})
    public abstract ClientConfiguration clientConfiguration();

    @Bean
    public Rest5Client elasticsearchRestClient(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"clientConfiguration must not be null");
        return Rest5Clients.getRest5Client(clientConfiguration);
    }

    @Bean
    public ElasticsearchTransport elasticsearchTransport(Rest5Client rest5Client, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)rest5Client, (String)"restClient must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        return ElasticsearchClients.getElasticsearchTransport(rest5Client, "reactive", this.transportOptions(), jsonpMapper);
    }

    @Bean
    public ReactiveElasticsearchClient reactiveElasticsearchClient(ElasticsearchTransport transport) {
        Assert.notNull((Object)transport, (String)"transport must not be null");
        return ElasticsearchClients.createReactive(transport);
    }

    @Bean(name={"reactiveElasticsearchOperations", "reactiveElasticsearchTemplate"})
    public ReactiveElasticsearchOperations reactiveElasticsearchOperations(ElasticsearchConverter elasticsearchConverter, ReactiveElasticsearchClient reactiveElasticsearchClient) {
        ReactiveElasticsearchTemplate template = new ReactiveElasticsearchTemplate(reactiveElasticsearchClient, elasticsearchConverter);
        template.setRefreshPolicy(this.refreshPolicy());
        return template;
    }

    @Bean
    public JsonpMapper jsonpMapper() {
        ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, false).setSerializationInclusion(JsonInclude.Include.ALWAYS);
        return new JacksonJsonpMapper(objectMapper);
    }

    public TransportOptions transportOptions() {
        return new Rest5ClientOptions(RequestOptions.DEFAULT, false);
    }
}

