/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.client.elc.CriteriaQueryProcessor;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.Queries;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.StringQuery;

public abstract class AbstractQueryProcessor {
    static @Nullable Query getEsQuery(@Nullable org.springframework.data.elasticsearch.core.query.Query query, @Nullable Consumer<org.springframework.data.elasticsearch.core.query.Query> queryConverter) {
        if (query == null) {
            return null;
        }
        if (queryConverter != null) {
            queryConverter.accept(query);
        }
        Query esQuery = null;
        if (query instanceof CriteriaQuery) {
            CriteriaQuery criteriaQuery = (CriteriaQuery)query;
            esQuery = CriteriaQueryProcessor.createQuery(criteriaQuery.getCriteria());
        } else if (query instanceof StringQuery) {
            StringQuery stringQuery = (StringQuery)query;
            esQuery = Queries.wrapperQueryAsQuery(stringQuery.getSource());
        } else if (query instanceof NativeQuery) {
            NativeQuery nativeQuery = (NativeQuery)query;
            if (nativeQuery.getQuery() != null) {
                esQuery = nativeQuery.getQuery();
            } else if (nativeQuery.getSpringDataQuery() != null) {
                esQuery = AbstractQueryProcessor.getEsQuery(nativeQuery.getSpringDataQuery(), queryConverter);
            }
        } else {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        return esQuery;
    }
}

