/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support.querybyexample;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.CriteriaQueryBuilder;
import org.springframework.data.elasticsearch.repository.support.querybyexample.ExampleCriteriaMapper;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.repository.query.QueryByExampleExecutor;

public class QueryByExampleElasticsearchExecutor<T>
implements QueryByExampleExecutor<T> {
    protected ElasticsearchOperations operations;
    protected ExampleCriteriaMapper exampleCriteriaMapper;

    public QueryByExampleElasticsearchExecutor(ElasticsearchOperations operations) {
        this.operations = operations;
        this.exampleCriteriaMapper = new ExampleCriteriaMapper(operations.getElasticsearchConverter().getMappingContext());
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        CriteriaQuery criteriaQuery = ((CriteriaQueryBuilder)CriteriaQuery.builder(this.exampleCriteriaMapper.criteria(example)).withMaxResults(2)).build();
        SearchHits searchHits = this.operations.search(criteriaQuery, example.getProbeType(), this.operations.getIndexCoordinatesFor(example.getProbeType()));
        if (searchHits.getTotalHits() > 1L) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        return Optional.of(searchHits).filter(SearchHits::hasSearchHits).map(result -> (List)SearchHitSupport.unwrapSearchHits(result)).map(s -> s.get(0));
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        CriteriaQuery criteriaQuery = new CriteriaQuery(this.exampleCriteriaMapper.criteria(example));
        SearchHits searchHits = this.operations.search(criteriaQuery, example.getProbeType(), this.operations.getIndexCoordinatesFor(example.getProbeType()));
        return (List)SearchHitSupport.unwrapSearchHits(searchHits);
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        CriteriaQuery criteriaQuery = ((CriteriaQueryBuilder)CriteriaQuery.builder(this.exampleCriteriaMapper.criteria(example)).withSort(sort)).build();
        SearchHits searchHits = this.operations.search(criteriaQuery, example.getProbeType(), this.operations.getIndexCoordinatesFor(example.getProbeType()));
        return (List)SearchHitSupport.unwrapSearchHits(searchHits);
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        CriteriaQuery criteriaQuery = ((CriteriaQueryBuilder)CriteriaQuery.builder(this.exampleCriteriaMapper.criteria(example)).withPageable(pageable)).build();
        SearchHits searchHits = this.operations.search(criteriaQuery, example.getProbeType(), this.operations.getIndexCoordinatesFor(example.getProbeType()));
        SearchPage page = SearchHitSupport.searchPageFor(searchHits, criteriaQuery.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    public <S extends T> long count(Example<S> example) {
        CriteriaQuery criteriaQuery = new CriteriaQuery(this.exampleCriteriaMapper.criteria(example));
        return this.operations.count(criteriaQuery, example.getProbeType(), this.operations.getIndexCoordinatesFor(example.getProbeType()));
    }

    public <S extends T> boolean exists(Example<S> example) {
        return this.count(example) > 0L;
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        throw new UnsupportedOperationException("findBy example and queryFunction is not supported");
    }
}

