/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchShardStatistics;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.data.util.Streamable;

public interface SearchHits<T>
extends Streamable<SearchHit<T>> {
    public @Nullable AggregationsContainer<?> getAggregations();

    public float getMaxScore();

    public Duration getExecutionDuration();

    public SearchHit<T> getSearchHit(int var1);

    public List<SearchHit<T>> getSearchHits();

    public long getTotalHits();

    public TotalHitsRelation getTotalHitsRelation();

    default public boolean hasAggregations() {
        return this.getAggregations() != null;
    }

    default public boolean hasSearchHits() {
        return !this.getSearchHits().isEmpty();
    }

    public @Nullable Suggest getSuggest();

    default public boolean hasSuggest() {
        return this.getSuggest() != null;
    }

    default public Iterator<SearchHit<T>> iterator() {
        return this.getSearchHits().iterator();
    }

    public @Nullable String getPointInTimeId();

    public @Nullable SearchShardStatistics getSearchShardStatistics();
}

