/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.annotations.SearchTemplateQuery;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.query.RepositoryPartQuery;
import org.springframework.data.elasticsearch.repository.query.RepositorySearchTemplateQuery;
import org.springframework.data.elasticsearch.repository.query.RepositoryStringQuery;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformationCreator;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformationCreatorImpl;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchRepositoryMetadata;
import org.springframework.data.elasticsearch.repository.support.SimpleElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.querybyexample.QueryByExampleElasticsearchExecutor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryByExampleExecutor;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

public class ElasticsearchRepositoryFactory
extends RepositoryFactorySupport {
    private final ElasticsearchOperations elasticsearchOperations;
    private final ElasticsearchEntityInformationCreator entityInformationCreator;

    public ElasticsearchRepositoryFactory(ElasticsearchOperations elasticsearchOperations) {
        Assert.notNull((Object)elasticsearchOperations, (String)"ElasticsearchOperations must not be null!");
        this.elasticsearchOperations = elasticsearchOperations;
        this.entityInformationCreator = new ElasticsearchEntityInformationCreatorImpl(elasticsearchOperations.getElasticsearchConverter().getMappingContext());
    }

    public <T, ID> ElasticsearchEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.entityInformationCreator.getEntityInformation(domainClass);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.getEntityInformation(metadata.getDomainType()), this.elasticsearchOperations});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (ElasticsearchRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            throw new IllegalArgumentException("QueryDsl Support has not been implemented yet.");
        }
        return SimpleElasticsearchRepository.class;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new ElasticsearchQueryLookupStrategy(valueExpressionDelegate));
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repositoryInterface) {
        return new ElasticsearchRepositoryMetadata(repositoryInterface);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        RepositoryComposition.RepositoryFragments fragments = RepositoryComposition.RepositoryFragments.empty();
        if (QueryByExampleExecutor.class.isAssignableFrom(metadata.getRepositoryInterface())) {
            fragments = fragments.append(RepositoryFragment.implemented(QueryByExampleExecutor.class, (Object)((QueryByExampleExecutor)this.instantiateClass(QueryByExampleElasticsearchExecutor.class, new Object[]{this.elasticsearchOperations}))));
        }
        return fragments;
    }

    private class ElasticsearchQueryLookupStrategy
    implements QueryLookupStrategy {
        private final ValueExpressionDelegate valueExpressionDelegate;

        ElasticsearchQueryLookupStrategy(ValueExpressionDelegate valueExpressionDelegate) {
            this.valueExpressionDelegate = valueExpressionDelegate;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            ElasticsearchQueryMethod queryMethod = new ElasticsearchQueryMethod(method, metadata, factory, ElasticsearchRepositoryFactory.this.elasticsearchOperations.getElasticsearchConverter().getMappingContext());
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new RepositoryStringQuery(queryMethod, ElasticsearchRepositoryFactory.this.elasticsearchOperations, namedQuery, this.valueExpressionDelegate);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new RepositoryStringQuery(queryMethod, ElasticsearchRepositoryFactory.this.elasticsearchOperations, queryMethod.getAnnotatedQuery(), this.valueExpressionDelegate);
            }
            if (queryMethod.hasAnnotatedSearchTemplateQuery()) {
                SearchTemplateQuery searchTemplateQuery = queryMethod.getAnnotatedSearchTemplateQuery();
                return new RepositorySearchTemplateQuery(queryMethod, ElasticsearchRepositoryFactory.this.elasticsearchOperations, this.valueExpressionDelegate, searchTemplateQuery.id());
            }
            return new RepositoryPartQuery(queryMethod, ElasticsearchRepositoryFactory.this.elasticsearchOperations, this.valueExpressionDelegate);
        }
    }
}

