/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.sql;

import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SqlResponse {
    private final boolean running;
    private final boolean partial;
    private final @Nullable String cursor;
    private final List<Column> columns;
    private final List<Row> rows;

    private SqlResponse(Builder builder) {
        this.running = builder.running;
        this.partial = builder.partial;
        this.cursor = builder.cursor;
        this.columns = Collections.unmodifiableList(builder.columns);
        this.rows = Collections.unmodifiableList(builder.rows);
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public @Nullable String getCursor() {
        return this.cursor;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean running;
        private boolean partial;
        private @Nullable String cursor;
        private final List<Column> columns = new ArrayList<Column>();
        private final List<Row> rows = new ArrayList<Row>();

        private Builder() {
        }

        public Builder withRunning(boolean running) {
            this.running = running;
            return this;
        }

        public Builder withPartial(boolean partial) {
            this.partial = partial;
            return this;
        }

        public Builder withCursor(@Nullable String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder withColumns(List<Column> columns) {
            this.columns.addAll(columns);
            return this;
        }

        public Builder withColumn(Column column) {
            this.columns.add(column);
            return this;
        }

        public Builder withRows(List<Row> rows) {
            this.rows.addAll(rows);
            return this;
        }

        public Builder withRow(Row row) {
            this.rows.add(row);
            return this;
        }

        public SqlResponse build() {
            return new SqlResponse(this);
        }
    }

    public static class Row
    implements Iterable<Map.Entry<Column, JsonValue>> {
        private final Map<Column, JsonValue> row;

        private Row(Builder builder) {
            this.row = builder.row;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public @NonNull Iterator<Map.Entry<Column, JsonValue>> iterator() {
            return this.row.entrySet().iterator();
        }

        public @Nullable JsonValue get(Column column) {
            return this.row.get(column);
        }

        public static class Builder {
            private final Map<Column, JsonValue> row = new HashMap<Column, JsonValue>();

            public Builder withValue(Column column, JsonValue value) {
                this.row.put(column, value);
                return this;
            }

            public Row build() {
                return new Row(this);
            }
        }
    }

    public record Column(String name, String type) {
    }
}

