/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.BulkIndexByScrollFailure;
import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.cluster.ComponentTemplate;
import co.elastic.clients.elasticsearch.cluster.ComponentTemplateNode;
import co.elastic.clients.elasticsearch.cluster.ComponentTemplateSummary;
import co.elastic.clients.elasticsearch.cluster.GetComponentTemplateResponse;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.GetScriptResponse;
import co.elastic.clients.elasticsearch.core.UpdateByQueryResponse;
import co.elastic.clients.elasticsearch.core.mget.MultiGetError;
import co.elastic.clients.elasticsearch.core.mget.MultiGetResponseItem;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.AliasDefinition;
import co.elastic.clients.elasticsearch.indices.GetAliasResponse;
import co.elastic.clients.elasticsearch.indices.GetIndexResponse;
import co.elastic.clients.elasticsearch.indices.GetIndexTemplateResponse;
import co.elastic.clients.elasticsearch.indices.GetIndicesSettingsResponse;
import co.elastic.clients.elasticsearch.indices.GetMappingResponse;
import co.elastic.clients.elasticsearch.indices.GetTemplateResponse;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.IndexState;
import co.elastic.clients.elasticsearch.indices.IndexTemplate;
import co.elastic.clients.elasticsearch.indices.IndexTemplateSummary;
import co.elastic.clients.elasticsearch.indices.TemplateMapping;
import co.elastic.clients.elasticsearch.indices.get_index_template.IndexTemplateItem;
import co.elastic.clients.elasticsearch.indices.get_mapping.IndexMappingRecord;
import co.elastic.clients.elasticsearch.sql.QueryResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.ElasticsearchErrorCause;
import org.springframework.data.elasticsearch.client.elc.EntityAsMap;
import org.springframework.data.elasticsearch.client.elc.JsonUtils;
import org.springframework.data.elasticsearch.client.elc.TypeUtils;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.cluster.ClusterHealth;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.index.TemplateResponse;
import org.springframework.data.elasticsearch.core.index.TemplateResponseData;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.data.elasticsearch.core.script.Script;
import org.springframework.data.elasticsearch.core.sql.SqlResponse;
import org.springframework.data.elasticsearch.support.DefaultStringObjectMap;
import org.springframework.util.Assert;

class ResponseConverter {
    private static final Log LOGGER = LogFactory.getLog(ResponseConverter.class);
    private final JsonpMapper jsonpMapper;

    public ResponseConverter(JsonpMapper jsonpMapper) {
        this.jsonpMapper = jsonpMapper;
    }

    public ClusterHealth clusterHealth(HealthResponse healthResponse) {
        Assert.notNull((Object)healthResponse, (String)"healthResponse must not be null");
        return ClusterHealth.builder().withActivePrimaryShards(healthResponse.activePrimaryShards()).withActiveShards(healthResponse.activeShards()).withActiveShardsPercent(healthResponse.activeShardsPercentAsNumber()).withClusterName(healthResponse.clusterName()).withDelayedUnassignedShards(healthResponse.delayedUnassignedShards()).withInitializingShards(healthResponse.initializingShards()).withNumberOfDataNodes(healthResponse.numberOfDataNodes()).withNumberOfInFlightFetch(healthResponse.numberOfInFlightFetch()).withNumberOfNodes(healthResponse.numberOfNodes()).withNumberOfPendingTasks(healthResponse.numberOfPendingTasks()).withRelocatingShards(healthResponse.relocatingShards()).withStatus(healthResponse.status().toString()).withTaskMaxWaitingTimeMillis(healthResponse.taskMaxWaitingInQueueMillis()).withTimedOut(healthResponse.timedOut()).withUnassignedShards(healthResponse.unassignedShards()).build();
    }

    public List<TemplateResponse> clusterGetComponentTemplates(GetComponentTemplateResponse getComponentTemplateResponse) {
        Assert.notNull((Object)getComponentTemplateResponse, (String)"getComponentTemplateResponse must not be null");
        ArrayList<TemplateResponse> componentTemplates = new ArrayList<TemplateResponse>();
        getComponentTemplateResponse.componentTemplates().forEach(componentTemplate -> componentTemplates.add(this.clusterGetComponentTemplate((ComponentTemplate)componentTemplate)));
        return componentTemplates;
    }

    private TemplateResponse clusterGetComponentTemplate(ComponentTemplate componentTemplate) {
        ComponentTemplateNode componentTemplateNode = componentTemplate.componentTemplate();
        ComponentTemplateSummary componentTemplateSummary = componentTemplateNode.template();
        return TemplateResponse.builder().withName(componentTemplate.name()).withVersion(componentTemplateNode.version()).withTemplateData(this.clusterGetComponentTemplateData(componentTemplateSummary)).build();
    }

    private TemplateResponseData clusterGetComponentTemplateData(ComponentTemplateSummary componentTemplateSummary) {
        Document mapping = TypeUtils.typeMapping(componentTemplateSummary.mappings());
        Settings settings = new Settings();
        componentTemplateSummary.settings().forEach((key, indexSettings) -> settings.put((String)key, (Object)Settings.parse(TypeUtils.removePrefixFromJson(indexSettings.toString()))));
        Function<Map.Entry, String> keyMapper = Map.Entry::getKey;
        Function<Map.Entry, AliasData> valueMapper = entry -> this.indicesGetAliasData((String)entry.getKey(), (AliasDefinition)entry.getValue());
        Map<String, AliasData> aliases = componentTemplateSummary.aliases().entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper));
        return TemplateResponseData.builder().withMapping(mapping).withSettings(settings).withAliases(aliases).build();
    }

    public Settings indicesGetSettings(GetIndicesSettingsResponse getIndicesSettingsResponse, String indexName) {
        Assert.notNull((Object)getIndicesSettingsResponse, (String)"getIndicesSettingsResponse must not be null");
        Assert.notNull((Object)indexName, (String)"indexName must not be null");
        Settings settings = new Settings();
        IndexState indexState = getIndicesSettingsResponse.get(indexName);
        if (indexState != null) {
            Function<IndexSettings, Settings> indexSettingsToSettings = indexSettings -> {
                Settings parsedSettings = Settings.parse(JsonUtils.toJson(indexSettings, this.jsonpMapper));
                return indexSettings.index() != null ? parsedSettings : (Settings)new Settings().append("index", parsedSettings);
            };
            if (indexState.defaults() != null) {
                Settings defaultSettings = indexSettingsToSettings.apply(indexState.defaults());
                settings.merge(defaultSettings);
            }
            if (indexState.settings() != null) {
                Settings nonDefaultSettings = indexSettingsToSettings.apply(indexState.settings());
                settings.merge(nonDefaultSettings);
            }
        }
        return settings;
    }

    public Document indicesGetMapping(GetMappingResponse getMappingResponse, IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)getMappingResponse, (String)"getMappingResponse must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        Map mappings = getMappingResponse.result();
        if (mappings == null || mappings.isEmpty()) {
            return Document.create();
        }
        IndexMappingRecord indexMappingRecord = (IndexMappingRecord)mappings.get(indexCoordinates.getIndexName());
        if (indexMappingRecord == null) {
            if (mappings.size() != 1) {
                LOGGER.warn((Object)String.format("no mapping returned for index %s", indexCoordinates.getIndexName()));
                return Document.create();
            }
            String index = (String)mappings.keySet().iterator().next();
            indexMappingRecord = (IndexMappingRecord)mappings.get(index);
        }
        return Document.parse(JsonUtils.toJson(indexMappingRecord.mappings(), this.jsonpMapper));
    }

    public List<IndexInformation> indicesGetIndexInformations(GetIndexResponse getIndexResponse) {
        Assert.notNull((Object)getIndexResponse, (String)"getIndexResponse must not be null");
        ArrayList<IndexInformation> indexInformationList = new ArrayList<IndexInformation>();
        getIndexResponse.result().forEach((indexName, indexState) -> {
            Settings settings = indexState.settings() != null ? Settings.parse(JsonUtils.toJson(indexState.settings(), this.jsonpMapper)) : new Settings();
            Document mappings = indexState.mappings() != null ? Document.parse(JsonUtils.toJson(indexState.mappings(), this.jsonpMapper)) : Document.create();
            ArrayList<AliasData> aliasDataList = new ArrayList<AliasData>();
            indexState.aliases().forEach((aliasName, alias) -> aliasDataList.add(this.indicesGetAliasData((String)aliasName, (Alias)alias)));
            indexInformationList.add(IndexInformation.of(indexName, settings, mappings, aliasDataList));
        });
        return indexInformationList;
    }

    public Map<String, Set<AliasData>> indicesGetAliasData(GetAliasResponse getAliasResponse) {
        Assert.notNull((Object)getAliasResponse, (String)"getAliasResponse must not be null");
        HashMap<String, Set<AliasData>> aliasDataMap = new HashMap<String, Set<AliasData>>();
        getAliasResponse.result().forEach((indexName, alias) -> {
            HashSet aliasDataSet = new HashSet();
            alias.aliases().forEach((aliasName, aliasDefinition) -> aliasDataSet.add(this.indicesGetAliasData((String)aliasName, (AliasDefinition)aliasDefinition)));
            aliasDataMap.put((String)indexName, aliasDataSet);
        });
        return aliasDataMap;
    }

    private AliasData indicesGetAliasData(String aliasName, Alias alias) {
        Query filter = alias.filter();
        String filterJson = filter != null ? JsonUtils.toJson(filter, this.jsonpMapper) : null;
        StringQuery filterQuery = filterJson != null ? StringQuery.builder(filterJson).build() : null;
        return AliasData.of(aliasName, filterQuery, alias.indexRouting(), alias.searchRouting(), alias.isWriteIndex(), alias.isHidden());
    }

    private AliasData indicesGetAliasData(String aliasName, AliasDefinition alias) {
        Query filter = alias.filter();
        String filterJson = filter != null ? JsonUtils.toJson(filter, this.jsonpMapper) : null;
        StringQuery filterQuery = filterJson != null ? StringQuery.builder(filterJson).build() : null;
        return AliasData.of(aliasName, filterQuery, alias.indexRouting(), alias.searchRouting(), alias.isWriteIndex(), null);
    }

    public @Nullable TemplateData indicesGetTemplateData(GetTemplateResponse getTemplateResponse, String templateName) {
        Assert.notNull((Object)getTemplateResponse, (String)"getTemplateResponse must not be null");
        Assert.notNull((Object)templateName, (String)"templateName must not be null");
        TemplateMapping templateMapping = getTemplateResponse.get(templateName);
        if (templateMapping != null) {
            Settings settings = new Settings();
            templateMapping.settings().forEach((key, jsonData) -> {
                if (key.contains(".")) {
                    settings.put((String)key, (Object)jsonData.toJson().toString().replaceAll("^\"|\"$", ""));
                } else {
                    settings.put((String)key, new DefaultStringObjectMap().fromJson(jsonData.toJson().toString()));
                }
            });
            Function<Map.Entry, String> keyMapper = Map.Entry::getKey;
            Function<Map.Entry, AliasData> valueMapper = entry -> this.indicesGetAliasData((String)entry.getKey(), (Alias)entry.getValue());
            Map<String, AliasData> aliases = templateMapping.aliases().entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper));
            Document mapping = Document.parse(JsonUtils.toJson(templateMapping.mappings(), this.jsonpMapper));
            TemplateData.TemplateDataBuilder builder = TemplateData.builder().withIndexPatterns(templateMapping.indexPatterns().toArray(new String[0])).withOrder(templateMapping.order()).withSettings(settings).withMapping(mapping).withAliases(aliases);
            if (templateMapping.version() != null) {
                builder.withVersion(templateMapping.version().intValue());
            }
            return builder.build();
        }
        return null;
    }

    public List<TemplateResponse> getIndexTemplates(GetIndexTemplateResponse getIndexTemplateResponse) {
        Assert.notNull((Object)getIndexTemplateResponse, (String)"getIndexTemplateResponse must not be null");
        ArrayList<TemplateResponse> componentTemplates = new ArrayList<TemplateResponse>();
        getIndexTemplateResponse.indexTemplates().forEach(indexTemplateItem -> componentTemplates.add(this.indexGetComponentTemplate((IndexTemplateItem)indexTemplateItem)));
        return componentTemplates;
    }

    private TemplateResponse indexGetComponentTemplate(IndexTemplateItem indexTemplateItem) {
        IndexTemplate indexTemplate = indexTemplateItem.indexTemplate();
        List composedOf = indexTemplate.composedOf();
        IndexTemplateSummary indexTemplateSummary = indexTemplate.template();
        return TemplateResponse.builder().withName(indexTemplateItem.name()).withVersion(indexTemplate.version()).withTemplateData(this.indexGetComponentTemplateData(indexTemplateSummary, composedOf)).build();
    }

    private TemplateResponseData indexGetComponentTemplateData(IndexTemplateSummary indexTemplateSummary, List<String> composedOf) {
        Document mapping = TypeUtils.typeMapping(indexTemplateSummary.mappings());
        Function<IndexSettings, Settings> indexSettingsToSettings = indexSettings -> {
            if (indexSettings == null) {
                return null;
            }
            Settings parsedSettings = Settings.parse(JsonUtils.toJson(indexSettings, this.jsonpMapper));
            return indexSettings.index() != null ? parsedSettings : (Settings)new Settings().append("index", parsedSettings);
        };
        Settings settings = indexSettingsToSettings.apply(indexTemplateSummary.settings());
        Function<Map.Entry, String> keyMapper = Map.Entry::getKey;
        Function<Map.Entry, AliasData> valueMapper = entry -> this.indicesGetAliasData((String)entry.getKey(), (Alias)entry.getValue());
        Map aliases1 = indexTemplateSummary.aliases();
        Map<String, AliasData> aliases = aliases1.entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper));
        return TemplateResponseData.builder().withMapping(mapping).withSettings(settings).withAliases(aliases).withComposedOf(composedOf).build();
    }

    public ReindexResponse reindexResponse(co.elastic.clients.elasticsearch.core.ReindexResponse reindexResponse) {
        Assert.notNull((Object)reindexResponse, (String)"reindexResponse must not be null");
        List<ReindexResponse.Failure> failures = reindexResponse.failures().stream().map(this::reindexResponseFailureOf).collect(Collectors.toList());
        return ReindexResponse.builder().withTook(reindexResponse.took()).withTimedOut(reindexResponse.timedOut()).withTotal(reindexResponse.total()).withCreated(reindexResponse.created()).withUpdated(reindexResponse.updated()).withDeleted(reindexResponse.deleted()).withBatches(reindexResponse.batches()).withVersionConflicts(reindexResponse.versionConflicts()).withNoops(reindexResponse.noops()).withBulkRetries(reindexResponse.retries().bulk()).withSearchRetries(reindexResponse.retries().search()).withThrottledMillis(reindexResponse.throttledMillis()).withRequestsPerSecond(reindexResponse.requestsPerSecond().floatValue()).withThrottledUntilMillis(reindexResponse.throttledUntilMillis()).withFailures(failures).build();
    }

    private ReindexResponse.Failure reindexResponseFailureOf(BulkIndexByScrollFailure failure) {
        return ReindexResponse.Failure.builder().withIndex(failure.index()).withId(failure.id()).withStatus(failure.status()).withErrorCause(ResponseConverter.toErrorCause(failure.cause())).build();
    }

    private ByQueryResponse.Failure byQueryResponseFailureOf(BulkIndexByScrollFailure failure) {
        return ByQueryResponse.Failure.builder().withIndex(failure.index()).withId(failure.id()).withStatus(failure.status()).withErrorCause(ResponseConverter.toErrorCause(failure.cause())).build();
    }

    public static @Nullable MultiGetItem.Failure getFailure(MultiGetResponseItem<EntityAsMap> itemResponse) {
        MultiGetError responseFailure = itemResponse.isFailure() ? itemResponse.failure() : null;
        return responseFailure != null ? MultiGetItem.Failure.of(responseFailure.index(), null, responseFailure.id(), null, ResponseConverter.toErrorCause(responseFailure.error())) : null;
    }

    public ByQueryResponse byQueryResponse(DeleteByQueryResponse response) {
        List<ByQueryResponse.Failure> failures = response.failures().stream().map(this::byQueryResponseFailureOf).collect(Collectors.toList());
        ByQueryResponse.ByQueryResponseBuilder builder = ByQueryResponse.builder();
        if (response.took() != null) {
            builder.withTook(response.took());
        }
        if (response.timedOut() != null) {
            builder.withTimedOut(response.timedOut());
        }
        if (response.total() != null) {
            builder.withTotal(response.total());
        }
        if (response.deleted() != null) {
            builder.withDeleted(response.deleted());
        }
        if (response.batches() != null) {
            builder.withBatches(Math.toIntExact(response.batches()));
        }
        if (response.versionConflicts() != null) {
            builder.withVersionConflicts(response.versionConflicts());
        }
        if (response.noops() != null) {
            builder.withNoops(response.noops());
        }
        if (response.retries() != null) {
            builder.withBulkRetries(response.retries().bulk());
            builder.withSearchRetries(response.retries().search());
        }
        builder.withFailures(failures);
        return builder.build();
    }

    public ByQueryResponse byQueryResponse(UpdateByQueryResponse response) {
        List<ByQueryResponse.Failure> failures = response.failures().stream().map(this::byQueryResponseFailureOf).collect(Collectors.toList());
        ByQueryResponse.ByQueryResponseBuilder builder = ByQueryResponse.builder();
        if (response.took() != null) {
            builder.withTook(response.took());
        }
        if (response.timedOut() != null) {
            builder.withTimedOut(response.timedOut());
        }
        if (response.total() != null) {
            builder.withTotal(response.total());
        }
        if (response.deleted() != null) {
            builder.withDeleted(response.deleted());
        }
        if (response.updated() != null) {
            builder.withUpdated(response.updated());
        }
        if (response.batches() != null) {
            builder.withBatches(Math.toIntExact(response.batches()));
        }
        if (response.versionConflicts() != null) {
            builder.withVersionConflicts(response.versionConflicts());
        }
        if (response.noops() != null) {
            builder.withNoops(response.noops());
        }
        if (response.retries() != null) {
            builder.withBulkRetries(response.retries().bulk());
            builder.withSearchRetries(response.retries().search());
        }
        builder.withFailures(failures);
        return builder.build();
    }

    public @Nullable Script scriptResponse(GetScriptResponse response) {
        Assert.notNull((Object)response, (String)"response must not be null");
        return response.found() ? Script.builder().withId(response.id()).withLanguage(response.script().lang()).withSource(response.script().source()).build() : null;
    }

    public SqlResponse sqlResponse(QueryResponse response) {
        SqlResponse.Builder builder = SqlResponse.builder();
        builder.withRunning(Boolean.TRUE.equals(response.isRunning())).withPartial(Boolean.TRUE.equals(response.isPartial())).withCursor(response.cursor());
        List<SqlResponse.Column> columns = response.columns().stream().map(column -> new SqlResponse.Column(column.name(), column.type())).toList();
        builder.withColumns(columns);
        for (List rowValues : response.rows()) {
            SqlResponse.Row.Builder rowBuilder = SqlResponse.Row.builder();
            for (int idx = 0; idx < rowValues.size(); ++idx) {
                rowBuilder.withValue(columns.get(idx), ((JsonData)rowValues.get(idx)).toJson());
            }
            builder.withRow(rowBuilder.build());
        }
        return builder.build();
    }

    private long timeToLong(Time time) {
        if (time.isTime()) {
            return Long.parseLong(time.time());
        }
        return time.offset().intValue();
    }

    static @Nullable ElasticsearchErrorCause toErrorCause(@Nullable ErrorCause errorCause) {
        if (errorCause != null) {
            return new ElasticsearchErrorCause(errorCause.type(), errorCause.reason(), errorCause.stackTrace(), ResponseConverter.toErrorCause(errorCause.causedBy()), errorCause.rootCause().stream().map(ResponseConverter::toErrorCause).collect(Collectors.toList()), errorCause.suppressed().stream().map(ResponseConverter::toErrorCause).collect(Collectors.toList()));
        }
        return null;
    }
}

