/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.config;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.auditing.config.IsNewAwareAuditingHandlerBeanDefinitionParser;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.elasticsearch.config.ElasticsearchAuditingRegistrar;
import org.springframework.data.elasticsearch.core.event.AuditingEntityCallback;
import org.springframework.data.elasticsearch.core.event.ReactiveAuditingEntityCallback;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ElasticsearchAuditingBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String MAPPING_CONTEXT_BEAN_NAME = "simpleElasticsearchMappingContext";
    private static final boolean PROJECT_REACTOR_AVAILABLE = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)ElasticsearchAuditingRegistrar.class.getClassLoader());

    protected Class<?> getBeanClass(Element element) {
        return AuditingEntityCallback.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String mappingContextRef = element.getAttribute("mapping-context-ref");
        if (!StringUtils.hasText((String)mappingContextRef)) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            if (!registry.containsBeanDefinition(MAPPING_CONTEXT_BEAN_NAME)) {
                registry.registerBeanDefinition(MAPPING_CONTEXT_BEAN_NAME, (BeanDefinition)new RootBeanDefinition(SimpleElasticsearchMappingContext.class));
            }
            mappingContextRef = MAPPING_CONTEXT_BEAN_NAME;
        }
        IsNewAwareAuditingHandlerBeanDefinitionParser parser = new IsNewAwareAuditingHandlerBeanDefinitionParser(mappingContextRef);
        parser.parse(element, parserContext);
        AbstractBeanDefinition isNewAwareAuditingHandler = ParsingUtils.getObjectFactoryBeanDefinition((String)parser.getResolvedBeanName(), (Object)parserContext.extractSource((Object)element));
        builder.addConstructorArgValue((Object)isNewAwareAuditingHandler);
        if (PROJECT_REACTOR_AVAILABLE) {
            this.registerReactiveAuditingEntityCallback(parserContext.getRegistry(), isNewAwareAuditingHandler, parserContext.extractSource((Object)element));
        }
    }

    private void registerReactiveAuditingEntityCallback(BeanDefinitionRegistry registry, AbstractBeanDefinition isNewAwareAuditingHandler, @Nullable Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReactiveAuditingEntityCallback.class);
        builder.addConstructorArgValue((Object)isNewAwareAuditingHandler);
        builder.getRawBeanDefinition().setSource(source);
        registry.registerBeanDefinition(ReactiveAuditingEntityCallback.class.getName(), (BeanDefinition)builder.getBeanDefinition());
    }
}

