/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchStringQuery;
import org.springframework.data.elasticsearch.repository.query.ReactivePartTreeElasticsearchQuery;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.MappingElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.ReactiveElasticsearchRepositoryMetadata;
import org.springframework.data.elasticsearch.repository.support.SimpleReactiveElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.querybyexample.ReactiveQueryByExampleElasticsearchExecutor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.ReactiveQueryByExampleExecutor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReactiveElasticsearchRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private final ReactiveElasticsearchOperations operations;
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    public ReactiveElasticsearchRepositoryFactory(ReactiveElasticsearchOperations elasticsearchOperations) {
        Assert.notNull((Object)elasticsearchOperations, (String)"ReactiveElasticsearchOperations must not be null!");
        this.operations = elasticsearchOperations;
        this.mappingContext = elasticsearchOperations.getElasticsearchConverter().getMappingContext();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleReactiveElasticsearchRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        ElasticsearchEntityInformation entityInformation = this.getEntityInformation(information.getDomainType(), information);
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new ElasticsearchQueryLookupStrategy(this.operations, valueExpressionDelegate, this.mappingContext));
    }

    public <T, ID> ElasticsearchEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.getEntityInformation(domainClass, null);
    }

    private <T, ID> ElasticsearchEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, @Nullable RepositoryInformation information) {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingElasticsearchEntityInformation(entity);
    }

    protected RepositoryMetadata getRepositoryMetadata(Class<?> repositoryInterface) {
        return new ReactiveElasticsearchRepositoryMetadata(repositoryInterface);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        RepositoryComposition.RepositoryFragments fragments = RepositoryComposition.RepositoryFragments.empty();
        if (ReactiveQueryByExampleExecutor.class.isAssignableFrom(metadata.getRepositoryInterface())) {
            fragments = fragments.append(RepositoryFragment.implemented(ReactiveQueryByExampleExecutor.class, (Object)((ReactiveQueryByExampleExecutor)this.instantiateClass(ReactiveQueryByExampleElasticsearchExecutor.class, new Object[]{this.operations}))));
        }
        return fragments;
    }

    private static class ElasticsearchQueryLookupStrategy
    implements QueryLookupStrategy {
        private final ReactiveElasticsearchOperations operations;
        private final ValueExpressionDelegate valueExpressionDelegate;
        private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

        public ElasticsearchQueryLookupStrategy(ReactiveElasticsearchOperations operations, ValueExpressionDelegate valueExpressionDelegate, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
            Assert.notNull((Object)operations, (String)"operations must not be null");
            Assert.notNull((Object)valueExpressionDelegate, (String)"ValueExpressionDelegate must not be null");
            Assert.notNull(mappingContext, (String)"mappingContext must not be null");
            this.operations = operations;
            this.valueExpressionDelegate = valueExpressionDelegate;
            this.mappingContext = mappingContext;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            ReactiveElasticsearchQueryMethod queryMethod = new ReactiveElasticsearchQueryMethod(method, metadata, factory, this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new ReactiveElasticsearchStringQuery(namedQuery, queryMethod, this.operations, this.valueExpressionDelegate);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new ReactiveElasticsearchStringQuery(queryMethod, this.operations, this.valueExpressionDelegate);
            }
            return new ReactivePartTreeElasticsearchQuery(queryMethod, this.operations, this.valueExpressionDelegate);
        }
    }
}

