/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.SearchShardStatistics;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.lang.Nullable;

public class SearchDocumentResponse {
    private final long totalHits;
    private final String totalHitsRelation;
    private final float maxScore;
    private final Duration executionDuration;
    @Nullable
    private final String scrollId;
    private final List<SearchDocument> searchDocuments;
    @Nullable
    private final AggregationsContainer<?> aggregations;
    @Nullable
    private final Suggest suggest;
    @Nullable
    String pointInTimeId;
    @Nullable
    private final SearchShardStatistics searchShardStatistics;

    public SearchDocumentResponse(long totalHits, String totalHitsRelation, float maxScore, Duration executionDuration, @Nullable String scrollId, @Nullable String pointInTimeId, List<SearchDocument> searchDocuments, @Nullable AggregationsContainer<?> aggregationsContainer, @Nullable Suggest suggest, @Nullable SearchShardStatistics searchShardStatistics) {
        this.totalHits = totalHits;
        this.totalHitsRelation = totalHitsRelation;
        this.maxScore = maxScore;
        this.executionDuration = executionDuration;
        this.scrollId = scrollId;
        this.pointInTimeId = pointInTimeId;
        this.searchDocuments = searchDocuments;
        this.aggregations = aggregationsContainer;
        this.suggest = suggest;
        this.searchShardStatistics = searchShardStatistics;
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public String getTotalHitsRelation() {
        return this.totalHitsRelation;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public Duration getExecutionDuration() {
        return this.executionDuration;
    }

    @Nullable
    public String getScrollId() {
        return this.scrollId;
    }

    public List<SearchDocument> getSearchDocuments() {
        return this.searchDocuments;
    }

    @Nullable
    public AggregationsContainer<?> getAggregations() {
        return this.aggregations;
    }

    @Nullable
    public Suggest getSuggest() {
        return this.suggest;
    }

    @Nullable
    public String getPointInTimeId() {
        return this.pointInTimeId;
    }

    @Nullable
    public SearchShardStatistics getSearchShardStatistics() {
        return this.searchShardStatistics;
    }

    @FunctionalInterface
    public static interface EntityCreator<T>
    extends Function<SearchDocument, CompletableFuture<T>> {
    }
}

