/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.InnerHits;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.client.elc.AbstractQueryProcessor;
import org.springframework.data.elasticsearch.client.elc.CriteriaFilterProcessor;
import org.springframework.data.elasticsearch.client.elc.CriteriaQueryException;
import org.springframework.data.elasticsearch.client.elc.Queries;
import org.springframework.data.elasticsearch.client.elc.TypeUtils;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.Field;
import org.springframework.data.elasticsearch.core.query.HasChildQuery;
import org.springframework.data.elasticsearch.core.query.HasParentQuery;
import org.springframework.data.elasticsearch.core.query.InnerHitsQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class CriteriaQueryProcessor
extends AbstractQueryProcessor {
    CriteriaQueryProcessor() {
    }

    @Nullable
    public static Query createQuery(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria must not be null");
        ArrayList<Query> shouldQueries = new ArrayList<Query>();
        ArrayList<Query> mustNotQueries = new ArrayList<Query>();
        ArrayList<Query> mustQueries = new ArrayList<Query>();
        Query firstQuery = null;
        boolean negateFirstQuery = false;
        for (Criteria chainedCriteria : criteria.getCriteriaChain()) {
            Query queryFragment = CriteriaQueryProcessor.queryForEntries(chainedCriteria);
            if (queryFragment == null) continue;
            if (firstQuery == null) {
                firstQuery = queryFragment;
                negateFirstQuery = chainedCriteria.isNegating();
                continue;
            }
            if (chainedCriteria.isOr()) {
                shouldQueries.add(queryFragment);
                continue;
            }
            if (chainedCriteria.isNegating()) {
                mustNotQueries.add(queryFragment);
                continue;
            }
            mustQueries.add(queryFragment);
        }
        for (Criteria subCriteria : criteria.getSubCriteria()) {
            Query subQuery = CriteriaQueryProcessor.createQuery(subCriteria);
            if (subQuery == null) continue;
            if (criteria.isOr()) {
                shouldQueries.add(subQuery);
                continue;
            }
            if (criteria.isNegating()) {
                mustNotQueries.add(subQuery);
                continue;
            }
            mustQueries.add(subQuery);
        }
        if (firstQuery != null) {
            if (!shouldQueries.isEmpty() && mustNotQueries.isEmpty() && mustQueries.isEmpty()) {
                shouldQueries.add(0, firstQuery);
            } else if (negateFirstQuery) {
                mustNotQueries.add(0, firstQuery);
            } else {
                mustQueries.add(0, firstQuery);
            }
        }
        Optional<Query> filterQuery = CriteriaFilterProcessor.createQuery(criteria);
        if (shouldQueries.isEmpty() && mustNotQueries.isEmpty() && mustQueries.isEmpty()) {
            if (filterQuery.isEmpty()) {
                return null;
            }
            mustQueries.add(Query.of(qb -> qb.matchAll(m -> m)));
        }
        return (Query)new Query.Builder().bool(boolQueryBuilder -> {
            if (!shouldQueries.isEmpty()) {
                boolQueryBuilder.should(shouldQueries);
            }
            if (!mustNotQueries.isEmpty()) {
                boolQueryBuilder.mustNot(mustNotQueries);
            }
            if (!mustQueries.isEmpty()) {
                boolQueryBuilder.must(mustQueries);
            }
            filterQuery.ifPresent(x$0 -> boolQueryBuilder.filter(x$0, new Query[0]));
            return boolQueryBuilder;
        }).build();
    }

    @Nullable
    private static Query queryForEntries(Criteria criteria) {
        Query query;
        Query.Builder queryBuilder;
        Float boost;
        Field field = criteria.getField();
        if (field == null || criteria.getQueryCriteriaEntries().isEmpty()) {
            return null;
        }
        String fieldName = field.getName();
        Assert.notNull((Object)fieldName, (String)("Unknown field " + fieldName));
        Iterator<Criteria.CriteriaEntry> it = criteria.getQueryCriteriaEntries().iterator();
        Float f = boost = Float.isNaN(criteria.getBoost()) ? null : Float.valueOf(criteria.getBoost());
        if (criteria.getQueryCriteriaEntries().size() == 1) {
            queryBuilder = CriteriaQueryProcessor.queryFor(it.next(), field, boost);
        } else {
            queryBuilder = new Query.Builder();
            queryBuilder.bool(boolQueryBuilder -> {
                while (it.hasNext()) {
                    Criteria.CriteriaEntry entry = (Criteria.CriteriaEntry)it.next();
                    boolQueryBuilder.must(CriteriaQueryProcessor.queryFor(entry, field, null).build(), new Query[0]);
                }
                boolQueryBuilder.boost(boost);
                return boolQueryBuilder;
            });
        }
        if (StringUtils.hasText((String)field.getPath())) {
            query = queryBuilder.build();
            queryBuilder = new Query.Builder();
            queryBuilder.nested(nqb -> nqb.path(field.getPath()).query(query).scoreMode(ChildScoreMode.Avg));
        }
        if (criteria.isNegating() && criteria.isOr()) {
            query = queryBuilder.build();
            queryBuilder = new Query.Builder();
            queryBuilder.bool(mnqb -> mnqb.mustNot(query, new Query[0]));
        }
        return queryBuilder.build();
    }

    private static Query.Builder queryFor(Criteria.CriteriaEntry entry, Field field, @Nullable Float boost) {
        String fieldName = field.getName();
        boolean isKeywordField = FieldType.Keyword == field.getFieldType();
        Criteria.OperationKey key = entry.getKey();
        Object value = key.hasValue() ? entry.getValue() : null;
        String searchText = value != null ? CriteriaQueryProcessor.escape(value.toString()) : "UNKNOWN_VALUE";
        Query.Builder queryBuilder = new Query.Builder();
        switch (key) {
            case EXISTS: {
                queryBuilder.exists(eb -> (ObjectBuilder)eb.field(fieldName).boost(boost));
                break;
            }
            case EMPTY: {
                queryBuilder.bool(bb -> (ObjectBuilder)bb.must(mb -> mb.exists(eb -> eb.field(fieldName))).mustNot(mnb -> mnb.wildcard(wb -> wb.field(fieldName).wildcard("*"))).boost(boost));
                break;
            }
            case NOT_EMPTY: {
                queryBuilder.wildcard(wb -> (ObjectBuilder)wb.field(fieldName).wildcard("*").boost(boost));
                break;
            }
            case EQUALS: {
                queryBuilder.queryString(Queries.queryStringQuery(fieldName, searchText, Operator.And, boost));
                break;
            }
            case CONTAINS: {
                queryBuilder.queryString(Queries.queryStringQuery(fieldName, "*" + searchText + "*", true, boost));
                break;
            }
            case STARTS_WITH: {
                queryBuilder.queryString(Queries.queryStringQuery(fieldName, searchText + "*", true, boost));
                break;
            }
            case ENDS_WITH: {
                queryBuilder.queryString(Queries.queryStringQuery(fieldName, "*" + searchText, true, boost));
                break;
            }
            case EXPRESSION: {
                queryBuilder.queryString(Queries.queryStringQuery(fieldName, Objects.requireNonNull(value).toString(), boost));
                break;
            }
            case LESS: {
                queryBuilder.range(rb -> (ObjectBuilder)rb.field(fieldName).lt(JsonData.of((Object)value)).boost(boost));
                break;
            }
            case LESS_EQUAL: {
                queryBuilder.range(rb -> (ObjectBuilder)rb.field(fieldName).lte(JsonData.of((Object)value)).boost(boost));
                break;
            }
            case GREATER: {
                queryBuilder.range(rb -> (ObjectBuilder)rb.field(fieldName).gt(JsonData.of((Object)value)).boost(boost));
                break;
            }
            case GREATER_EQUAL: {
                queryBuilder.range(rb -> (ObjectBuilder)rb.field(fieldName).gte(JsonData.of((Object)value)).boost(boost));
                break;
            }
            case BETWEEN: {
                Object[] ranges = (Object[])value;
                Assert.notNull((Object)value, (String)"value for a between condition must not be null");
                queryBuilder.range(rb -> {
                    rb.field(fieldName);
                    if (ranges[0] != null) {
                        rb.gte(JsonData.of((Object)ranges[0]));
                    }
                    if (ranges[1] != null) {
                        rb.lte(JsonData.of((Object)ranges[1]));
                    }
                    rb.boost(boost);
                    return rb;
                });
                break;
            }
            case FUZZY: {
                queryBuilder.fuzzy(fb -> (ObjectBuilder)fb.field(fieldName).value(FieldValue.of((String)searchText)).boost(boost));
                break;
            }
            case MATCHES: {
                queryBuilder.match(Queries.matchQuery(fieldName, Objects.requireNonNull(value).toString(), Operator.Or, boost));
                break;
            }
            case MATCHES_ALL: {
                queryBuilder.match(Queries.matchQuery(fieldName, Objects.requireNonNull(value).toString(), Operator.And, boost));
                break;
            }
            case IN: {
                if (value instanceof Iterable) {
                    Iterable iterable = (Iterable)value;
                    if (isKeywordField) {
                        queryBuilder.bool(bb -> (ObjectBuilder)bb.must(mb -> mb.terms(tb -> tb.field(fieldName).terms(tsb -> tsb.value(CriteriaQueryProcessor.toFieldValueList(iterable))))).boost(boost));
                        break;
                    }
                    queryBuilder.queryString(qsb -> (ObjectBuilder)qsb.fields(fieldName, new String[0]).query(CriteriaQueryProcessor.orQueryString(iterable)).boost(boost));
                    break;
                }
                throw new CriteriaQueryException("value for " + fieldName + " is not an Iterable");
            }
            case NOT_IN: {
                if (value instanceof Iterable) {
                    Iterable iterable = (Iterable)value;
                    if (isKeywordField) {
                        queryBuilder.bool(bb -> (ObjectBuilder)bb.mustNot(mnb -> mnb.terms(tb -> tb.field(fieldName).terms(tsb -> tsb.value(CriteriaQueryProcessor.toFieldValueList(iterable))))).boost(boost));
                        break;
                    }
                    queryBuilder.queryString(qsb -> (ObjectBuilder)qsb.fields(fieldName, new String[0]).query("NOT(" + CriteriaQueryProcessor.orQueryString(iterable) + ")").boost(boost));
                    break;
                }
                throw new CriteriaQueryException("value for " + fieldName + " is not an Iterable");
            }
            case REGEXP: {
                queryBuilder.regexp(rb -> (ObjectBuilder)rb.field(fieldName).value(Objects.requireNonNull(value).toString()).boost(boost));
                break;
            }
            case HAS_CHILD: {
                if (value instanceof HasChildQuery) {
                    HasChildQuery query = (HasChildQuery)value;
                    queryBuilder.hasChild(hcb -> hcb.type(query.getType()).query(CriteriaQueryProcessor.getEsQuery(query.getQuery(), null)).innerHits(CriteriaQueryProcessor.getInnerHits(query.getInnerHitsQuery())).ignoreUnmapped(query.getIgnoreUnmapped()).minChildren(query.getMinChildren()).maxChildren(query.getMaxChildren()).scoreMode(TypeUtils.scoreMode(query.getScoreMode())));
                    break;
                }
                throw new CriteriaQueryException("value for " + fieldName + " is not a has_child query");
            }
            case HAS_PARENT: {
                if (value instanceof HasParentQuery) {
                    HasParentQuery query = (HasParentQuery)value;
                    queryBuilder.hasParent(hpb -> hpb.parentType(query.getParentType()).query(CriteriaQueryProcessor.getEsQuery(query.getQuery(), null)).innerHits(CriteriaQueryProcessor.getInnerHits(query.getInnerHitsQuery())).ignoreUnmapped(query.getIgnoreUnmapped()).score(query.getScore()));
                    break;
                }
                throw new CriteriaQueryException("value for " + fieldName + " is not a has_parent query");
            }
            default: {
                throw new CriteriaQueryException("Could not build query for " + String.valueOf(entry));
            }
        }
        return queryBuilder;
    }

    private static List<FieldValue> toFieldValueList(Iterable<?> iterable) {
        ArrayList<FieldValue> list = new ArrayList<FieldValue>();
        for (Object item : iterable) {
            list.add(item != null ? FieldValue.of((String)item.toString()) : null);
        }
        return list;
    }

    private static String orQueryString(Iterable<?> iterable) {
        StringBuilder sb = new StringBuilder();
        for (Object item : iterable) {
            if (item == null) continue;
            if (!sb.isEmpty()) {
                sb.append(' ');
            }
            sb.append('\"');
            sb.append(CriteriaQueryProcessor.escape(item.toString()));
            sb.append('\"');
        }
        return sb.toString();
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == '/') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Nullable
    private static InnerHits getInnerHits(@Nullable InnerHitsQuery query) {
        if (query == null) {
            return null;
        }
        return InnerHits.of(iqb -> iqb.from(query.getFrom()).size(query.getSize()).name(query.getName()));
    }
}

