/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoJsonLineString;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.geo.Point;
import org.springframework.util.Assert;

public class GeoJsonPolygon
implements GeoJson<Iterable<GeoJsonLineString>> {
    public static final String TYPE = "Polygon";
    private final List<GeoJsonLineString> coordinates = new ArrayList<GeoJsonLineString>();

    private GeoJsonPolygon(GeoJsonLineString geoJsonLineString) {
        Assert.notNull((Object)geoJsonLineString, (String)"geoJsonLineString must not be null");
        Assert.isTrue((geoJsonLineString.getCoordinates().size() >= 4 ? 1 : 0) != 0, (String)"geoJsonLineString must have at least 4 points");
        this.coordinates.add(geoJsonLineString);
    }

    private GeoJsonPolygon(List<Point> points) {
        this(GeoJsonLineString.of(points));
    }

    public static GeoJsonPolygon of(GeoJsonLineString geoJsonLineString) {
        return new GeoJsonPolygon(geoJsonLineString);
    }

    public static GeoJsonPolygon of(List<Point> points) {
        return new GeoJsonPolygon(points);
    }

    public static GeoJsonPolygon ofGeoPoints(List<GeoPoint> geoPoints) {
        return new GeoJsonPolygon(GeoJsonLineString.ofGeoPoints(geoPoints));
    }

    public static GeoJsonPolygon of(Point first, Point second, Point third, Point fourth, Point ... others) {
        return new GeoJsonPolygon(GeoJsonPolygon.asList(first, second, third, fourth, others));
    }

    public static GeoJsonPolygon of(GeoPoint first, GeoPoint second, GeoPoint third, GeoPoint fourth, GeoPoint ... others) {
        return new GeoJsonPolygon(GeoJsonLineString.ofGeoPoints(GeoJsonPolygon.asList(first, second, third, fourth, others)));
    }

    public GeoJsonPolygon withInnerRing(Point first, Point second, Point third, Point fourth, Point ... others) {
        return this.withInnerRing(GeoJsonPolygon.asList(first, second, third, fourth, others));
    }

    public GeoJsonPolygon withInnerRing(GeoPoint first, GeoPoint second, GeoPoint third, GeoPoint fourth, GeoPoint ... others) {
        return this.withInnerRingOfGeoPoints(GeoJsonPolygon.asList(first, second, third, fourth, others));
    }

    public GeoJsonPolygon withInnerRing(List<Point> points) {
        return this.withInnerRing(GeoJsonLineString.of(points));
    }

    public GeoJsonPolygon withInnerRingOfGeoPoints(List<GeoPoint> geoPoints) {
        return this.withInnerRing(GeoJsonLineString.ofGeoPoints(geoPoints));
    }

    public GeoJsonPolygon withInnerRing(GeoJsonLineString lineString) {
        Assert.notNull((Object)lineString, (String)"LineString must not be null!");
        Iterator<GeoJsonLineString> it = this.coordinates.iterator();
        GeoJsonPolygon polygon = new GeoJsonPolygon((List<Point>)it.next().getCoordinates());
        while (it.hasNext()) {
            polygon.coordinates.add(it.next());
        }
        polygon.coordinates.add(lineString);
        return polygon;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<GeoJsonLineString> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    @SafeVarargs
    private static <T> List<T> asList(T first, T second, T third, T fourth, T ... others) {
        ArrayList<T> result = new ArrayList<T>(3 + others.length);
        result.add(first);
        result.add(second);
        result.add(third);
        result.add(fourth);
        result.addAll(Arrays.asList(others));
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJsonPolygon that = (GeoJsonPolygon)o;
        return this.coordinates.equals(that.coordinates);
    }

    public int hashCode() {
        return this.coordinates.hashCode();
    }

    public String toString() {
        return "GeoJsonPolygon{coordinates=" + String.valueOf(this.coordinates) + "}";
    }
}

