/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch.core.search.CompletionSuggest;
import co.elastic.clients.elasticsearch.core.search.CompletionSuggestOption;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.PhraseSuggest;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.elasticsearch.core.search.Suggestion;
import co.elastic.clients.elasticsearch.core.search.TermSuggest;
import co.elastic.clients.elasticsearch.core.search.TotalHits;
import co.elastic.clients.json.JsonpMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.elasticsearch.client.elc.DocumentAdapters;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchAggregations;
import org.springframework.data.elasticsearch.client.elc.EntityAsMap;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.suggest.response.CompletionSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.PhraseSuggestion;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.data.elasticsearch.core.suggest.response.TermSuggestion;
import org.springframework.data.elasticsearch.support.ScoreDoc;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class SearchDocumentResponseBuilder {
    private static final Log LOGGER = LogFactory.getLog(SearchDocumentResponseBuilder.class);

    SearchDocumentResponseBuilder() {
    }

    public static <T> SearchDocumentResponse from(ResponseBody<EntityAsMap> responseBody, SearchDocumentResponse.EntityCreator<T> entityCreator, JsonpMapper jsonpMapper) {
        Assert.notNull(responseBody, (String)"responseBody must not be null");
        Assert.notNull(entityCreator, (String)"entityCreator must not be null");
        HitsMetadata hitsMetadata = responseBody.hits();
        String scrollId = responseBody.scrollId();
        Map aggregations = responseBody.aggregations();
        Map suggest = responseBody.suggest();
        String pointInTimeId = responseBody.pitId();
        return SearchDocumentResponseBuilder.from(hitsMetadata, scrollId, pointInTimeId, aggregations, suggest, entityCreator, jsonpMapper);
    }

    public static <T> SearchDocumentResponse from(HitsMetadata<?> hitsMetadata, @Nullable String scrollId, @Nullable String pointInTimeId, @Nullable Map<String, Aggregate> aggregations, Map<String, List<Suggestion<EntityAsMap>>> suggestES, SearchDocumentResponse.EntityCreator<T> entityCreator, JsonpMapper jsonpMapper) {
        String totalHitsRelation;
        long totalHits;
        Assert.notNull(hitsMetadata, (String)"hitsMetadata must not be null");
        TotalHits responseTotalHits = hitsMetadata.total();
        if (responseTotalHits != null) {
            totalHits = responseTotalHits.value();
            totalHitsRelation = switch (responseTotalHits.relation().jsonValue()) {
                case "eq" -> TotalHitsRelation.EQUAL_TO.name();
                case "gte" -> TotalHitsRelation.GREATER_THAN_OR_EQUAL_TO.name();
                default -> TotalHitsRelation.OFF.name();
            };
        } else {
            totalHits = hitsMetadata.hits().size();
            totalHitsRelation = "OFF";
        }
        float maxScore = hitsMetadata.maxScore() != null ? hitsMetadata.maxScore().floatValue() : Float.NaN;
        ArrayList<SearchDocument> searchDocuments = new ArrayList<SearchDocument>();
        for (Hit hit : hitsMetadata.hits()) {
            searchDocuments.add(DocumentAdapters.from(hit, jsonpMapper));
        }
        ElasticsearchAggregations aggregationsContainer = aggregations != null ? new ElasticsearchAggregations(aggregations) : null;
        Suggest suggest = SearchDocumentResponseBuilder.suggestFrom(suggestES, entityCreator);
        return new SearchDocumentResponse(totalHits, totalHitsRelation, maxScore, scrollId, pointInTimeId, searchDocuments, aggregationsContainer, suggest);
    }

    @Nullable
    private static <T> Suggest suggestFrom(Map<String, List<Suggestion<EntityAsMap>>> suggestES, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        if (CollectionUtils.isEmpty(suggestES)) {
            return null;
        }
        ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>> suggestions = new ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>>();
        suggestES.forEach((name, suggestionsES) -> {
            if (!suggestionsES.isEmpty()) {
                switch (((Suggestion)suggestionsES.get(0))._kind()) {
                    case Term: {
                        suggestions.add(SearchDocumentResponseBuilder.getTermSuggestion(name, suggestionsES));
                        break;
                    }
                    case Phrase: {
                        suggestions.add(SearchDocumentResponseBuilder.getPhraseSuggestion(name, suggestionsES));
                        break;
                    }
                    case Completion: {
                        suggestions.add(SearchDocumentResponseBuilder.getCompletionSuggestion(name, suggestionsES, entityCreator));
                        break;
                    }
                }
            }
        });
        boolean hasScoreDocs = false;
        return new Suggest(suggestions, hasScoreDocs);
    }

    private static TermSuggestion getTermSuggestion(String name, List<Suggestion<EntityAsMap>> suggestionsES) {
        ArrayList<TermSuggestion.Entry> entries = new ArrayList<TermSuggestion.Entry>();
        suggestionsES.forEach(suggestionES -> {
            TermSuggest termSuggest = suggestionES.term();
            List termSuggestOptions = termSuggest.options();
            ArrayList<TermSuggestion.Entry.Option> options = new ArrayList<TermSuggestion.Entry.Option>();
            termSuggestOptions.forEach(optionES -> options.add(new TermSuggestion.Entry.Option(optionES.text(), null, optionES.score(), null, Math.toIntExact(optionES.freq()))));
            entries.add(new TermSuggestion.Entry(termSuggest.text(), termSuggest.offset(), termSuggest.length(), (List<TermSuggestion.Entry.Option>)options));
        });
        return new TermSuggestion(name, suggestionsES.size(), entries, null);
    }

    private static PhraseSuggestion getPhraseSuggestion(String name, List<Suggestion<EntityAsMap>> suggestionsES) {
        ArrayList<PhraseSuggestion.Entry> entries = new ArrayList<PhraseSuggestion.Entry>();
        suggestionsES.forEach(suggestionES -> {
            PhraseSuggest phraseSuggest = suggestionES.phrase();
            List phraseSuggestOptions = phraseSuggest.options();
            ArrayList<PhraseSuggestion.Entry.Option> options = new ArrayList<PhraseSuggestion.Entry.Option>();
            phraseSuggestOptions.forEach(optionES -> options.add(new PhraseSuggestion.Entry.Option(optionES.text(), optionES.highlighted(), null, null)));
            entries.add(new PhraseSuggestion.Entry(phraseSuggest.text(), phraseSuggest.offset(), phraseSuggest.length(), options, null));
        });
        return new PhraseSuggestion(name, suggestionsES.size(), (List<PhraseSuggestion.Entry>)entries);
    }

    private static <T> CompletionSuggestion<T> getCompletionSuggestion(String name, List<Suggestion<EntityAsMap>> suggestionsES, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        ArrayList entries = new ArrayList();
        suggestionsES.forEach(suggestionES -> {
            CompletionSuggest completionSuggest = suggestionES.completion();
            ArrayList options = new ArrayList();
            List optionsES = completionSuggest.options();
            optionsES.forEach(optionES -> {
                Object hitEntity;
                SearchDocument searchDocument;
                block3: {
                    searchDocument = optionES.source() != null ? DocumentAdapters.from((CompletionSuggestOption<EntityAsMap>)optionES) : null;
                    hitEntity = null;
                    if (searchDocument != null) {
                        try {
                            hitEntity = ((CompletableFuture)entityCreator.apply(searchDocument)).get();
                        }
                        catch (Exception e) {
                            if (!LOGGER.isWarnEnabled()) break block3;
                            LOGGER.warn((Object)("Error creating entity from SearchDocument: " + e.getMessage()));
                        }
                    }
                }
                HashMap<String, Set<String>> contexts = new HashMap<String, Set<String>>();
                optionES.contexts().forEach((key, contextList) -> contexts.put((String)key, contextList.stream().map(context -> context._get().toString()).collect(Collectors.toSet())));
                options.add(new CompletionSuggestion.Entry.Option<Object>(optionES.text(), null, optionES.score(), optionES.collateMatch() != null ? optionES.collateMatch() : false, (Map<String, Set<String>>)contexts, new ScoreDoc(optionES.score() != null ? optionES.score() : Double.NaN, null, null), searchDocument, hitEntity));
            });
            entries.add(new CompletionSuggestion.Entry(completionSuggest.text(), completionSuggest.offset(), completionSuggest.length(), options));
        });
        return new CompletionSuggestion(name, suggestionsES.size(), entries);
    }
}

