/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.DistanceUnit;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.Slices;
import co.elastic.clients.elasticsearch._types.SortMode;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.mapping.FieldType;
import co.elastic.clients.elasticsearch.core.search.BoundaryScanner;
import co.elastic.clients.elasticsearch.core.search.HighlighterEncoder;
import co.elastic.clients.elasticsearch.core.search.HighlighterFragmenter;
import co.elastic.clients.elasticsearch.core.search.HighlighterOrder;
import co.elastic.clients.elasticsearch.core.search.HighlighterTagsSchema;
import co.elastic.clients.elasticsearch.core.search.HighlighterType;
import co.elastic.clients.elasticsearch.core.search.ScoreMode;
import java.time.Duration;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.query.GeoDistanceOrder;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.lang.Nullable;

final class TypeUtils {
    TypeUtils() {
    }

    @Nullable
    static BoundaryScanner boundaryScanner(@Nullable String value) {
        if (value != null) {
            return switch (value.toLowerCase()) {
                case "chars" -> BoundaryScanner.Chars;
                case "sentence" -> BoundaryScanner.Sentence;
                case "word" -> BoundaryScanner.Word;
                default -> null;
            };
        }
        return null;
    }

    static Conflicts conflicts(ReindexRequest.Conflicts conflicts) {
        return switch (conflicts) {
            default -> throw new IncompatibleClassChangeError();
            case ReindexRequest.Conflicts.ABORT -> Conflicts.Abort;
            case ReindexRequest.Conflicts.PROCEED -> Conflicts.Proceed;
        };
    }

    @Nullable
    static DistanceUnit distanceUnit(String unit) {
        return switch (unit.toLowerCase()) {
            case "in", "inch" -> DistanceUnit.Inches;
            case "yd", "yards" -> DistanceUnit.Yards;
            case "ft", "feet" -> DistanceUnit.Feet;
            case "km", "kilometers" -> DistanceUnit.Kilometers;
            case "nm", "nmi" -> DistanceUnit.NauticMiles;
            case "mm", "millimeters" -> DistanceUnit.Millimeters;
            case "cm", "centimeters" -> DistanceUnit.Centimeters;
            case "mi", "miles" -> DistanceUnit.Miles;
            case "m", "meters" -> DistanceUnit.Meters;
            default -> null;
        };
    }

    @Nullable
    static FieldType fieldType(String type) {
        for (FieldType fieldType : FieldType.values()) {
            if (!fieldType.jsonValue().equals(type)) continue;
            return fieldType;
        }
        return null;
    }

    @Nullable
    static String toString(@Nullable FieldValue fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        switch (fieldValue._kind()) {
            case Double: {
                return String.valueOf(fieldValue.doubleValue());
            }
            case Long: {
                return String.valueOf(fieldValue.longValue());
            }
            case Boolean: {
                return String.valueOf(fieldValue.booleanValue());
            }
            case String: {
                return fieldValue.stringValue();
            }
            case Null: {
                return null;
            }
            case Any: {
                return fieldValue.anyValue().toString();
            }
        }
        throw new IllegalStateException("Unexpected value: " + fieldValue._kind());
    }

    @Nullable
    static GeoDistanceType geoDistanceType(GeoDistanceOrder.DistanceType distanceType) {
        return switch (distanceType) {
            default -> throw new IncompatibleClassChangeError();
            case GeoDistanceOrder.DistanceType.arc -> GeoDistanceType.Arc;
            case GeoDistanceOrder.DistanceType.plane -> GeoDistanceType.Plane;
        };
    }

    @Nullable
    static HighlighterFragmenter highlighterFragmenter(@Nullable String value) {
        if (value != null) {
            return switch (value.toLowerCase()) {
                case "simple" -> HighlighterFragmenter.Simple;
                case "span" -> HighlighterFragmenter.Span;
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    static HighlighterOrder highlighterOrder(@Nullable String value) {
        if (value != null && "score".equals(value.toLowerCase())) {
            return HighlighterOrder.Score;
        }
        return null;
    }

    @Nullable
    static HighlighterType highlighterType(@Nullable String value) {
        if (value != null) {
            return switch (value.toLowerCase()) {
                case "unified" -> HighlighterType.Unified;
                case "plain" -> HighlighterType.Plain;
                case "fvh" -> HighlighterType.FastVector;
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    static HighlighterEncoder highlighterEncoder(@Nullable String value) {
        if (value != null) {
            return switch (value.toLowerCase()) {
                case "default" -> HighlighterEncoder.Default;
                case "html" -> HighlighterEncoder.Html;
                default -> null;
            };
        }
        return null;
    }

    @Nullable
    static HighlighterTagsSchema highlighterTagsSchema(@Nullable String value) {
        if (value != null && "styled".equals(value.toLowerCase())) {
            return HighlighterTagsSchema.Styled;
        }
        return null;
    }

    @Nullable
    static OpType opType(@Nullable IndexQuery.OpType opType) {
        if (opType != null) {
            return switch (opType) {
                default -> throw new IncompatibleClassChangeError();
                case IndexQuery.OpType.INDEX -> OpType.Index;
                case IndexQuery.OpType.CREATE -> OpType.Create;
            };
        }
        return null;
    }

    static Refresh refresh(@Nullable RefreshPolicy refreshPolicy) {
        if (refreshPolicy == null) {
            return Refresh.False;
        }
        return switch (refreshPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case RefreshPolicy.IMMEDIATE -> Refresh.True;
            case RefreshPolicy.WAIT_UNTIL -> Refresh.WaitFor;
            case RefreshPolicy.NONE -> Refresh.False;
        };
    }

    @Nullable
    static UpdateResponse.Result result(@Nullable Result result) {
        if (result == null) {
            return null;
        }
        return switch (result) {
            default -> throw new IncompatibleClassChangeError();
            case Result.Created -> UpdateResponse.Result.CREATED;
            case Result.Updated -> UpdateResponse.Result.UPDATED;
            case Result.Deleted -> UpdateResponse.Result.DELETED;
            case Result.NotFound -> UpdateResponse.Result.NOT_FOUND;
            case Result.NoOp -> UpdateResponse.Result.NOOP;
        };
    }

    @Nullable
    static ScoreMode scoreMode(@Nullable RescorerQuery.ScoreMode scoreMode) {
        if (scoreMode == null) {
            return null;
        }
        return switch (scoreMode) {
            default -> throw new IncompatibleClassChangeError();
            case RescorerQuery.ScoreMode.Default -> null;
            case RescorerQuery.ScoreMode.Avg -> ScoreMode.Avg;
            case RescorerQuery.ScoreMode.Max -> ScoreMode.Max;
            case RescorerQuery.ScoreMode.Min -> ScoreMode.Min;
            case RescorerQuery.ScoreMode.Total -> ScoreMode.Total;
            case RescorerQuery.ScoreMode.Multiply -> ScoreMode.Multiply;
        };
    }

    @Nullable
    static SearchType searchType(@Nullable Query.SearchType searchType) {
        if (searchType == null) {
            return null;
        }
        return switch (searchType) {
            default -> throw new IncompatibleClassChangeError();
            case Query.SearchType.QUERY_THEN_FETCH -> SearchType.QueryThenFetch;
            case Query.SearchType.DFS_QUERY_THEN_FETCH -> SearchType.DfsQueryThenFetch;
        };
    }

    @Nullable
    static Slices slices(@Nullable Long count) {
        if (count == null) {
            return null;
        }
        return Slices.of(s -> s.value(Integer.valueOf(Math.toIntExact(count))));
    }

    @Nullable
    static SortMode sortMode(Order.Mode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Order.Mode.min -> SortMode.Min;
            case Order.Mode.max -> SortMode.Max;
            case Order.Mode.median -> SortMode.Median;
            case Order.Mode.avg -> SortMode.Avg;
        };
    }

    @Nullable
    static Time time(@Nullable Duration duration) {
        if (duration == null) {
            return null;
        }
        return Time.of(t -> t.time(duration.toMillis() + "ms"));
    }

    @Nullable
    static String timeStringMs(@Nullable Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis() + "ms";
    }

    @Nullable
    static VersionType versionType(@Nullable Document.VersionType versionType) {
        if (versionType != null) {
            return switch (versionType) {
                default -> throw new IncompatibleClassChangeError();
                case Document.VersionType.INTERNAL -> VersionType.Internal;
                case Document.VersionType.EXTERNAL -> VersionType.External;
                case Document.VersionType.EXTERNAL_GTE -> VersionType.ExternalGte;
                case Document.VersionType.FORCE -> VersionType.Force;
            };
        }
        return null;
    }

    static Integer waitForActiveShardsCount(@Nullable String value) {
        if (value == null) {
            return -2;
        }
        if ("all".equals(value.toUpperCase())) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegale value for waitForActiveShards" + value);
        }
    }

    @Nullable
    static Float toFloat(@Nullable Long value) {
        return value != null ? Float.valueOf(value.longValue()) : null;
    }
}

