/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.json.JsonpMapper;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.client.ResponseException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.client.elc.JsonUtils;

public class ElasticsearchExceptionTranslator
implements PersistenceExceptionTranslator {
    private final JsonpMapper jsonpMapper;

    public ElasticsearchExceptionTranslator(JsonpMapper jsonpMapper) {
        this.jsonpMapper = jsonpMapper;
    }

    public RuntimeException translateException(Throwable throwable) {
        RuntimeException runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable.getMessage(), throwable);
        DataAccessException potentiallyTranslatedException = this.translateExceptionIfPossible(runtimeException);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : runtimeException;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (this.isSeqNoConflict(ex)) {
            return new OptimisticLockingFailureException("Cannot index a document due to seq_no+primary_term conflict", (Throwable)ex);
        }
        if (ex instanceof ElasticsearchException) {
            String errorReason;
            ElasticsearchException elasticsearchException = (ElasticsearchException)ex;
            ErrorResponse response = elasticsearchException.response();
            String errorType = response.error().type();
            String string = errorReason = response.error().reason() != null ? response.error().reason() : "undefined reason";
            if (response.status() == 404 && "index_not_found_exception".equals(errorType)) {
                Pattern pattern = Pattern.compile(".*no such index \\[(.*)\\]");
                String index = "";
                Matcher matcher = pattern.matcher(errorReason);
                if (matcher.matches()) {
                    index = matcher.group(1);
                }
                return new NoSuchIndexException(index);
            }
            String body = JsonUtils.toJson(response, this.jsonpMapper);
            if (errorType != null && errorType.contains("validation_exception")) {
                return new DataIntegrityViolationException(errorReason);
            }
            return new UncategorizedElasticsearchException(ex.getMessage(), response.status(), body, ex);
        }
        Throwable cause = ex.getCause();
        if (cause instanceof IOException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private boolean isSeqNoConflict(Throwable exception) {
        Integer status = null;
        String message = null;
        if (exception instanceof ResponseException) {
            ResponseException responseException = (ResponseException)exception;
            status = responseException.getResponse().getStatusLine().getStatusCode();
            message = responseException.getMessage();
        } else if (exception.getCause() != null) {
            return this.isSeqNoConflict(exception.getCause());
        }
        if (status != null && message != null) {
            return status == 409 && message.contains("type\":\"version_conflict_engine_exception") && message.contains("version conflict, required seqNo");
        }
        return false;
    }
}

