/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.InlineScript;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.WaitForActiveShardOptions;
import co.elastic.clients.elasticsearch._types.mapping.FieldType;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeFieldType;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldAndFormat;
import co.elastic.clients.elasticsearch._types.query_dsl.Like;
import co.elastic.clients.elasticsearch._types.query_dsl.MoreLikeThisQuery;
import co.elastic.clients.elasticsearch.cluster.HealthRequest;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.ClosePointInTimeRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.MsearchRequest;
import co.elastic.clients.elasticsearch.core.OpenPointInTimeRequest;
import co.elastic.clients.elasticsearch.core.ReindexRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.CreateOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.elasticsearch.core.mget.MultiGetOperation;
import co.elastic.clients.elasticsearch.core.msearch.MultisearchBody;
import co.elastic.clients.elasticsearch.core.search.Highlight;
import co.elastic.clients.elasticsearch.core.search.Rescore;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteTemplateRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.ExistsTemplateRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasRequest;
import co.elastic.clients.elasticsearch.indices.GetIndexRequest;
import co.elastic.clients.elasticsearch.indices.GetIndicesSettingsRequest;
import co.elastic.clients.elasticsearch.indices.GetMappingRequest;
import co.elastic.clients.elasticsearch.indices.GetTemplateRequest;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.PutMappingRequest;
import co.elastic.clients.elasticsearch.indices.PutTemplateRequest;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesRequest;
import co.elastic.clients.elasticsearch.indices.update_aliases.Action;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.client.elc.CriteriaFilterProcessor;
import org.springframework.data.elasticsearch.client.elc.CriteriaQueryProcessor;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.HighlightQueryBuilder;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.QueryBuilders;
import org.springframework.data.elasticsearch.client.elc.TypeUtils;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.ScriptType;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasAction;
import org.springframework.data.elasticsearch.core.index.AliasActionParameters;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.GeoDistanceOrder;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.ScriptData;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.data.elasticsearch.core.reindex.Remote;
import org.springframework.data.elasticsearch.support.DefaultStringObjectMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class RequestConverter {
    public static final Integer INDEX_MAX_RESULT_WINDOW = 10000;
    protected final JsonpMapper jsonpMapper;
    protected final ElasticsearchConverter elasticsearchConverter;

    public RequestConverter(ElasticsearchConverter elasticsearchConverter, JsonpMapper jsonpMapper) {
        this.elasticsearchConverter = elasticsearchConverter;
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        this.jsonpMapper = jsonpMapper;
    }

    public HealthRequest clusterHealthRequest() {
        return new HealthRequest.Builder().build();
    }

    public ExistsRequest indicesExistsRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new ExistsRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).build();
    }

    public CreateIndexRequest indicesCreateRequest(IndexCoordinates indexCoordinates, Map<String, Object> settings, @Nullable Document mapping) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        Assert.notNull(settings, (String)"settings must not be null");
        CreateIndexRequest.Builder createRequestBuilder = new CreateIndexRequest.Builder();
        createRequestBuilder.index(indexCoordinates.getIndexName());
        String settingsJson = Document.from(settings).toJson();
        IndexSettings indexSettings = (IndexSettings)this.fromJson(settingsJson, IndexSettings._DESERIALIZER);
        createRequestBuilder.settings(indexSettings);
        if (mapping != null) {
            String mappingJson = mapping.toJson();
            TypeMapping typeMapping = (TypeMapping)this.fromJson(mappingJson, TypeMapping._DESERIALIZER);
            createRequestBuilder.mappings(typeMapping);
        }
        return createRequestBuilder.build();
    }

    public RefreshRequest indicesRefreshRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new RefreshRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).build();
    }

    public DeleteIndexRequest indicesDeleteRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new DeleteIndexRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).build();
    }

    public UpdateAliasesRequest indicesUpdateAliasesRequest(AliasActions aliasActions) {
        Assert.notNull((Object)aliasActions, (String)"aliasActions must not be null");
        UpdateAliasesRequest.Builder updateAliasRequestBuilder = new UpdateAliasesRequest.Builder();
        ArrayList actions = new ArrayList();
        aliasActions.getActions().forEach(aliasAction -> {
            AliasActionParameters parameters;
            Action.Builder actionBuilder = new Action.Builder();
            if (aliasAction instanceof AliasAction.Add) {
                AliasAction.Add add = (AliasAction.Add)aliasAction;
                parameters = add.getParameters();
                actionBuilder.add(addActionBuilder -> {
                    Query filterQuery;
                    addActionBuilder.indices(Arrays.asList(parameters.getIndices())).isHidden(parameters.getHidden()).isWriteIndex(parameters.getWriteIndex()).routing(parameters.getRouting()).indexRouting(parameters.getIndexRouting()).searchRouting(parameters.getSearchRouting());
                    if (parameters.getAliases() != null) {
                        addActionBuilder.aliases(Arrays.asList(parameters.getAliases()));
                    }
                    if ((filterQuery = parameters.getFilterQuery()) != null) {
                        this.elasticsearchConverter.updateQuery(filterQuery, parameters.getFilterQueryClass());
                        co.elastic.clients.elasticsearch._types.query_dsl.Query esQuery = this.getQuery(filterQuery, null);
                        if (esQuery != null) {
                            addActionBuilder.filter(esQuery);
                        }
                    }
                    return addActionBuilder;
                });
            }
            if (aliasAction instanceof AliasAction.Remove) {
                AliasAction.Remove remove = (AliasAction.Remove)aliasAction;
                parameters = remove.getParameters();
                actionBuilder.remove(removeActionBuilder -> {
                    removeActionBuilder.indices(Arrays.asList(parameters.getIndices()));
                    if (parameters.getAliases() != null) {
                        removeActionBuilder.aliases(Arrays.asList(parameters.getAliases()));
                    }
                    return removeActionBuilder;
                });
            }
            if (aliasAction instanceof AliasAction.RemoveIndex) {
                AliasAction.RemoveIndex removeIndex = (AliasAction.RemoveIndex)aliasAction;
                parameters = removeIndex.getParameters();
                actionBuilder.removeIndex(removeIndexActionBuilder -> removeIndexActionBuilder.indices(Arrays.asList(parameters.getIndices())));
            }
            actions.add(actionBuilder.build());
        });
        updateAliasRequestBuilder.actions(actions);
        return updateAliasRequestBuilder.build();
    }

    public PutMappingRequest indicesPutMappingRequest(IndexCoordinates indexCoordinates, Document mapping) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        Assert.notNull((Object)mapping, (String)"mapping must not be null");
        PutMappingRequest.Builder builder = new PutMappingRequest.Builder();
        builder.index(Arrays.asList(indexCoordinates.getIndexNames()));
        this.addPropertiesToMapping(builder, mapping);
        return builder.build();
    }

    public GetMappingRequest indicesGetMappingRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new GetMappingRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).build();
    }

    private void addPropertiesToMapping(PutMappingRequest.Builder builder, Document mapping) {
        Object properties = mapping.get("properties");
        if (properties != null && properties instanceof Map) {
            HashMap propertiesMap = new HashMap();
            ((Map)properties).forEach((key, value) -> {
                Property property = this.getProperty(value);
                propertiesMap.put(key, property);
            });
            builder.properties(propertiesMap);
        }
    }

    private Property getProperty(Object value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator generator = this.jsonpMapper.jsonProvider().createGenerator((OutputStream)baos);
        this.jsonpMapper.serialize(value, generator);
        generator.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return (Property)this.fromJson(bais, Property._DESERIALIZER);
    }

    public GetIndicesSettingsRequest indicesGetSettingsRequest(IndexCoordinates indexCoordinates, boolean includeDefaults) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new GetIndicesSettingsRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).includeDefaults(Boolean.valueOf(includeDefaults)).build();
    }

    public GetIndexRequest indicesGetIndexRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new GetIndexRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).includeDefaults(Boolean.valueOf(true)).build();
    }

    public GetAliasRequest indicesGetAliasRequest(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasRequest.Builder builder = new GetAliasRequest.Builder();
        if (aliasNames != null) {
            builder.name(Arrays.asList(aliasNames));
        }
        if (indexNames != null) {
            builder.index(Arrays.asList(indexNames));
        }
        return builder.build();
    }

    public co.elastic.clients.elasticsearch.indices.PutTemplateRequest indicesPutTemplateRequest(PutTemplateRequest putTemplateRequest) {
        AliasActions aliasActions;
        Assert.notNull((Object)putTemplateRequest, (String)"putTemplateRequest must not be null");
        PutTemplateRequest.Builder builder = new PutTemplateRequest.Builder();
        builder.name(putTemplateRequest.getName()).indexPatterns(Arrays.asList(putTemplateRequest.getIndexPatterns())).order(Integer.valueOf(putTemplateRequest.getOrder()));
        if (putTemplateRequest.getSettings() != null) {
            Function<Map.Entry, String> keyMapper = Map.Entry::getKey;
            Function<Map.Entry, JsonData> valueMapper = entry -> JsonData.of(entry.getValue(), (JsonpMapper)this.jsonpMapper);
            Map<String, JsonData> settings = putTemplateRequest.getSettings().entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper));
            builder.settings(settings);
        }
        if (putTemplateRequest.getMappings() != null) {
            builder.mappings((TypeMapping)this.fromJson(putTemplateRequest.getMappings().toJson(), TypeMapping._DESERIALIZER));
        }
        if (putTemplateRequest.getVersion() != null) {
            builder.version(Long.valueOf(putTemplateRequest.getVersion().intValue()));
        }
        if ((aliasActions = putTemplateRequest.getAliasActions()) != null) {
            aliasActions.getActions().forEach(aliasAction -> {
                AliasActionParameters parameters = aliasAction.getParameters();
                String[] parametersAliases = parameters.getAliases();
                if (parametersAliases != null) {
                    for (String aliasName : parametersAliases) {
                        builder.aliases(aliasName, aliasBuilder -> {
                            co.elastic.clients.elasticsearch._types.query_dsl.Query esQuery;
                            Query filterQuery;
                            if (parameters.getRouting() != null) {
                                aliasBuilder.routing(parameters.getRouting());
                            }
                            if (parameters.getIndexRouting() != null) {
                                aliasBuilder.indexRouting(parameters.getIndexRouting());
                            }
                            if (parameters.getSearchRouting() != null) {
                                aliasBuilder.searchRouting(parameters.getSearchRouting());
                            }
                            if (parameters.getHidden() != null) {
                                aliasBuilder.isHidden(parameters.getHidden());
                            }
                            if (parameters.getWriteIndex() != null) {
                                aliasBuilder.isWriteIndex(parameters.getWriteIndex());
                            }
                            if ((filterQuery = parameters.getFilterQuery()) != null && (esQuery = this.getQuery(filterQuery, null)) != null) {
                                aliasBuilder.filter(esQuery);
                            }
                            return aliasBuilder;
                        });
                    }
                }
            });
        }
        return builder.build();
    }

    public ExistsTemplateRequest indicesExistsTemplateRequest(org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        return ExistsTemplateRequest.of(etr -> etr.name(existsTemplateRequest.getTemplateName(), new String[0]));
    }

    public DeleteTemplateRequest indicesDeleteTemplateRequest(org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        return DeleteTemplateRequest.of(dtr -> dtr.name(existsTemplateRequest.getTemplateName()));
    }

    public GetTemplateRequest indicesGetTemplateRequest(org.springframework.data.elasticsearch.core.index.GetTemplateRequest getTemplateRequest) {
        Assert.notNull((Object)getTemplateRequest, (String)"getTemplateRequest must not be null");
        return GetTemplateRequest.of(gtr -> gtr.name(getTemplateRequest.getTemplateName(), new String[0]).flatSettings(Boolean.valueOf(true)));
    }

    public IndexRequest<?> documentIndexRequest(IndexQuery query, IndexCoordinates indexCoordinates, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        IndexRequest.Builder builder = new IndexRequest.Builder();
        builder.index(query.getIndexName() != null ? query.getIndexName() : indexCoordinates.getIndexName());
        Object queryObject = query.getObject();
        if (queryObject != null) {
            String id = StringUtils.hasText((String)query.getId()) ? query.getId() : this.getPersistentEntityId(queryObject);
            builder.id(id).document((Object)this.elasticsearchConverter.mapObject(queryObject));
        } else if (query.getSource() != null) {
            builder.id(query.getId()).document(new DefaultStringObjectMap().fromJson(query.getSource()));
        } else {
            throw new InvalidDataAccessApiUsageException("object or source is null, failed to index the document [id: " + query.getId() + "]");
        }
        if (query.getVersion() != null) {
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(queryObject != null ? queryObject.getClass() : null);
            builder.version(query.getVersion()).versionType(versionType);
        }
        builder.ifSeqNo(query.getSeqNo()).ifPrimaryTerm(query.getPrimaryTerm()).routing(query.getRouting());
        if (query.getOpType() != null) {
            switch (query.getOpType()) {
                case INDEX: {
                    builder.opType(OpType.Index);
                    break;
                }
                case CREATE: {
                    builder.opType(OpType.Create);
                }
            }
        }
        builder.refresh(TypeUtils.refresh(refreshPolicy));
        return builder.build();
    }

    private IndexOperation<?> bulkIndexOperation(IndexQuery query, IndexCoordinates indexCoordinates, @Nullable RefreshPolicy refreshPolicy) {
        IndexOperation.Builder builder = new IndexOperation.Builder();
        builder.index(query.getIndexName() != null ? query.getIndexName() : indexCoordinates.getIndexName());
        Object queryObject = query.getObject();
        if (queryObject != null) {
            String id = StringUtils.hasText((String)query.getId()) ? query.getId() : this.getPersistentEntityId(queryObject);
            ((IndexOperation.Builder)builder.id(id)).document((Object)this.elasticsearchConverter.mapObject(queryObject));
        } else if (query.getSource() != null) {
            builder.document(new DefaultStringObjectMap().fromJson(query.getSource()));
        } else {
            throw new InvalidDataAccessApiUsageException("object or source is null, failed to index the document [id: " + query.getId() + "]");
        }
        if (query.getVersion() != null) {
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(queryObject != null ? queryObject.getClass() : null);
            ((IndexOperation.Builder)builder.version(query.getVersion())).versionType(versionType);
        }
        ((IndexOperation.Builder)((IndexOperation.Builder)builder.ifSeqNo(query.getSeqNo())).ifPrimaryTerm(query.getPrimaryTerm())).routing(query.getRouting());
        return builder.build();
    }

    private CreateOperation<?> bulkCreateOperation(IndexQuery query, IndexCoordinates indexCoordinates, @Nullable RefreshPolicy refreshPolicy) {
        CreateOperation.Builder builder = new CreateOperation.Builder();
        builder.index(query.getIndexName() != null ? query.getIndexName() : indexCoordinates.getIndexName());
        Object queryObject = query.getObject();
        if (queryObject != null) {
            String id = StringUtils.hasText((String)query.getId()) ? query.getId() : this.getPersistentEntityId(queryObject);
            ((CreateOperation.Builder)builder.id(id)).document((Object)this.elasticsearchConverter.mapObject(queryObject));
        } else if (query.getSource() != null) {
            builder.document(new DefaultStringObjectMap().fromJson(query.getSource()));
        } else {
            throw new InvalidDataAccessApiUsageException("object or source is null, failed to index the document [id: " + query.getId() + "]");
        }
        if (query.getVersion() != null) {
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(queryObject != null ? queryObject.getClass() : null);
            ((CreateOperation.Builder)builder.version(query.getVersion())).versionType(versionType);
        }
        ((CreateOperation.Builder)((CreateOperation.Builder)builder.ifSeqNo(query.getSeqNo())).ifPrimaryTerm(query.getPrimaryTerm())).routing(query.getRouting());
        return builder.build();
    }

    private UpdateOperation<?, ?> bulkUpdateOperation(UpdateQuery query, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy) {
        UpdateOperation.Builder uob = new UpdateOperation.Builder();
        String indexName = query.getIndexName() != null ? query.getIndexName() : index.getIndexName();
        ((UpdateOperation.Builder)uob.index(indexName)).id(query.getId());
        uob.action(a -> {
            a.script(this.getScript(query.getScriptData())).doc((Object)query.getDocument()).upsert((Object)query.getUpsert()).scriptedUpsert(query.getScriptedUpsert()).docAsUpsert(query.getDocAsUpsert());
            if (query.getFetchSource() != null) {
                a.source(sc -> sc.fetch(query.getFetchSource()));
            }
            if (query.getFetchSourceIncludes() != null || query.getFetchSourceExcludes() != null) {
                List<Object> includes = query.getFetchSourceIncludes() != null ? query.getFetchSourceIncludes() : Collections.emptyList();
                List<Object> excludes = query.getFetchSourceExcludes() != null ? query.getFetchSourceExcludes() : Collections.emptyList();
                a.source(sc -> sc.filter(sf -> sf.includes(includes).excludes(excludes)));
            }
            return a;
        });
        ((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)uob.routing(query.getRouting())).ifSeqNo(query.getIfSeqNo() != null ? Long.valueOf(query.getIfSeqNo().intValue()) : null)).ifPrimaryTerm(query.getIfPrimaryTerm() != null ? Long.valueOf(query.getIfPrimaryTerm().intValue()) : null)).retryOnConflict(query.getRetryOnConflict());
        return uob.build();
    }

    @Nullable
    private Script getScript(@Nullable ScriptData scriptData) {
        if (scriptData == null) {
            return null;
        }
        HashMap params = new HashMap();
        if (scriptData.params() != null) {
            scriptData.params().forEach((key, value) -> params.put(key, JsonData.of((Object)value, (JsonpMapper)this.jsonpMapper)));
        }
        return Script.of(sb -> {
            if (scriptData.type() == ScriptType.INLINE) {
                sb.inline(is -> (ObjectBuilder)is.lang(scriptData.language()).source(scriptData.script()).params(params));
            } else if (scriptData.type() == ScriptType.STORED) {
                sb.stored(ss -> (ObjectBuilder)ss.id(scriptData.script()).params(params));
            }
            return sb;
        });
    }

    public BulkRequest documentBulkRequest(List<?> queries, BulkOptions bulkOptions, IndexCoordinates indexCoordinates, @Nullable RefreshPolicy refreshPolicy) {
        BulkRequest.Builder builder = new BulkRequest.Builder();
        if (bulkOptions.getTimeout() != null) {
            builder.timeout(tb -> tb.time(Long.valueOf(bulkOptions.getTimeout().toMillis()).toString() + "ms"));
        }
        builder.refresh(TypeUtils.refresh(refreshPolicy));
        if (bulkOptions.getRefreshPolicy() != null) {
            builder.refresh(TypeUtils.refresh(bulkOptions.getRefreshPolicy()));
        }
        if (bulkOptions.getWaitForActiveShards() != null) {
            builder.waitForActiveShards(wasb -> wasb.count(Integer.valueOf(bulkOptions.getWaitForActiveShards().value())));
        }
        if (bulkOptions.getPipeline() != null) {
            builder.pipeline(bulkOptions.getPipeline());
        }
        if (bulkOptions.getRoutingId() != null) {
            builder.routing(bulkOptions.getRoutingId());
        }
        List operations = queries.stream().map(query -> {
            BulkOperation.Builder ob = new BulkOperation.Builder();
            if (query instanceof IndexQuery) {
                IndexQuery indexQuery = (IndexQuery)query;
                if (indexQuery.getOpType() == IndexQuery.OpType.CREATE) {
                    ob.create(this.bulkCreateOperation(indexQuery, indexCoordinates, refreshPolicy));
                } else {
                    ob.index(this.bulkIndexOperation(indexQuery, indexCoordinates, refreshPolicy));
                }
            } else if (query instanceof UpdateQuery) {
                UpdateQuery updateQuery = (UpdateQuery)query;
                ob.update(this.bulkUpdateOperation(updateQuery, indexCoordinates, refreshPolicy));
            }
            return ob.build();
        }).collect(Collectors.toList());
        builder.operations(operations);
        return builder.build();
    }

    public GetRequest documentGetRequest(String id, @Nullable String routing, IndexCoordinates indexCoordinates, boolean forExistsRequest) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return GetRequest.of(grb -> {
            grb.index(indexCoordinates.getIndexName()).id(id).routing(routing);
            if (forExistsRequest) {
                grb.source(scp -> scp.fetch(Boolean.valueOf(false)));
            }
            return grb;
        });
    }

    public <T> MgetRequest documentMgetRequest(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        if (query.getIdsWithRouting().isEmpty()) {
            throw new IllegalArgumentException("query does not contain any ids");
        }
        this.elasticsearchConverter.updateQuery(query, clazz);
        SourceConfig sourceConfig = this.getSourceConfig(query);
        List multiGetOperations = query.getIdsWithRouting().stream().map(idWithRouting -> MultiGetOperation.of(mgo -> mgo.index(index.getIndexName()).id(idWithRouting.id()).routing(idWithRouting.routing()).source(sourceConfig))).collect(Collectors.toList());
        return MgetRequest.of(mg -> mg.docs(multiGetOperations));
    }

    public co.elastic.clients.elasticsearch.core.ReindexRequest reindex(ReindexRequest reindexRequest, boolean waitForCompletion) {
        ReindexRequest.Script script;
        Assert.notNull((Object)reindexRequest, (String)"reindexRequest must not be null");
        ReindexRequest.Builder builder = new ReindexRequest.Builder();
        builder.source(s -> {
            SourceFilter sourceFilter;
            ReindexRequest.Source source = reindexRequest.getSource();
            s.index(Arrays.asList(source.getIndexes().getIndexNames())).size(source.getSize());
            ReindexRequest.Slice slice = source.getSlice();
            if (slice != null) {
                s.slice(sl -> sl.id(String.valueOf(slice.getId())).max(slice.getMax()));
            }
            if (source.getQuery() != null) {
                s.query(this.getQuery(source.getQuery(), null));
            }
            if (source.getRemote() != null) {
                Remote remote = source.getRemote();
                s.remote(rs -> {
                    StringBuilder sb = new StringBuilder(remote.getScheme());
                    sb.append("://");
                    sb.append(remote.getHost());
                    sb.append(":");
                    sb.append(remote.getPort());
                    if (remote.getPathPrefix() != null) {
                        sb.append("");
                        sb.append(remote.getPathPrefix());
                    }
                    String socketTimeoutSecs = remote.getSocketTimeout() != null ? remote.getSocketTimeout().getSeconds() + "s" : "30s";
                    String connectTimeoutSecs = remote.getConnectTimeout() != null ? remote.getConnectTimeout().getSeconds() + "s" : "30s";
                    return rs.host(sb.toString()).username(remote.getUsername()).password(remote.getPassword()).socketTimeout(tv -> tv.time(socketTimeoutSecs)).connectTimeout(tv -> tv.time(connectTimeoutSecs));
                });
            }
            if ((sourceFilter = source.getSourceFilter()) != null) {
                s.sourceFields(Arrays.asList(sourceFilter.getIncludes()));
            }
            return s;
        }).dest(d -> {
            ReindexRequest.Dest dest = reindexRequest.getDest();
            return d.index(dest.getIndex().getIndexName()).versionType(TypeUtils.versionType(dest.getVersionType())).opType(TypeUtils.opType(dest.getOpType()));
        });
        if (reindexRequest.getConflicts() != null) {
            builder.conflicts(TypeUtils.conflicts(reindexRequest.getConflicts()));
        }
        if ((script = reindexRequest.getScript()) != null) {
            builder.script(s -> s.inline(InlineScript.of(i -> i.lang(script.getLang()).source(script.getSource()))));
        }
        builder.timeout(TypeUtils.time(reindexRequest.getTimeout())).scroll(TypeUtils.time(reindexRequest.getScroll()));
        if (reindexRequest.getWaitForActiveShards() != null) {
            builder.waitForActiveShards(wfas -> wfas.count(TypeUtils.waitForActiveShardsCount(reindexRequest.getWaitForActiveShards())));
        }
        builder.maxDocs(reindexRequest.getMaxDocs()).waitForCompletion(Boolean.valueOf(waitForCompletion)).refresh(reindexRequest.getRefresh()).requireAlias(reindexRequest.getRequireAlias()).requestsPerSecond(TypeUtils.toFloat(reindexRequest.getRequestsPerSecond())).slices(TypeUtils.slices(reindexRequest.getSlices()));
        return builder.build();
    }

    public DeleteRequest documentDeleteRequest(String id, @Nullable String routing, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return DeleteRequest.of(r -> {
            r.id(id).index(index.getIndexName());
            if (routing != null) {
                r.routing(routing);
            }
            r.refresh(TypeUtils.refresh(refreshPolicy));
            return r;
        });
    }

    public DeleteByQueryRequest documentDeleteByQueryRequest(Query query, Class<?> clazz, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return DeleteByQueryRequest.of(b -> {
            b.index(Arrays.asList(index.getIndexNames())).query(this.getQuery(query, clazz)).refresh(RequestConverter.deleteByQueryRefresh(refreshPolicy));
            if (query.isLimiting()) {
                b.maxDocs(Long.valueOf(query.getMaxResults().intValue()));
            }
            b.scroll(TypeUtils.time(query.getScrollTime()));
            if (query.getRoute() != null) {
                b.routing(query.getRoute());
            }
            return b;
        });
    }

    public UpdateRequest<Document, ?> documentUpdateRequest(UpdateQuery query, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy, @Nullable String routing) {
        String indexName = query.getIndexName() != null ? query.getIndexName() : index.getIndexName();
        return UpdateRequest.of(uqb -> {
            String waitForActiveShards;
            uqb.index(indexName).id(query.getId());
            if (query.getScript() != null) {
                HashMap params = new HashMap();
                if (query.getParams() != null) {
                    query.getParams().forEach((key, value) -> params.put(key, JsonData.of((Object)value, (JsonpMapper)this.jsonpMapper)));
                }
                uqb.script(sb -> {
                    if (query.getScriptType() == ScriptType.INLINE) {
                        sb.inline(is -> (ObjectBuilder)is.lang(query.getLang()).source(query.getScript()).params(params));
                    } else if (query.getScriptType() == ScriptType.STORED) {
                        sb.stored(ss -> (ObjectBuilder)ss.id(query.getScript()).params(params));
                    }
                    return sb;
                });
            }
            uqb.doc((Object)query.getDocument()).upsert((Object)query.getUpsert()).routing(query.getRouting() != null ? query.getRouting() : routing).scriptedUpsert(query.getScriptedUpsert()).docAsUpsert(query.getDocAsUpsert()).ifSeqNo(query.getIfSeqNo() != null ? Long.valueOf(query.getIfSeqNo().intValue()) : null).ifPrimaryTerm(query.getIfPrimaryTerm() != null ? Long.valueOf(query.getIfPrimaryTerm().intValue()) : null).refresh(TypeUtils.refresh(refreshPolicy)).retryOnConflict(query.getRetryOnConflict());
            if (query.getFetchSource() != null) {
                uqb.source(sc -> sc.fetch(query.getFetchSource()));
            }
            if (query.getFetchSourceIncludes() != null || query.getFetchSourceExcludes() != null) {
                List<Object> includes = query.getFetchSourceIncludes() != null ? query.getFetchSourceIncludes() : Collections.emptyList();
                List<Object> excludes = query.getFetchSourceExcludes() != null ? query.getFetchSourceExcludes() : Collections.emptyList();
                uqb.source(sc -> sc.filter(sf -> sf.includes(includes).excludes(excludes)));
            }
            if (query.getTimeout() != null) {
                uqb.timeout(tv -> tv.time(query.getTimeout()));
            }
            if ((waitForActiveShards = query.getWaitForActiveShards()) != null) {
                if ("all".equalsIgnoreCase(waitForActiveShards)) {
                    uqb.waitForActiveShards(wfa -> wfa.option(WaitForActiveShardOptions.All));
                } else {
                    int val;
                    try {
                        val = Integer.parseInt(waitForActiveShards);
                    }
                    catch (NumberFormatException var3) {
                        throw new IllegalArgumentException("cannot parse ActiveShardCount[" + waitForActiveShards + "]", var3);
                    }
                    uqb.waitForActiveShards(wfa -> wfa.count(Integer.valueOf(val)));
                }
            }
            return uqb;
        });
    }

    public UpdateByQueryRequest documentUpdateByQueryRequest(UpdateQuery updateQuery, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy) {
        return UpdateByQueryRequest.of(ub -> {
            ub.index(Arrays.asList(index.getIndexNames())).refresh(Boolean.valueOf(refreshPolicy == RefreshPolicy.IMMEDIATE)).routing(updateQuery.getRouting()).script(this.getScript(updateQuery.getScriptData())).maxDocs(updateQuery.getMaxDocs() != null ? Long.valueOf(updateQuery.getMaxDocs().intValue()) : null).pipeline(updateQuery.getPipeline()).requestsPerSecond(updateQuery.getRequestsPerSecond()).slices(TypeUtils.slices(updateQuery.getSlices() != null ? Long.valueOf(updateQuery.getSlices().intValue()) : null));
            if (updateQuery.getAbortOnVersionConflict() != null) {
                ub.conflicts(updateQuery.getAbortOnVersionConflict() != false ? Conflicts.Abort : Conflicts.Proceed);
            }
            if (updateQuery.getQuery() != null) {
                Query queryQuery = updateQuery.getQuery();
                if (updateQuery.getBatchSize() != null) {
                    ((BaseQuery)queryQuery).setMaxResults(updateQuery.getBatchSize());
                }
                ub.query(this.getQuery(queryQuery, null));
                ub.scroll(TypeUtils.time(queryQuery.getScrollTime()));
            }
            if (updateQuery.getRefreshPolicy() != null) {
                ub.refresh(Boolean.valueOf(updateQuery.getRefreshPolicy() == RefreshPolicy.IMMEDIATE));
            }
            if (updateQuery.getTimeout() != null) {
                ub.timeout(tb -> tb.time(updateQuery.getTimeout()));
            }
            if (updateQuery.getWaitForActiveShards() != null) {
                ub.waitForActiveShards(w -> w.count(TypeUtils.waitForActiveShardsCount(updateQuery.getWaitForActiveShards())));
            }
            return ub;
        });
    }

    public <T> SearchRequest searchRequest(Query query, @Nullable Class<T> clazz, IndexCoordinates indexCoordinates, boolean forCount, long scrollTimeInMillis) {
        return this.searchRequest(query, clazz, indexCoordinates, forCount, true, scrollTimeInMillis);
    }

    public <T> SearchRequest searchRequest(Query query, @Nullable Class<T> clazz, IndexCoordinates indexCoordinates, boolean forCount, boolean useScroll) {
        return this.searchRequest(query, clazz, indexCoordinates, forCount, useScroll, null);
    }

    public <T> SearchRequest searchRequest(Query query, @Nullable Class<T> clazz, IndexCoordinates indexCoordinates, boolean forCount, boolean useScroll, @Nullable Long scrollTimeInMillis) {
        String[] indexNames = indexCoordinates.getIndexNames();
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        this.elasticsearchConverter.updateQuery(query, clazz);
        SearchRequest.Builder builder = new SearchRequest.Builder();
        this.prepareSearchRequest(query, clazz, indexCoordinates, builder, forCount, useScroll);
        if (scrollTimeInMillis != null) {
            builder.scroll(t -> t.time(scrollTimeInMillis + "ms"));
        }
        builder.query(this.getQuery(query, clazz));
        this.addFilter(query, builder);
        return builder.build();
    }

    public MsearchRequest searchMsearchRequest(List<ElasticsearchTemplate.MultiSearchQueryParameter> multiSearchQueryParameters) {
        return MsearchRequest.of(mrb -> {
            multiSearchQueryParameters.forEach(param -> {
                ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity(param.clazz());
                Query query = param.query();
                mrb.searches(sb -> sb.header(h -> {
                    h.index(Arrays.asList(param.index().getIndexNames())).routing(query.getRoute()).searchType(TypeUtils.searchType(query.getSearchType())).requestCache(query.getRequestCache());
                    if (query.getPreference() != null) {
                        h.preference(query.getPreference());
                    }
                    return h;
                }).body(bb -> {
                    List<SortOptions> sortOptions;
                    bb.query(this.getQuery(query, param.clazz())).seqNoPrimaryTerm(persistentEntity != null ? Boolean.valueOf(persistentEntity.hasSeqNoPrimaryTermProperty()) : null).version(Boolean.valueOf(true)).trackScores(Boolean.valueOf(query.getTrackScores())).source(this.getSourceConfig(query)).timeout(TypeUtils.timeStringMs(query.getTimeout()));
                    if (query.getPageable().isPaged()) {
                        bb.from(Integer.valueOf((int)query.getPageable().getOffset())).size(Integer.valueOf(query.getPageable().getPageSize()));
                    }
                    if (!CollectionUtils.isEmpty(query.getFields())) {
                        bb.fields(fb -> {
                            query.getFields().forEach(arg_0 -> ((FieldAndFormat.Builder)fb).field(arg_0));
                            return fb;
                        });
                    }
                    if (!CollectionUtils.isEmpty(query.getStoredFields())) {
                        bb.storedFields(query.getStoredFields());
                    }
                    if (query.isLimiting()) {
                        bb.size(query.getMaxResults());
                    }
                    if (query.getMinScore() > 0.0f) {
                        bb.minScore(Double.valueOf(query.getMinScore()));
                    }
                    if (query.getSort() != null && !(sortOptions = this.getSortOptions(query.getSort(), persistentEntity)).isEmpty()) {
                        bb.sort(sortOptions);
                    }
                    this.addHighlight(query, (MultisearchBody.Builder)bb);
                    if (query.getExplain()) {
                        bb.explain(Boolean.valueOf(true));
                    }
                    if (!CollectionUtils.isEmpty(query.getSearchAfter())) {
                        bb.searchAfter(query.getSearchAfter().stream().map(it -> FieldValue.of((String)it.toString())).collect(Collectors.toList()));
                    }
                    query.getRescorerQueries().forEach(rescorerQuery -> bb.rescore(this.getRescore((RescorerQuery)rescorerQuery), new Rescore[0]));
                    if (!query.getRuntimeFields().isEmpty()) {
                        HashMap runtimeMappings = new HashMap();
                        query.getRuntimeFields().forEach(runtimeField -> {
                            RuntimeField esRuntimeField = RuntimeField.of(rt -> {
                                RuntimeField.Builder builder = rt.type((RuntimeFieldType)RuntimeFieldType._DESERIALIZER.parse(runtimeField.getType()));
                                String script = runtimeField.getScript();
                                if (script != null) {
                                    builder = builder.script(s -> s.inline(is -> is.source(script)));
                                }
                                return builder;
                            });
                            runtimeMappings.put(runtimeField.getName(), esRuntimeField);
                        });
                        bb.runtimeMappings(runtimeMappings);
                    }
                    if (!CollectionUtils.isEmpty(query.getIndicesBoost())) {
                        LinkedHashMap boosts = new LinkedHashMap();
                        query.getIndicesBoost().forEach(indexBoost -> boosts.put(indexBoost.getIndexName(), Double.valueOf(indexBoost.getBoost())));
                        bb.indicesBoost(boosts, new Map[0]);
                    }
                    if (query instanceof NativeQuery) {
                        this.prepareNativeSearch((NativeQuery)query, (MultisearchBody.Builder)bb);
                    }
                    return bb;
                }));
            });
            return mrb;
        });
    }

    private <T> void prepareSearchRequest(Query query, @Nullable Class<T> clazz, IndexCoordinates indexCoordinates, SearchRequest.Builder builder, boolean forCount, boolean useScroll) {
        List<SortOptions> sortOptions;
        Object[] indexNames = indexCoordinates.getIndexNames();
        Assert.notEmpty((Object[])indexNames, (String)"indexCoordinates does not contain entries");
        ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity(clazz);
        builder.version(Boolean.valueOf(true)).trackScores(Boolean.valueOf(query.getTrackScores()));
        Query.PointInTime pointInTime = query.getPointInTime();
        if (pointInTime != null) {
            builder.pit(pb -> pb.id(pointInTime.id()).keepAlive(TypeUtils.time(pointInTime.keepAlive())));
        } else {
            builder.index(Arrays.asList(indexNames));
            if (query.getRoute() != null) {
                builder.routing(query.getRoute());
            }
            if (query.getPreference() != null) {
                builder.preference(query.getPreference());
            }
        }
        if (persistentEntity != null && persistentEntity.hasSeqNoPrimaryTermProperty()) {
            builder.seqNoPrimaryTerm(Boolean.valueOf(true));
        }
        if (query.getPageable().isPaged()) {
            builder.from(Integer.valueOf((int)query.getPageable().getOffset())).size(Integer.valueOf(query.getPageable().getPageSize()));
        } else {
            builder.from(Integer.valueOf(0)).size(INDEX_MAX_RESULT_WINDOW);
        }
        builder.source(this.getSourceConfig(query));
        if (!CollectionUtils.isEmpty(query.getFields())) {
            builder.fields(fb -> {
                query.getFields().forEach(arg_0 -> ((FieldAndFormat.Builder)fb).field(arg_0));
                return fb;
            });
        }
        if (!CollectionUtils.isEmpty(query.getStoredFields())) {
            builder.storedFields(query.getStoredFields());
        }
        if (query.getIndicesOptions() != null) {
            // empty if block
        }
        if (query.isLimiting()) {
            builder.size(query.getMaxResults());
        }
        if (query.getMinScore() > 0.0f) {
            builder.minScore(Double.valueOf(query.getMinScore()));
        }
        builder.searchType(TypeUtils.searchType(query.getSearchType()));
        if (query.getSort() != null && !(sortOptions = this.getSortOptions(query.getSort(), persistentEntity)).isEmpty()) {
            builder.sort(sortOptions);
        }
        this.addHighlight(query, builder);
        if (query instanceof NativeQuery) {
            this.prepareNativeSearch((NativeQuery)query, builder);
        }
        if (query.getTrackTotalHits() != null) {
            int value = query.getTrackTotalHits() != false ? Integer.MAX_VALUE : -1;
            builder.trackTotalHits(th -> th.count(Integer.valueOf(value)));
        } else if (query.getTrackTotalHitsUpTo() != null) {
            builder.trackTotalHits(th -> th.count(query.getTrackTotalHitsUpTo()));
        }
        builder.timeout(TypeUtils.timeStringMs(query.getTimeout()));
        if (query.getExplain()) {
            builder.explain(Boolean.valueOf(true));
        }
        if (!CollectionUtils.isEmpty(query.getSearchAfter())) {
            builder.searchAfter(query.getSearchAfter().stream().map(it -> FieldValue.of((String)it.toString())).collect(Collectors.toList()));
        }
        query.getRescorerQueries().forEach(rescorerQuery -> builder.rescore(this.getRescore((RescorerQuery)rescorerQuery), new Rescore[0]));
        builder.requestCache(query.getRequestCache());
        if (!query.getRuntimeFields().isEmpty()) {
            HashMap runtimeMappings = new HashMap();
            query.getRuntimeFields().forEach(runtimeField -> runtimeMappings.put(runtimeField.getName(), RuntimeField.of(runtimeFieldBuilder -> {
                runtimeFieldBuilder.type((RuntimeFieldType)RuntimeFieldType._DESERIALIZER.parse(runtimeField.getType()));
                String script = runtimeField.getScript();
                if (script != null) {
                    runtimeFieldBuilder.script(s -> s.inline(is -> is.source(script)));
                }
                return runtimeFieldBuilder;
            })));
            builder.runtimeMappings(runtimeMappings);
        }
        if (forCount) {
            builder.size(Integer.valueOf(0)).trackTotalHits(th -> th.count(Integer.valueOf(Integer.MAX_VALUE))).source(SourceConfig.of(sc -> sc.fetch(Boolean.valueOf(false))));
        } else if (useScroll) {
            builder.requestCache(null);
            Duration scrollTimeout = query.getScrollTime() != null ? query.getScrollTime() : Duration.ofMinutes(1L);
            builder.scroll(TypeUtils.time(scrollTimeout));
            builder.size(Integer.valueOf(500));
        }
        if (!CollectionUtils.isEmpty(query.getIndicesBoost())) {
            LinkedHashMap boosts = new LinkedHashMap();
            query.getIndicesBoost().forEach(indexBoost -> boosts.put(indexBoost.getIndexName(), Double.valueOf(indexBoost.getBoost())));
            builder.indicesBoost(boosts, new Map[0]);
        }
    }

    private Rescore getRescore(RescorerQuery rescorerQuery) {
        return Rescore.of(r -> r.query(rq -> rq.query(this.getQuery(rescorerQuery.getQuery(), null)).scoreMode(TypeUtils.scoreMode(rescorerQuery.getScoreMode())).queryWeight(Double.valueOf(rescorerQuery.getQueryWeight() != null ? Double.valueOf(rescorerQuery.getQueryWeight().floatValue()) : 1.0)).rescoreQueryWeight(Double.valueOf(rescorerQuery.getRescoreQueryWeight() != null ? Double.valueOf(rescorerQuery.getRescoreQueryWeight().floatValue()) : 1.0))).windowSize(rescorerQuery.getWindowSize()));
    }

    private void addHighlight(Query query, SearchRequest.Builder builder) {
        Highlight highlight = query.getHighlightQuery().map(highlightQuery -> new HighlightQueryBuilder(this.elasticsearchConverter.getMappingContext()).getHighlight(highlightQuery.getHighlight(), highlightQuery.getType())).orElse(null);
        builder.highlight(highlight);
    }

    private void addHighlight(Query query, MultisearchBody.Builder builder) {
        Highlight highlight = query.getHighlightQuery().map(highlightQuery -> new HighlightQueryBuilder(this.elasticsearchConverter.getMappingContext()).getHighlight(highlightQuery.getHighlight(), highlightQuery.getType())).orElse(null);
        builder.highlight(highlight);
    }

    private List<SortOptions> getSortOptions(Sort sort, @Nullable ElasticsearchPersistentEntity<?> persistentEntity) {
        return sort.stream().map(order -> this.getSortOptions((Sort.Order)order, persistentEntity)).collect(Collectors.toList());
    }

    private SortOptions getSortOptions(Sort.Order order, @Nullable ElasticsearchPersistentEntity<?> persistentEntity) {
        SortOrder sortOrder = order.getDirection().isDescending() ? SortOrder.Desc : SortOrder.Asc;
        Order.Mode mode = Order.DEFAULT_MODE;
        String unmappedType = null;
        if (order instanceof Order) {
            Order o = (Order)order;
            mode = o.getMode();
            unmappedType = o.getUnmappedType();
        }
        if (SortOptions.Kind.Score.jsonValue().equals(order.getProperty())) {
            return SortOptions.of(so -> so.score(s -> s.order(sortOrder)));
        }
        ElasticsearchPersistentProperty property = persistentEntity != null ? (ElasticsearchPersistentProperty)persistentEntity.getPersistentProperty(order.getProperty()) : null;
        String fieldName = property != null ? property.getFieldName() : order.getProperty();
        Order.Mode finalMode = mode;
        if (order instanceof GeoDistanceOrder) {
            GeoDistanceOrder geoDistanceOrder = (GeoDistanceOrder)order;
            return SortOptions.of(so -> so.geoDistance(gd -> gd.field(fieldName).location(loc -> loc.latlon(QueryBuilders.latLon(geoDistanceOrder.getGeoPoint()))).distanceType(TypeUtils.geoDistanceType(geoDistanceOrder.getDistanceType())).mode(TypeUtils.sortMode(finalMode)).unit(TypeUtils.distanceUnit(geoDistanceOrder.getUnit())).ignoreUnmapped(geoDistanceOrder.getIgnoreUnmapped())));
        }
        String missing = order.getNullHandling() == Sort.NullHandling.NULLS_FIRST ? "_first" : (order.getNullHandling() == Sort.NullHandling.NULLS_LAST ? "_last" : null);
        String finalUnmappedType = unmappedType;
        return SortOptions.of(so -> so.field(f -> {
            FieldType fieldType;
            f.field(fieldName).order(sortOrder).mode(TypeUtils.sortMode(finalMode));
            if (finalUnmappedType != null && (fieldType = TypeUtils.fieldType(finalUnmappedType)) != null) {
                f.unmappedType(fieldType);
            }
            if (missing != null) {
                f.missing(fv -> fv.stringValue(missing));
            }
            return f;
        }));
    }

    private void prepareNativeSearch(NativeQuery query, SearchRequest.Builder builder) {
        query.getScriptedFields().forEach(scriptedField -> builder.scriptFields(scriptedField.getFieldName(), sf -> sf.script(this.getScript(scriptedField.getScriptData()))));
        builder.suggest(query.getSuggester()).collapse(query.getFieldCollapse()).sort(query.getSortOptions());
        if (!CollectionUtils.isEmpty(query.getAggregations())) {
            builder.aggregations(query.getAggregations());
        }
        if (!CollectionUtils.isEmpty(query.getSearchExtensions())) {
            builder.ext(query.getSearchExtensions());
        }
    }

    private void prepareNativeSearch(NativeQuery query, MultisearchBody.Builder builder) {
        query.getScriptedFields().forEach(scriptedField -> builder.scriptFields(scriptedField.getFieldName(), sf -> sf.script(this.getScript(scriptedField.getScriptData()))));
        builder.suggest(query.getSuggester()).collapse(query.getFieldCollapse()).sort(query.getSortOptions());
        if (!CollectionUtils.isEmpty(query.getAggregations())) {
            builder.aggregations(query.getAggregations());
        }
        if (!CollectionUtils.isEmpty(query.getSearchExtensions())) {
            builder.ext(query.getSearchExtensions());
        }
    }

    @Nullable
    private co.elastic.clients.elasticsearch._types.query_dsl.Query getQuery(@Nullable Query query, @Nullable Class<?> clazz) {
        if (query == null) {
            return null;
        }
        this.elasticsearchConverter.updateQuery(query, clazz);
        co.elastic.clients.elasticsearch._types.query_dsl.Query esQuery = null;
        if (query instanceof CriteriaQuery) {
            esQuery = CriteriaQueryProcessor.createQuery(((CriteriaQuery)query).getCriteria());
        } else if (query instanceof StringQuery) {
            esQuery = QueryBuilders.wrapperQueryAsQuery(((StringQuery)query).getSource());
        } else if (query instanceof NativeQuery) {
            NativeQuery nativeQuery = (NativeQuery)query;
            if (nativeQuery.getQuery() != null) {
                esQuery = nativeQuery.getQuery();
            }
        } else {
            throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
        }
        return esQuery;
    }

    private void addFilter(Query query, SearchRequest.Builder builder) {
        if (query instanceof CriteriaQuery) {
            CriteriaFilterProcessor.createQuery(((CriteriaQuery)query).getCriteria()).ifPresent(arg_0 -> ((SearchRequest.Builder)builder).postFilter(arg_0));
        } else if (!(query instanceof StringQuery)) {
            if (query instanceof NativeQuery) {
                builder.postFilter(((NativeQuery)query).getFilter());
            } else {
                throw new IllegalArgumentException("unhandled Query implementation " + query.getClass().getName());
            }
        }
    }

    public MoreLikeThisQuery moreLikeThisQuery(org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery query, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        MoreLikeThisQuery moreLikeThisQuery = MoreLikeThisQuery.of(q -> {
            q.like(Like.of(l -> l.document(ld -> ld.index(index.getIndexName()).id(query.getId()))), new Like[0]).fields(query.getFields());
            if (query.getMinTermFreq() != null) {
                q.minTermFreq(query.getMinTermFreq());
            }
            if (query.getMaxQueryTerms() != null) {
                q.maxQueryTerms(query.getMaxQueryTerms());
            }
            if (!CollectionUtils.isEmpty(query.getStopWords())) {
                q.stopWords(query.getStopWords());
            }
            if (query.getMinDocFreq() != null) {
                q.minDocFreq(query.getMinDocFreq());
            }
            if (query.getMaxDocFreq() != null) {
                q.maxDocFreq(query.getMaxDocFreq());
            }
            if (query.getMinWordLen() != null) {
                q.minWordLength(query.getMinWordLen());
            }
            if (query.getMaxWordLen() != null) {
                q.maxWordLength(query.getMaxWordLen());
            }
            if (query.getBoostTerms() != null) {
                q.boostTerms(Double.valueOf(query.getBoostTerms().floatValue()));
            }
            return q;
        });
        return moreLikeThisQuery;
    }

    public OpenPointInTimeRequest searchOpenPointInTimeRequest(IndexCoordinates index, Duration keepAlive, Boolean ignoreUnavailable) {
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notNull((Object)keepAlive, (String)"keepAlive must not be null");
        Assert.notNull((Object)ignoreUnavailable, (String)"ignoreUnavailable must not be null");
        return OpenPointInTimeRequest.of(opit -> opit.index(Arrays.asList(index.getIndexNames())).ignoreUnavailable(ignoreUnavailable).keepAlive(TypeUtils.time(keepAlive)));
    }

    public ClosePointInTimeRequest searchClosePointInTime(String pit) {
        Assert.notNull((Object)pit, (String)"pit must not be null");
        return ClosePointInTimeRequest.of(cpit -> cpit.id(pit));
    }

    public <T> T fromJson(String json, JsonpDeserializer<T> deserializer) {
        Assert.notNull((Object)json, (String)"json must not be null");
        Assert.notNull(deserializer, (String)"deserializer must not be null");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        return this.fromJson(byteArrayInputStream, deserializer);
    }

    public <T> T fromJson(ByteArrayInputStream byteArrayInputStream, JsonpDeserializer<T> deserializer) {
        Assert.notNull((Object)byteArrayInputStream, (String)"byteArrayInputStream must not be null");
        Assert.notNull(deserializer, (String)"deserializer must not be null");
        JsonParser parser = this.jsonpMapper.jsonProvider().createParser((InputStream)byteArrayInputStream);
        return (T)deserializer.deserialize(parser, this.jsonpMapper);
    }

    @Nullable
    private ElasticsearchPersistentEntity<?> getPersistentEntity(Object entity) {
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(entity.getClass());
    }

    @Nullable
    private ElasticsearchPersistentEntity<?> getPersistentEntity(@Nullable Class<?> clazz) {
        return clazz != null ? (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(clazz) : null;
    }

    @Nullable
    private String getPersistentEntityId(Object entity) {
        Object identifier;
        ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity(entity);
        if (persistentEntity != null && (identifier = persistentEntity.getIdentifierAccessor(entity).getIdentifier()) != null) {
            return identifier.toString();
        }
        return null;
    }

    private VersionType retrieveVersionTypeFromPersistentEntity(@Nullable Class<?> clazz) {
        Document.VersionType entityVersionType;
        ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity(clazz);
        VersionType versionType = null;
        if (persistentEntity != null && (entityVersionType = persistentEntity.getVersionType()) != null) {
            versionType = switch (entityVersionType) {
                default -> throw new IncompatibleClassChangeError();
                case Document.VersionType.INTERNAL -> VersionType.Internal;
                case Document.VersionType.EXTERNAL -> VersionType.External;
                case Document.VersionType.EXTERNAL_GTE -> VersionType.ExternalGte;
                case Document.VersionType.FORCE -> VersionType.Force;
            };
        }
        return versionType != null ? versionType : VersionType.External;
    }

    @Nullable
    private SourceConfig getSourceConfig(Query query) {
        if (query.getSourceFilter() != null) {
            return SourceConfig.of(s -> s.filter(sfb -> {
                SourceFilter sourceFilter = query.getSourceFilter();
                String[] includes = sourceFilter.getIncludes();
                String[] excludes = sourceFilter.getExcludes();
                if (includes != null) {
                    sfb.includes(Arrays.asList(includes));
                }
                if (excludes != null) {
                    sfb.excludes(Arrays.asList(excludes));
                }
                return sfb;
            }));
        }
        return null;
    }

    @Nullable
    static Boolean deleteByQueryRefresh(@Nullable RefreshPolicy refreshPolicy) {
        if (refreshPolicy == null) {
            return null;
        }
        return switch (refreshPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case RefreshPolicy.IMMEDIATE -> true;
            case RefreshPolicy.WAIT_UNTIL -> null;
            case RefreshPolicy.NONE -> false;
        };
    }
}

