/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.json.JsonpMapper;
import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class JsonUtils {
    private static final Log LOGGER = LogFactory.getLog(JsonUtils.class);

    private JsonUtils() {
    }

    public static String toJson(Object object, JsonpMapper mapper) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonGenerator generator = mapper.jsonProvider().createGenerator((OutputStream)baos);
        mapper.serialize(object, generator);
        generator.close();
        String jsonMapping = "{}";
        try {
            jsonMapping = baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn((Object)"could not read json", (Throwable)e);
        }
        return jsonMapping;
    }
}

