/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.data.elasticsearch.BulkFailureException;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.core.AbstractReactiveElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.AggregationContainer;
import org.springframework.data.elasticsearch.core.ElasticsearchAggregation;
import org.springframework.data.elasticsearch.core.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveIndexOperations;
import org.springframework.data.elasticsearch.core.ReactiveIndexTemplate;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.RequestFactory;
import org.springframework.data.elasticsearch.core.ResponseConverter;
import org.springframework.data.elasticsearch.core.SearchHitMapping;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.cluster.DefaultReactiveClusterOperations;
import org.springframework.data.elasticsearch.core.cluster.ReactiveClusterOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.DocumentAdapters;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponseBuilder;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.data.elasticsearch.core.reindex.ReindexResponse;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class ReactiveElasticsearchTemplate
extends AbstractReactiveElasticsearchTemplate {
    private final ReactiveElasticsearchClient client;
    private final ElasticsearchExceptionTranslator exceptionTranslator;
    protected RequestFactory requestFactory;
    @Nullable
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();

    public ReactiveElasticsearchTemplate(ReactiveElasticsearchClient client) {
        this(client, null);
    }

    public ReactiveElasticsearchTemplate(ReactiveElasticsearchClient client, @Nullable ElasticsearchConverter converter) {
        super(converter);
        Assert.notNull((Object)client, (String)"client must not be null");
        this.client = client;
        this.exceptionTranslator = new ElasticsearchExceptionTranslator();
        this.requestFactory = new RequestFactory(this.converter);
    }

    @Override
    protected ReactiveElasticsearchTemplate doCopy() {
        ReactiveElasticsearchTemplate copy = new ReactiveElasticsearchTemplate(this.client, this.converter);
        copy.setIndicesOptions(this.indicesOptions);
        return copy;
    }

    public void setIndicesOptions(@Nullable IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    @Override
    public <T> Flux<T> saveAll(Mono<? extends Collection<? extends T>> entitiesPublisher, IndexCoordinates index) {
        Assert.notNull(entitiesPublisher, (String)"entitiesPublisher must not be null!");
        return entitiesPublisher.flatMapMany(entities -> Flux.fromIterable((Iterable)entities).concatMap(entity -> this.maybeCallBeforeConvert(entity, index))).collectList().map(x$0 -> new AbstractReactiveElasticsearchTemplate.Entities(x$0)).flatMapMany(entities -> {
            if (entities.isEmpty()) {
                return Flux.empty();
            }
            return this.doBulkOperation(entities.indexQueries(), BulkOptions.defaultOptions(), index).index().flatMap(indexAndResponse -> {
                Object savedEntity = entities.entityAt((Long)indexAndResponse.getT1());
                BulkItemResponse bulkItemResponse = (BulkItemResponse)indexAndResponse.getT2();
                DocWriteResponse response = bulkItemResponse.getResponse();
                this.updateIndexedObject(savedEntity, IndexedObjectInformation.of(response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion()));
                return this.maybeCallAfterSave(savedEntity, index);
            });
        });
    }

    @Override
    public <T> Flux<MultiGetItem<T>> multiGet(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"Index must not be null");
        Assert.notNull(clazz, (String)"Class must not be null");
        Assert.notNull((Object)query, (String)"Query must not be null");
        AbstractReactiveElasticsearchTemplate.ReadDocumentCallback callback = new AbstractReactiveElasticsearchTemplate.ReadDocumentCallback(this.converter, clazz, index);
        MultiGetRequest request = this.requestFactory.multiGetRequest(query, clazz, index);
        return Flux.from(this.execute(client -> client.multiGet(request))).map(DocumentAdapters::from).flatMap(multiGetItem -> multiGetItem.isFailed() ? Mono.just(MultiGetItem.of(null, multiGetItem.getFailure())) : callback.toEntity((Document)multiGetItem.getItem()).map(item -> MultiGetItem.of(item, multiGetItem.getFailure())));
    }

    protected Mono<IndexResponse> doIndex(IndexRequest request) {
        return Mono.from(this.execute(client -> client.index(request)));
    }

    @Override
    public Mono<Void> bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of UpdateQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        Assert.notNull((Object)index, (String)"Index must not be null");
        return this.doBulkOperation(queries, bulkOptions, index).then();
    }

    protected Flux<BulkItemResponse> doBulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequest bulkRequest = this.prepareWriteRequest(this.requestFactory.bulkRequest(queries, bulkOptions, index));
        return this.client.bulk(bulkRequest).onErrorMap(e -> new UncategorizedElasticsearchException("Error while bulk for request: " + bulkRequest, (Throwable)e)).flatMap(this::checkForBulkOperationFailure).flatMapMany(response -> Flux.fromArray((Object[])response.getItems()));
    }

    protected Mono<BulkResponse> checkForBulkOperationFailure(BulkResponse bulkResponse) {
        if (bulkResponse.hasFailures()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), item.getFailureMessage());
            }
            BulkFailureException exception = new BulkFailureException("Bulk operation has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + ']', failedDocuments);
            return Mono.error((Throwable)((Object)exception));
        }
        return Mono.just((Object)bulkResponse);
    }

    @Override
    protected Mono<Boolean> doExists(String id, IndexCoordinates index) {
        return Mono.defer(() -> this.doExists(this.requestFactory.getRequest(id, this.routingResolver.getRouting(), index)));
    }

    protected Mono<Boolean> doExists(GetRequest request) {
        return Mono.from(this.execute(client -> client.exists(request))).onErrorReturn(NoSuchIndexException.class, (Object)false);
    }

    @Override
    protected <T> Mono<Tuple2<T, AbstractReactiveElasticsearchTemplate.IndexResponseMetaData>> doIndex(T entity, IndexCoordinates index) {
        IndexRequest request = this.requestFactory.indexRequest(this.getIndexQuery(entity), index);
        request = this.prepareIndexRequest(entity, request);
        return Mono.just(entity).zipWith(this.doIndex(request).map(indexResponse -> new AbstractReactiveElasticsearchTemplate.IndexResponseMetaData(indexResponse.getId(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion())));
    }

    @Override
    public <T> Mono<T> get(String id, Class<T> entityType, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        GetRequest request = this.requestFactory.getRequest(id, this.routingResolver.getRouting(), index);
        Mono<GetResult> getResult = this.doGet(request);
        AbstractReactiveElasticsearchTemplate.ReadDocumentCallback callback = new AbstractReactiveElasticsearchTemplate.ReadDocumentCallback(this.converter, entityType, index);
        return getResult.flatMap(response -> callback.toEntity(DocumentAdapters.from(response)));
    }

    protected Mono<GetResult> doGet(GetRequest request) {
        return Mono.from(this.execute(client -> client.get(request)));
    }

    @Override
    protected Mono<String> doDeleteById(String id, @Nullable String routing, IndexCoordinates index) {
        return Mono.defer(() -> {
            DeleteRequest request = this.requestFactory.deleteRequest(id, routing, index);
            return this.doDelete(this.prepareDeleteRequest(request));
        });
    }

    @Override
    public Mono<ByQueryResponse> delete(Query query, Class<?> entityType, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        return this.doDeleteBy(query, entityType, index).map(ResponseConverter::byQueryResponseOf);
    }

    @Override
    public Mono<UpdateResponse> update(UpdateQuery updateQuery, IndexCoordinates index) {
        Assert.notNull((Object)updateQuery, (String)"UpdateQuery must not be null");
        Assert.notNull((Object)index, (String)"Index must not be null");
        return Mono.defer(() -> {
            UpdateRequest request = this.requestFactory.updateRequest(updateQuery, index);
            if (updateQuery.getRefreshPolicy() == null && this.refreshPolicy != null) {
                request.setRefreshPolicy(RequestFactory.toElasticsearchRefreshPolicy(this.refreshPolicy));
            }
            if (updateQuery.getRouting() == null && this.routingResolver.getRouting() != null) {
                request.routing(this.routingResolver.getRouting());
            }
            return Mono.from(this.execute(client -> client.update(request))).map(response -> new UpdateResponse(UpdateResponse.Result.valueOf(response.getResult().name())));
        });
    }

    @Override
    public Mono<ByQueryResponse> updateByQuery(UpdateQuery updateQuery, IndexCoordinates index) {
        Assert.notNull((Object)updateQuery, (String)"updateQuery must not be null");
        Assert.notNull((Object)index, (String)"Index must not be null");
        return Mono.defer(() -> {
            UpdateByQueryRequest request = this.requestFactory.updateByQueryRequest(updateQuery, index);
            if (updateQuery.getRefreshPolicy() == null && this.refreshPolicy != null) {
                request.setRefresh(this.refreshPolicy == RefreshPolicy.IMMEDIATE);
            }
            if (updateQuery.getRouting() == null && this.routingResolver.getRouting() != null) {
                request.setRouting(this.routingResolver.getRouting());
            }
            return Mono.from(this.execute(client -> client.updateBy(request)));
        });
    }

    @Override
    public Mono<ReindexResponse> reindex(ReindexRequest postReindexRequest) {
        Assert.notNull((Object)postReindexRequest, (String)"postReindexRequest must not be null");
        return Mono.defer(() -> {
            org.elasticsearch.index.reindex.ReindexRequest reindexRequest = this.requestFactory.reindexRequest(postReindexRequest);
            return Mono.from(this.execute(client -> client.reindex(reindexRequest))).map(ResponseConverter::reindexResponseOf);
        });
    }

    @Override
    public Mono<String> submitReindex(ReindexRequest postReindexRequest) {
        Assert.notNull((Object)postReindexRequest, (String)"postReindexRequest must not be null");
        return Mono.defer(() -> {
            org.elasticsearch.index.reindex.ReindexRequest reindexRequest = this.requestFactory.reindexRequest(postReindexRequest);
            return Mono.from(this.execute(client -> client.submitReindex(reindexRequest)));
        });
    }

    protected Mono<BulkByScrollResponse> doDeleteBy(Query query, Class<?> entityType, IndexCoordinates index) {
        return Mono.defer(() -> {
            DeleteByQueryRequest request = this.requestFactory.deleteByQueryRequest(query, entityType, index);
            return this.doDeleteBy(this.prepareDeleteByRequest(request));
        });
    }

    protected Mono<String> doDelete(DeleteRequest request) {
        return Mono.from(this.execute(client -> client.delete(request))).flatMap(it -> {
            if (HttpStatus.valueOf((int)it.status().getStatus()).equals((Object)HttpStatus.NOT_FOUND)) {
                return Mono.empty();
            }
            return Mono.just((Object)it.getId());
        }).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected Mono<BulkByScrollResponse> doDeleteBy(DeleteByQueryRequest request) {
        return Mono.from(this.execute(client -> client.deleteBy(request))).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected DeleteRequest prepareDeleteRequest(DeleteRequest request) {
        return this.prepareWriteRequest(request);
    }

    protected DeleteByQueryRequest prepareDeleteByRequest(DeleteByQueryRequest request) {
        if (this.refreshPolicy != null) {
            request = RefreshPolicy.NONE.equals((Object)this.refreshPolicy) ? (DeleteByQueryRequest)request.setRefresh(false) : (DeleteByQueryRequest)request.setRefresh(true);
        }
        if (this.indicesOptions != null) {
            request = request.setIndicesOptions(this.indicesOptions);
        }
        return request;
    }

    protected IndexRequest prepareIndexRequest(Object source, IndexRequest request) {
        return this.prepareWriteRequest(request);
    }

    protected <R extends WriteRequest<R>> R prepareWriteRequest(R request) {
        if (this.refreshPolicy == null) {
            return request;
        }
        return (R)request.setRefreshPolicy(RequestFactory.toElasticsearchRefreshPolicy(this.refreshPolicy));
    }

    @Override
    public <T> Mono<SearchPage<T>> searchForPage(Query query, Class<?> entityType, Class<T> resultType) {
        return this.searchForPage(query, entityType, resultType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public <T> Mono<SearchPage<T>> searchForPage(Query query, Class<?> entityType, Class<T> resultType, IndexCoordinates index) {
        AbstractReactiveElasticsearchTemplate.ReadSearchDocumentCallback callback = new AbstractReactiveElasticsearchTemplate.ReadSearchDocumentCallback(resultType, index);
        return this.doFindForResponse(query, entityType, index).flatMap(searchDocumentResponse -> Flux.fromIterable(searchDocumentResponse.getSearchDocuments()).flatMap(callback::toEntity).collectList().map(entities -> SearchHitMapping.mappingFor(resultType, this.converter).mapHits((SearchDocumentResponse)searchDocumentResponse, entities))).map(searchHits -> SearchHitSupport.searchPageFor(searchHits, query.getPageable()));
    }

    @Override
    protected Flux<SearchDocument> doFind(Query query, Class<?> clazz, IndexCoordinates index) {
        return Flux.defer(() -> {
            SearchRequest request = this.requestFactory.searchRequest(query, clazz, index);
            boolean useScroll = !query.getPageable().isPaged() && !query.isLimiting();
            request = this.prepareSearchRequest(request, useScroll);
            if (useScroll) {
                return this.doScroll(request);
            }
            return this.doFind(request);
        });
    }

    @Override
    protected <T> Mono<SearchDocumentResponse> doFindForResponse(Query query, Class<?> clazz, IndexCoordinates index) {
        return Mono.defer(() -> {
            SearchRequest request = this.requestFactory.searchRequest(query, clazz, index);
            request = this.prepareSearchRequest(request, false);
            AbstractReactiveElasticsearchTemplate.ReadSearchDocumentCallback documentCallback = new AbstractReactiveElasticsearchTemplate.ReadSearchDocumentCallback(clazz, index);
            SearchDocumentResponse.EntityCreator entityCreator = searchDocument -> documentCallback.toEntity((SearchDocument)searchDocument).toFuture();
            return this.doFindForResponse(request, entityCreator);
        });
    }

    public Flux<AggregationContainer<?>> aggregate(Query query, Class<?> entityType, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(entityType, (String)"entityType must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return Flux.defer(() -> {
            SearchRequest request = this.requestFactory.searchRequest(query, entityType, index);
            request = this.prepareSearchRequest(request, false);
            return this.doAggregate(request);
        });
    }

    protected Flux<AggregationContainer<?>> doAggregate(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug(String.format("Executing doCount: %s", request));
        }
        return Flux.from(this.execute(client -> client.aggregate(request))).onErrorResume(NoSuchIndexException.class, it -> Flux.empty()).map(ElasticsearchAggregation::new);
    }

    @Override
    @Deprecated
    public Flux<Suggest> suggest(SuggestBuilder suggestion, Class<?> entityType) {
        return this.doSuggest(suggestion, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    @Deprecated
    public Flux<Suggest> suggest(SuggestBuilder suggestion, IndexCoordinates index) {
        return this.doSuggest(suggestion, index);
    }

    @Deprecated
    private Flux<Suggest> doSuggest(SuggestBuilder suggestion, IndexCoordinates index) {
        return Flux.defer(() -> {
            SearchRequest request = this.requestFactory.searchRequest(suggestion, index);
            return Flux.from(this.execute(client -> client.suggest(request)));
        });
    }

    @Override
    protected Mono<Long> doCount(Query query, Class<?> entityType, IndexCoordinates index) {
        return Mono.defer(() -> {
            SearchRequest request = this.requestFactory.searchRequest(query, entityType, index);
            request = this.prepareSearchRequest(request, false);
            return this.doCount(request);
        });
    }

    protected Flux<SearchDocument> doFind(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug(String.format("Executing doFind: %s", request));
        }
        return Flux.from(this.execute(client -> client.search(request))).map(DocumentAdapters::from).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected <T> Mono<SearchDocumentResponse> doFindForResponse(SearchRequest request, SearchDocumentResponse.EntityCreator<T> entityCreator) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug(String.format("Executing doFindForResponse: %s", request));
        }
        return Mono.from(this.execute(client -> client.searchForResponse(request))).map(searchResponse -> SearchDocumentResponseBuilder.from(searchResponse, entityCreator));
    }

    protected Mono<Long> doCount(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug(String.format("Executing doCount: %s", request));
        }
        return Mono.from(this.execute(client -> client.count(request)));
    }

    protected Flux<SearchDocument> doScroll(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug(String.format("Executing doScroll: %s", request));
        }
        return Flux.from(this.execute(client -> client.scroll(request))).map(DocumentAdapters::from).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected SearchRequest prepareSearchRequest(SearchRequest request, boolean useScroll) {
        if (this.indicesOptions != null) {
            request = request.indicesOptions(this.indicesOptions);
        }
        if (useScroll) {
            request = request.requestCache(null);
        }
        return request;
    }

    @Override
    protected Mono<String> getClusterVersion() {
        try {
            return Mono.from(this.execute(ReactiveElasticsearchClient::info)).map(mainResponse -> mainResponse.getVersion().toString());
        }
        catch (Exception exception) {
            return Mono.empty();
        }
    }

    @Override
    protected Mono<String> getVendor() {
        return Mono.just((Object)"Elasticsearch");
    }

    @Override
    protected Mono<String> getRuntimeLibraryVersion() {
        return Mono.just((Object)Version.CURRENT.toString());
    }

    @Override
    public Query matchAllQuery() {
        return new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
    }

    @Override
    public Query idsQuery(List<String> ids) {
        Assert.notNull(ids, (String)"ids must not be null");
        return new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(ids.toArray(new String[0]))).build();
    }

    @Override
    public <T> Publisher<T> execute(ReactiveElasticsearchOperations.ClientCallback<Publisher<T>> callback) {
        return Flux.defer(() -> callback.doWithClient(this.getClient())).onErrorMap(this::translateException);
    }

    @Override
    public <T> Publisher<T> executeWithIndicesClient(ReactiveElasticsearchOperations.IndicesClientCallback<Publisher<T>> callback) {
        return Flux.defer(() -> callback.doWithClient(this.getIndicesClient())).onErrorMap(this::translateException);
    }

    @Override
    public <T> Publisher<T> executeWithClusterClient(ReactiveElasticsearchOperations.ClusterClientCallback<Publisher<T>> callback) {
        return Flux.defer(() -> callback.doWithClient(this.getClusterClient())).onErrorMap(this::translateException);
    }

    @Override
    public ReactiveIndexOperations indexOps(IndexCoordinates index) {
        return new ReactiveIndexTemplate((ReactiveElasticsearchOperations)this, index);
    }

    @Override
    public ReactiveIndexOperations indexOps(Class<?> clazz) {
        return new ReactiveIndexTemplate((ReactiveElasticsearchOperations)this, clazz);
    }

    @Override
    public ReactiveClusterOperations cluster() {
        return new DefaultReactiveClusterOperations(this);
    }

    protected ReactiveElasticsearchClient getClient() {
        return this.client;
    }

    protected ReactiveElasticsearchClient.Indices getIndicesClient() {
        if (this.client instanceof ReactiveElasticsearchClient.Indices) {
            return (ReactiveElasticsearchClient.Indices)((Object)this.client);
        }
        throw new UncategorizedElasticsearchException("No ReactiveElasticsearchClient.Indices implementation available");
    }

    protected ReactiveElasticsearchClient.Cluster getClusterClient() {
        if (this.client instanceof ReactiveElasticsearchClient.Cluster) {
            return (ReactiveElasticsearchClient.Cluster)((Object)this.client);
        }
        throw new UncategorizedElasticsearchException("No ReactiveElasticsearchClient.Cluster implementation available");
    }

    private RuntimeException translateException(Throwable throwable) {
        RuntimeException runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable.getMessage(), throwable);
        DataAccessException potentiallyTranslatedException = this.exceptionTranslator.translateExceptionIfPossible(runtimeException);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : runtimeException;
    }
}

