/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.mustache.SearchTemplateRequestBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class NativeSearchQueryBuilder {
    @Nullable
    private QueryBuilder queryBuilder;
    @Nullable
    private QueryBuilder filterBuilder;
    private final List<ScriptField> scriptFields = new ArrayList<ScriptField>();
    private final List<SortBuilder<?>> sortBuilders = new ArrayList();
    private final List<AbstractAggregationBuilder<?>> aggregationBuilders = new ArrayList();
    private final List<PipelineAggregationBuilder> pipelineAggregationBuilders = new ArrayList<PipelineAggregationBuilder>();
    @Nullable
    private HighlightBuilder highlightBuilder;
    @Nullable
    private List<HighlightBuilder.Field> highlightFields = new ArrayList<HighlightBuilder.Field>();
    private Pageable pageable = Pageable.unpaged();
    @Nullable
    private List<String> fields = new ArrayList<String>();
    @Nullable
    private SourceFilter sourceFilter;
    @Nullable
    private CollapseBuilder collapseBuilder;
    @Nullable
    private List<IndexBoost> indicesBoost = new ArrayList<IndexBoost>();
    @Nullable
    private SearchTemplateRequestBuilder searchTemplateBuilder;
    private float minScore;
    private boolean trackScores;
    @Nullable
    private List<String> ids = new ArrayList<String>();
    @Nullable
    private String route;
    @Nullable
    private SearchType searchType;
    @Nullable
    private IndicesOptions indicesOptions;
    @Nullable
    private String preference;
    @Nullable
    private Integer maxResults;
    @Nullable
    private Boolean trackTotalHits;
    @Nullable
    private Duration timeout;
    private final List<RescorerQuery> rescorerQueries = new ArrayList<RescorerQuery>();
    @Nullable
    private SuggestBuilder suggestBuilder;

    public NativeSearchQueryBuilder withQuery(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withFilter(QueryBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    @Deprecated
    public NativeSearchQueryBuilder withSort(SortBuilder<?> sortBuilder) {
        this.sortBuilders.add(sortBuilder);
        return this;
    }

    public NativeSearchQueryBuilder withSorts(Collection<SortBuilder<?>> sortBuilders) {
        this.sortBuilders.addAll(sortBuilders);
        return this;
    }

    public NativeSearchQueryBuilder withSorts(SortBuilder<?> ... sortBuilders) {
        Collections.addAll(this.sortBuilders, sortBuilders);
        return this;
    }

    public NativeSearchQueryBuilder withScriptField(ScriptField scriptField) {
        this.scriptFields.add(scriptField);
        return this;
    }

    public NativeSearchQueryBuilder withCollapseField(String collapseField) {
        this.collapseBuilder = new CollapseBuilder(collapseField);
        return this;
    }

    public NativeSearchQueryBuilder withCollapseBuilder(@Nullable CollapseBuilder collapseBuilder) {
        this.collapseBuilder = collapseBuilder;
        return this;
    }

    @Deprecated
    public NativeSearchQueryBuilder addAggregation(AbstractAggregationBuilder<?> aggregationBuilder) {
        this.aggregationBuilders.add(aggregationBuilder);
        return this;
    }

    public NativeSearchQueryBuilder withAggregations(Collection<AbstractAggregationBuilder<?>> aggregationBuilders) {
        this.aggregationBuilders.addAll(aggregationBuilders);
        return this;
    }

    public NativeSearchQueryBuilder withAggregations(AbstractAggregationBuilder<?> ... aggregationBuilders) {
        Collections.addAll(this.aggregationBuilders, aggregationBuilders);
        return this;
    }

    @Deprecated
    public NativeSearchQueryBuilder addAggregation(PipelineAggregationBuilder pipelineAggregationBuilder) {
        this.pipelineAggregationBuilders.add(pipelineAggregationBuilder);
        return this;
    }

    public NativeSearchQueryBuilder withPipelineAggregations(Collection<PipelineAggregationBuilder> pipelineAggregationBuilders) {
        this.pipelineAggregationBuilders.addAll(pipelineAggregationBuilders);
        return this;
    }

    public NativeSearchQueryBuilder withPipelineAggregations(PipelineAggregationBuilder ... pipelineAggregationBuilders) {
        Collections.addAll(this.pipelineAggregationBuilders, pipelineAggregationBuilders);
        return this;
    }

    public NativeSearchQueryBuilder withHighlightBuilder(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withHighlightFields(HighlightBuilder.Field ... highlightFields) {
        Collections.addAll(this.highlightFields, highlightFields);
        return this;
    }

    public NativeSearchQueryBuilder withHighlightFields(Collection<HighlightBuilder.Field> highlightFields) {
        this.highlightFields.addAll(highlightFields);
        return this;
    }

    public NativeSearchQueryBuilder withIndicesBoost(Collection<IndexBoost> indicesBoost) {
        this.indicesBoost.addAll(indicesBoost);
        return this;
    }

    public NativeSearchQueryBuilder withIndicesBoost(IndexBoost ... indicesBoost) {
        Collections.addAll(this.indicesBoost, indicesBoost);
        return this;
    }

    public NativeSearchQueryBuilder withSearchTemplate(SearchTemplateRequestBuilder searchTemplateBuilder) {
        this.searchTemplateBuilder = searchTemplateBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withPageable(Pageable pageable) {
        this.pageable = pageable;
        return this;
    }

    public NativeSearchQueryBuilder withFields(Collection<String> fields) {
        this.fields.addAll(fields);
        return this;
    }

    public NativeSearchQueryBuilder withFields(String ... fields) {
        Collections.addAll(this.fields, fields);
        return this;
    }

    public NativeSearchQueryBuilder withSourceFilter(SourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
        return this;
    }

    public NativeSearchQueryBuilder withMinScore(float minScore) {
        this.minScore = minScore;
        return this;
    }

    public NativeSearchQueryBuilder withTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public NativeSearchQueryBuilder withIds(Collection<String> ids) {
        this.ids.addAll(ids);
        return this;
    }

    public NativeSearchQueryBuilder withIds(String ... ids) {
        Collections.addAll(this.ids, ids);
        return this;
    }

    public NativeSearchQueryBuilder withRoute(String route) {
        this.route = route;
        return this;
    }

    public NativeSearchQueryBuilder withSearchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public NativeSearchQueryBuilder withIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public NativeSearchQueryBuilder withPreference(String preference) {
        this.preference = preference;
        return this;
    }

    public NativeSearchQueryBuilder withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public NativeSearchQueryBuilder withTrackTotalHits(Boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
        return this;
    }

    public NativeSearchQueryBuilder withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public NativeSearchQueryBuilder withRescorerQuery(RescorerQuery rescorerQuery) {
        this.rescorerQueries.add(rescorerQuery);
        return this;
    }

    public NativeSearchQueryBuilder withSuggestBuilder(SuggestBuilder suggestBuilder) {
        this.suggestBuilder = suggestBuilder;
        return this;
    }

    public NativeSearchQuery build() {
        NativeSearchQuery nativeSearchQuery = new NativeSearchQuery(this.queryBuilder, this.filterBuilder, this.sortBuilders, this.highlightBuilder, this.highlightFields.toArray(new HighlightBuilder.Field[this.highlightFields.size()]));
        nativeSearchQuery.setPageable(this.pageable);
        nativeSearchQuery.setTrackScores(this.trackScores);
        if (this.fields != null) {
            nativeSearchQuery.setFields(this.fields);
        }
        if (this.sourceFilter != null) {
            nativeSearchQuery.addSourceFilter(this.sourceFilter);
        }
        if (this.indicesBoost != null) {
            nativeSearchQuery.setIndicesBoost(this.indicesBoost);
        }
        if (this.searchTemplateBuilder != null) {
            nativeSearchQuery.setSearchTemplate(this.searchTemplateBuilder);
        }
        if (!CollectionUtils.isEmpty(this.scriptFields)) {
            nativeSearchQuery.setScriptFields(this.scriptFields);
        }
        if (this.collapseBuilder != null) {
            nativeSearchQuery.setCollapseBuilder(this.collapseBuilder);
        }
        if (!CollectionUtils.isEmpty(this.aggregationBuilders)) {
            nativeSearchQuery.setAggregations(this.aggregationBuilders);
        }
        if (!CollectionUtils.isEmpty(this.pipelineAggregationBuilders)) {
            nativeSearchQuery.setPipelineAggregations(this.pipelineAggregationBuilders);
        }
        if (this.minScore > 0.0f) {
            nativeSearchQuery.setMinScore(this.minScore);
        }
        if (this.ids != null) {
            nativeSearchQuery.setIds(this.ids);
        }
        if (this.route != null) {
            nativeSearchQuery.setRoute(this.route);
        }
        if (this.searchType != null) {
            nativeSearchQuery.setSearchType(Query.SearchType.valueOf(this.searchType.name()));
        }
        if (this.indicesOptions != null) {
            nativeSearchQuery.setIndicesOptions(this.indicesOptions);
        }
        if (this.preference != null) {
            nativeSearchQuery.setPreference(this.preference);
        }
        if (this.maxResults != null) {
            nativeSearchQuery.setMaxResults(this.maxResults);
        }
        nativeSearchQuery.setTrackTotalHits(this.trackTotalHits);
        if (this.timeout != null) {
            nativeSearchQuery.setTimeout(this.timeout);
        }
        if (!CollectionUtils.isEmpty(this.rescorerQueries)) {
            nativeSearchQuery.setRescorerQueries(this.rescorerQueries);
        }
        if (this.suggestBuilder != null) {
            nativeSearchQuery.setSuggestBuilder(this.suggestBuilder);
        }
        return nativeSearchQuery;
    }
}

