/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.support.StringQueryUtil;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;

public class ElasticsearchStringQuery
extends AbstractElasticsearchRepositoryQuery {
    private String query;

    public ElasticsearchStringQuery(ElasticsearchQueryMethod queryMethod, ElasticsearchOperations elasticsearchOperations, String query) {
        super(queryMethod, elasticsearchOperations);
        Assert.notNull((Object)query, (String)"Query cannot be empty");
        this.query = query;
    }

    public Object execute(Object[] parameters) {
        Class clazz = this.queryMethod.getResultProcessor().getReturnedType().getDomainType();
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        StringQuery stringQuery = this.createQuery(accessor);
        Assert.notNull((Object)stringQuery, (String)"unsupported query");
        if (this.queryMethod.hasAnnotatedHighlight()) {
            stringQuery.setHighlightQuery(this.queryMethod.getAnnotatedHighlightQuery());
        }
        IndexCoordinates index = this.elasticsearchOperations.getIndexCoordinatesFor(clazz);
        Object result = null;
        if (this.queryMethod.isPageQuery()) {
            stringQuery.setPageable(accessor.getPageable());
            SearchHits searchHits = this.elasticsearchOperations.search(stringQuery, clazz, index);
            result = this.queryMethod.isSearchPageMethod() ? SearchHitSupport.searchPageFor(searchHits, stringQuery.getPageable()) : SearchHitSupport.unwrapSearchHits(SearchHitSupport.searchPageFor(searchHits, stringQuery.getPageable()));
        } else if (this.queryMethod.isStreamQuery()) {
            if (accessor.getPageable().isUnpaged()) {
                stringQuery.setPageable((Pageable)PageRequest.of((int)0, (int)500));
            } else {
                stringQuery.setPageable(accessor.getPageable());
            }
            result = StreamUtils.createStreamFromIterator(this.elasticsearchOperations.searchForStream(stringQuery, clazz, index));
        } else if (this.queryMethod.isCollectionQuery()) {
            if (accessor.getPageable().isPaged()) {
                stringQuery.setPageable(accessor.getPageable());
            }
            result = this.elasticsearchOperations.search(stringQuery, clazz, index);
        } else {
            result = this.elasticsearchOperations.searchOne(stringQuery, clazz, index);
        }
        return this.queryMethod.isNotSearchHitMethod() && !this.queryMethod.isSearchPageMethod() ? SearchHitSupport.unwrapSearchHits(result) : result;
    }

    protected StringQuery createQuery(ParametersParameterAccessor parameterAccessor) {
        String queryString = new StringQueryUtil(this.elasticsearchOperations.getElasticsearchConverter().getConversionService()).replacePlaceholders(this.query, (ParameterAccessor)parameterAccessor);
        return new StringQuery(queryString);
    }
}

