/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.geo.Point;
import org.springframework.util.NumberUtils;

class GeoConverters {
    GeoConverters() {
    }

    static Collection<Converter<?, ?>> getConvertersToRegister() {
        return Arrays.asList(new Converter[]{PointToMapConverter.INSTANCE, MapToPointConverter.INSTANCE, GeoPointToMapConverter.INSTANCE, MapToGeoPointConverter.INSTANCE});
    }

    @ReadingConverter
    static enum MapToGeoPointConverter implements Converter<Map<String, Object>, GeoPoint>
    {
        INSTANCE;


        public GeoPoint convert(Map<String, Object> source) {
            Double x = (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)source.get("lat")), Double.class);
            Double y = (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)source.get("lon")), Double.class);
            return new GeoPoint(x, y);
        }
    }

    @ReadingConverter
    static enum MapToPointConverter implements Converter<Map<String, Object>, Point>
    {
        INSTANCE;


        public Point convert(Map<String, Object> source) {
            Double x = (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)source.get("lat")), Double.class);
            Double y = (Double)NumberUtils.convertNumberToTargetClass((Number)((Number)source.get("lon")), Double.class);
            return new Point(x.doubleValue(), y.doubleValue());
        }
    }

    @WritingConverter
    static enum GeoPointToMapConverter implements Converter<GeoPoint, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(GeoPoint source) {
            LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
            target.put("lat", source.getLat());
            target.put("lon", source.getLon());
            return target;
        }
    }

    @WritingConverter
    static enum PointToMapConverter implements Converter<Point, Map<String, Object>>
    {
        INSTANCE;


        public Map<String, Object> convert(Point source) {
            LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
            target.put("lat", source.getX());
            target.put("lon", source.getY());
            return target;
        }
    }
}

