/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.SimpleElasticsearchRepository;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractElasticsearchRepository<T, ID>
implements ElasticsearchRepository<T, ID> {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractElasticsearchRepository.class);
    protected ElasticsearchOperations operations;
    protected IndexOperations indexOperations;
    protected Class<T> entityClass;
    @Nullable
    protected ElasticsearchEntityInformation<T, ID> entityInformation;

    public AbstractElasticsearchRepository(ElasticsearchEntityInformation<T, ID> metadata, ElasticsearchOperations operations) {
        this.operations = operations;
        Assert.notNull(metadata, (String)"ElasticsearchEntityInformation must not be null!");
        this.entityInformation = metadata;
        this.entityClass = this.entityInformation.getJavaType();
        this.indexOperations = operations.indexOps(this.entityClass);
        try {
            if (this.createIndexAndMapping() && !this.indexOperations.exists()) {
                this.createIndex();
                this.putMapping();
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Cannot create index: {}", (Object)exception.getMessage());
        }
    }

    private void createIndex() {
        this.indexOperations.create();
    }

    private void putMapping() {
        this.indexOperations.putMapping(this.indexOperations.createMapping(this.entityClass));
    }

    private boolean createIndexAndMapping() {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.operations.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(this.getEntityClass());
        return entity.isCreateIndexAndMapping();
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.operations.get(this.stringIdRepresentation(id), this.getEntityClass(), this.getIndexCoordinates()));
    }

    public Iterable<T> findAll() {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        return this.findAll((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
    }

    public Page<T> findAll(Pageable pageable) {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withPageable(pageable).build();
        SearchHits<T> searchHits = this.operations.search(query, this.getEntityClass(), this.getIndexCoordinates());
        AggregatedPage<SearchHit<T>> page = SearchHitSupport.page(searchHits, query.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    public Iterable<T> findAll(Sort sort) {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withPageable((Pageable)PageRequest.of((int)0, (int)itemCount, (Sort)sort)).build();
        List<SearchHit<T>> searchHitList = this.operations.search(query, this.getEntityClass(), this.getIndexCoordinates()).getSearchHits();
        return (List)SearchHitSupport.unwrapSearchHits(searchHitList);
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        NativeSearchQuery query = new NativeSearchQueryBuilder().withIds(this.stringIdsRepresentation(ids)).build();
        ArrayList result = new ArrayList();
        List<Object> multiGetEntities = this.operations.multiGet(query, this.getEntityClass(), this.getIndexCoordinates());
        multiGetEntities.forEach(entity -> {
            if (entity != null) {
                result.add(entity);
            }
        });
        return result;
    }

    public long count() {
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
        return this.operations.count(query, this.getEntityClass(), this.getIndexCoordinates());
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        this.operations.save(entity, this.getIndexCoordinates());
        this.operations.indexOps(entity.getClass()).refresh();
        return entity;
    }

    public <S extends T> List<S> save(List<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        return Streamable.of(this.saveAll(entities)).stream().collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public <S extends T> S indexWithoutRefresh(S entity) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        this.operations.save(entity);
        return entity;
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        this.operations.save(entities, indexCoordinates);
        this.operations.indexOps(indexCoordinates).refresh();
        return entities;
    }

    public boolean existsById(ID id) {
        return this.operations.exists(this.stringIdRepresentation(id), this.getIndexCoordinates());
    }

    @Override
    public Iterable<T> search(QueryBuilder query) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(query).build();
        int count = (int)this.operations.count(searchQuery, this.getEntityClass(), this.getIndexCoordinates());
        if (count == 0) {
            return new PageImpl(Collections.emptyList());
        }
        searchQuery.setPageable((Pageable)PageRequest.of((int)0, (int)count));
        SearchHits<T> searchHits = this.operations.search(searchQuery, this.getEntityClass(), this.getIndexCoordinates());
        AggregatedPage<SearchHit<T>> page = SearchHitSupport.page(searchHits, searchQuery.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    @Override
    public Page<T> search(QueryBuilder query, Pageable pageable) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(query).withPageable(pageable).build();
        SearchHits<T> searchHits = this.operations.search(searchQuery, this.getEntityClass(), this.getIndexCoordinates());
        AggregatedPage<SearchHit<T>> page = SearchHitSupport.page(searchHits, searchQuery.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    @Override
    public Page<T> search(Query query) {
        SearchHits<T> searchHits = this.operations.search(query, this.getEntityClass(), this.getIndexCoordinates());
        AggregatedPage<SearchHit<T>> page = SearchHitSupport.page(searchHits, query.getPageable());
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    @Override
    public Page<T> searchSimilar(T entity, @Nullable String[] fields, Pageable pageable) {
        Assert.notNull(entity, (String)"Cannot search similar records for 'null'.");
        Assert.notNull((Object)pageable, (String)"'pageable' cannot be 'null'");
        MoreLikeThisQuery query = new MoreLikeThisQuery();
        query.setId(this.stringIdRepresentation(this.extractIdFromBean(entity)));
        query.setPageable(pageable);
        if (fields != null) {
            query.addFields(fields);
        }
        SearchHits<T> searchHits = this.operations.search(query, this.getEntityClass(), this.getIndexCoordinates());
        AggregatedPage<SearchHit<T>> page = SearchHitSupport.page(searchHits, pageable);
        return (Page)SearchHitSupport.unwrapSearchHits(page);
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"Cannot delete entity with id 'null'.");
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        this.doDelete(id, indexCoordinates);
        this.indexOperations.refresh();
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Cannot delete 'null' entity.");
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        this.doDelete(this.extractIdFromBean(entity), indexCoordinates);
        this.indexOperations.refresh();
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Cannot delete 'null' list.");
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        IdsQueryBuilder idsQueryBuilder = QueryBuilders.idsQuery();
        for (T entity : entities) {
            ID id = this.extractIdFromBean(entity);
            if (id == null) continue;
            idsQueryBuilder.addIds(new String[]{this.stringIdRepresentation(id)});
        }
        if (idsQueryBuilder.ids().isEmpty()) {
            return;
        }
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)idsQueryBuilder).build();
        this.operations.delete(query, this.getEntityClass(), indexCoordinates);
        this.indexOperations.refresh();
    }

    private void doDelete(@Nullable ID id, IndexCoordinates indexCoordinates) {
        if (id != null) {
            this.operations.delete(this.stringIdRepresentation(id), indexCoordinates);
        }
    }

    public void deleteAll() {
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        NativeSearchQuery query = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).build();
        this.operations.delete(query, this.getEntityClass(), indexCoordinates);
        this.indexOperations.refresh();
    }

    @Override
    public void refresh() {
        this.indexOperations.refresh();
    }

    private Class<T> resolveReturnedClassFromGenericType() {
        ParameterizedType parameterizedType = this.resolveReturnedClassFromGenericType(this.getClass());
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    private ParameterizedType resolveReturnedClassFromGenericType(Class<?> clazz) {
        ParameterizedType parameterizedType;
        Type rawtype;
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && SimpleElasticsearchRepository.class.equals((Object)(rawtype = (parameterizedType = (ParameterizedType)genericSuperclass).getRawType()))) {
            return parameterizedType;
        }
        return this.resolveReturnedClassFromGenericType(clazz.getSuperclass());
    }

    protected Class<T> getEntityClass() {
        if (!this.isEntityClassSet()) {
            try {
                this.entityClass = this.resolveReturnedClassFromGenericType();
            }
            catch (Exception e) {
                throw new InvalidDataAccessApiUsageException("Unable to resolve EntityClass. Please use according setter!", (Throwable)e);
            }
        }
        return this.entityClass;
    }

    private boolean isEntityClassSet() {
        return this.entityClass != null;
    }

    @Nullable
    protected ID extractIdFromBean(T entity) {
        return (ID)this.entityInformation.getId(entity);
    }

    private List<String> stringIdsRepresentation(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"ids can't be null.");
        ArrayList<String> stringIds = new ArrayList<String>();
        for (ID id : ids) {
            stringIds.add(this.stringIdRepresentation(id));
        }
        return stringIds;
    }

    @Nullable
    protected abstract String stringIdRepresentation(@Nullable ID var1);

    private IndexCoordinates getIndexCoordinates() {
        return this.operations.getIndexCoordinatesFor(this.getEntityClass());
    }
}

