/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.elasticsearch.annotations.Query;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchEntityMetadata;
import org.springframework.data.elasticsearch.repository.query.SimpleElasticsearchEntityMetadata;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ElasticsearchQueryMethod
extends QueryMethod {
    private final Query queryAnnotation;
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    @Nullable
    private ElasticsearchEntityMetadata<?> metadata;

    public ElasticsearchQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        super(method, metadata, factory);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.queryAnnotation = method.getAnnotation(Query.class);
        this.mappingContext = mappingContext;
    }

    public boolean hasAnnotatedQuery() {
        return this.queryAnnotation != null;
    }

    public String getAnnotatedQuery() {
        return (String)AnnotationUtils.getValue((Annotation)this.queryAnnotation, (String)"value");
    }

    public ElasticsearchEntityMetadata<?> getEntityInformation() {
        if (this.metadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType)) {
                this.metadata = new SimpleElasticsearchEntityMetadata(domainClass, (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass));
            } else {
                ElasticsearchPersistentEntity returnedEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                ElasticsearchPersistentEntity managedEntity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                ElasticsearchPersistentEntity collectionEntity = domainClass.isAssignableFrom(returnedObjectType) ? returnedEntity : managedEntity;
                this.metadata = new SimpleElasticsearchEntityMetadata(returnedEntity.getType(), collectionEntity);
            }
        }
        return this.metadata;
    }

    protected MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }
}

