/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.query.AbstractReactiveElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.elasticsearch.repository.query.parser.ElasticsearchQueryCreator;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;

public class ReactivePartTreeElasticsearchQuery
extends AbstractReactiveElasticsearchRepositoryQuery {
    private final PartTree tree;
    private final ResultProcessor processor;

    public ReactivePartTreeElasticsearchQuery(ReactiveElasticsearchQueryMethod queryMethod, ReactiveElasticsearchOperations elasticsearchOperations) {
        super(queryMethod, elasticsearchOperations);
        this.processor = queryMethod.getResultProcessor();
        this.tree = new PartTree(queryMethod.getName(), this.processor.getReturnedType().getDomainType());
    }

    @Override
    protected Query createQuery(ElasticsearchParameterAccessor accessor) {
        return (Query)new ElasticsearchQueryCreator(this.tree, accessor, this.getMappingContext()).createQuery();
    }

    @Override
    boolean isLimiting() {
        return this.tree.isLimiting();
    }

    @Override
    boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    boolean isCountQuery() {
        return this.tree.isCountProjection();
    }
}

