/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.reactive;

import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.springframework.data.elasticsearch.client.reactive.DefaultWebClientProvider;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;

public interface WebClientProvider {
    public static WebClientProvider http() {
        return WebClientProvider.create("http");
    }

    public static WebClientProvider create(String scheme) {
        Assert.hasText((String)scheme, (String)"Protocol scheme must not be empty");
        return new DefaultWebClientProvider(scheme, null);
    }

    public static WebClientProvider create(String scheme, @Nullable ClientHttpConnector connector) {
        Assert.hasText((String)scheme, (String)"Protocol scheme must not be empty");
        return new DefaultWebClientProvider(scheme, connector);
    }

    public WebClient get(InetSocketAddress var1);

    public HttpHeaders getDefaultHeaders();

    public Consumer<Throwable> getErrorListener();

    public WebClientProvider withDefaultHeaders(HttpHeaders var1);

    public WebClientProvider withErrorListener(Consumer<Throwable> var1);
}

