/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Map;
import lombok.NonNull;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class EntityOperations {
    private static final String ID_FIELD = "id";
    @NonNull
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context;

    <T> Entity<T> forEntity(T entity) {
        Assert.notNull(entity, (String)"Bean must not be null!");
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return MappedEntity.of(entity, this.context);
    }

    <T> AdaptibleEntity<T> forEntity(T entity, ConversionService conversionService) {
        Assert.notNull(entity, (String)"Bean must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return AdaptibleMappedEntity.of(entity, this.context, conversionService);
    }

    IndexCoordinates determineIndex(Entity<?> entity, @Nullable String index, @Nullable String type) {
        return this.determineIndex(entity.getPersistentEntity(), index, type);
    }

    IndexCoordinates determineIndex(ElasticsearchPersistentEntity<?> persistentEntity, @Nullable String index, @Nullable String type) {
        return new IndexCoordinates(EntityOperations.indexName(persistentEntity, index), EntityOperations.typeName(persistentEntity, type));
    }

    private static String indexName(@Nullable ElasticsearchPersistentEntity<?> entity, @Nullable String index) {
        if (StringUtils.isEmpty((Object)index)) {
            Assert.notNull(entity, (String)"Cannot determine index name");
            return entity.getIndexName();
        }
        return index;
    }

    private static String typeName(@Nullable ElasticsearchPersistentEntity<?> entity, @Nullable String type) {
        if (StringUtils.isEmpty((Object)type)) {
            Assert.notNull(entity, (String)"Cannot determine index type");
            return entity.getIndexType();
        }
        return type;
    }

    public EntityOperations(@NonNull MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    static class IndexCoordinates {
        private final String indexName;
        private final String typeName;

        protected IndexCoordinates(String indexName, String typeName) {
            this.indexName = indexName;
            this.typeName = typeName;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    private static class AdaptibleMappedEntity<T>
    extends MappedEntity<T>
    implements AdaptibleEntity<T> {
        private final ElasticsearchPersistentEntity<?> entity;
        private final ConvertingPropertyAccessor<T> propertyAccessor;
        private final IdentifierAccessor identifierAccessor;

        private AdaptibleMappedEntity(ElasticsearchPersistentEntity<?> entity, IdentifierAccessor identifierAccessor, ConvertingPropertyAccessor<T> propertyAccessor) {
            super(entity, identifierAccessor, propertyAccessor);
            this.entity = entity;
            this.propertyAccessor = propertyAccessor;
            this.identifierAccessor = identifierAccessor;
        }

        static <T> AdaptibleEntity<T> of(T bean, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context, ConversionService conversionService) {
            ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new AdaptibleMappedEntity<T>(entity, identifierAccessor, new ConvertingPropertyAccessor(propertyAccessor, conversionService));
        }

        @Override
        public boolean hasParent() {
            return this.getRequiredPersistentEntity().getParentIdProperty() != null;
        }

        @Override
        public Object getParentId() {
            ElasticsearchPersistentProperty parentProperty = this.getRequiredPersistentEntity().getParentIdProperty();
            return this.propertyAccessor.getProperty((PersistentProperty)parentProperty);
        }

        @Override
        @Nullable
        public T populateIdIfNecessary(@Nullable Object id) {
            if (id == null) {
                return null;
            }
            Object bean = this.propertyAccessor.getBean();
            ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)this.entity.getIdProperty();
            if (idProperty == null) {
                return (T)bean;
            }
            if (this.identifierAccessor.getIdentifier() != null) {
                return (T)bean;
            }
            this.propertyAccessor.setProperty((PersistentProperty)idProperty, id);
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        @Nullable
        public Number getVersion() {
            ElasticsearchPersistentProperty versionProperty = (ElasticsearchPersistentProperty)this.entity.getRequiredVersionProperty();
            return (Number)this.propertyAccessor.getProperty((PersistentProperty)versionProperty, Number.class);
        }

        @Override
        public T initializeVersionProperty() {
            ElasticsearchPersistentProperty versionProperty;
            if (!this.entity.hasVersionProperty()) {
                return (T)this.propertyAccessor.getBean();
            }
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)((versionProperty = (ElasticsearchPersistentProperty)this.entity.getRequiredVersionProperty()).getType().isPrimitive() ? 1 : 0));
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public T incrementVersion() {
            ElasticsearchPersistentProperty versionProperty = (ElasticsearchPersistentProperty)this.entity.getRequiredVersionProperty();
            Number version = this.getVersion();
            Long nextVersion = version == null ? 0L : version.longValue() + 1L;
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)nextVersion);
            return (T)this.propertyAccessor.getBean();
        }
    }

    private static class MappedEntity<T>
    implements Entity<T> {
        private final ElasticsearchPersistentEntity<?> entity;
        private final IdentifierAccessor idAccessor;
        private final PersistentPropertyAccessor<T> propertyAccessor;

        private static <T> MappedEntity<T> of(T bean, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> context) {
            ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new MappedEntity<T>(entity, identifierAccessor, propertyAccessor);
        }

        @Override
        public Object getId() {
            return this.idAccessor.getIdentifier();
        }

        @Override
        public boolean isVersionedEntity() {
            return this.entity.hasVersionProperty();
        }

        @Override
        @Nullable
        public Object getVersion() {
            return this.propertyAccessor.getProperty(this.entity.getRequiredVersionProperty());
        }

        @Override
        public T getBean() {
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public boolean isNew() {
            return this.entity.isNew(this.propertyAccessor.getBean());
        }

        @Override
        public ElasticsearchPersistentEntity<?> getPersistentEntity() {
            return this.entity;
        }

        protected MappedEntity(ElasticsearchPersistentEntity<?> entity, IdentifierAccessor idAccessor, PersistentPropertyAccessor<T> propertyAccessor) {
            this.entity = entity;
            this.idAccessor = idAccessor;
            this.propertyAccessor = propertyAccessor;
        }
    }

    private static class SimpleMappedEntity<T extends Map<String, Object>>
    extends MapBackedEntity<T> {
        SimpleMappedEntity(T map) {
            super(map);
        }

        @Override
        public Object getId() {
            return this.getBean().get(EntityOperations.ID_FIELD);
        }
    }

    private static class UnmappedEntity<T extends Map<String, Object>>
    extends MapBackedEntity<T> {
        UnmappedEntity(T map) {
            super(map);
        }
    }

    private static class MapBackedEntity<T extends Map<String, Object>>
    implements AdaptibleEntity<T> {
        private final T map;

        @Override
        public Object getId() {
            return this.map.get(EntityOperations.ID_FIELD);
        }

        @Override
        public boolean hasParent() {
            return false;
        }

        @Override
        public Entity<?> getParentId() {
            return null;
        }

        @Override
        @Nullable
        public T populateIdIfNecessary(@Nullable Object id) {
            this.map.put((String)EntityOperations.ID_FIELD, (Object)id);
            return this.map;
        }

        @Override
        public T initializeVersionProperty() {
            return this.map;
        }

        @Override
        @Nullable
        public Number getVersion() {
            return null;
        }

        @Override
        public T incrementVersion() {
            return this.map;
        }

        @Override
        public T getBean() {
            return this.map;
        }

        @Override
        public boolean isNew() {
            return this.map.get(EntityOperations.ID_FIELD) != null;
        }

        @Override
        public ElasticsearchPersistentEntity<?> getPersistentEntity() {
            return null;
        }

        public MapBackedEntity(T map) {
            this.map = map;
        }
    }

    static interface AdaptibleEntity<T>
    extends Entity<T> {
        public boolean hasParent();

        @Nullable
        public Object getParentId();

        @Nullable
        public T populateIdIfNecessary(@Nullable Object var1);

        public T initializeVersionProperty();

        public T incrementVersion();

        @Override
        @Nullable
        public Number getVersion();
    }

    static interface Entity<T> {
        @Nullable
        public Object getId();

        default public boolean isVersionedEntity() {
            return false;
        }

        @Nullable
        public Object getVersion();

        public T getBean();

        public boolean isNew();

        @Nullable
        public ElasticsearchPersistentEntity<?> getPersistentEntity();

        default public ElasticsearchPersistentEntity<?> getRequiredPersistentEntity() {
            ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity();
            if (persistentEntity == null) {
                throw new IllegalStateException("No ElasticsearchPersistentEntity available for this entity!");
            }
            return persistentEntity;
        }
    }
}

