/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.DefaultClientConfiguration;
import org.springframework.data.elasticsearch.client.InetSocketAddressParser;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

class ClientConfigurationBuilder
implements ClientConfiguration.ClientConfigurationBuilderWithRequiredEndpoint,
ClientConfiguration.MaybeSecureClientConfigurationBuilder {
    private List<InetSocketAddress> hosts = new ArrayList<InetSocketAddress>();
    private HttpHeaders headers = HttpHeaders.EMPTY;
    private boolean useSsl;
    @Nullable
    private SSLContext sslContext;
    private Duration connectTimeout = Duration.ofSeconds(10L);
    private Duration soTimeout = Duration.ofSeconds(5L);
    private String username;
    private String password;

    ClientConfigurationBuilder() {
    }

    @Override
    public ClientConfiguration.MaybeSecureClientConfigurationBuilder connectedTo(String ... hostAndPorts) {
        Assert.notEmpty((Object[])hostAndPorts, (String)"At least one host is required");
        this.hosts.addAll(Arrays.stream(hostAndPorts).map(ClientConfigurationBuilder::parse).collect(Collectors.toList()));
        return this;
    }

    @Override
    public ClientConfiguration.MaybeSecureClientConfigurationBuilder connectedTo(InetSocketAddress ... endpoints) {
        Assert.notEmpty((Object[])endpoints, (String)"At least one endpoint is required");
        this.hosts.addAll(Arrays.asList(endpoints));
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder usingSsl() {
        this.useSsl = true;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder usingSsl(SSLContext sslContext) {
        Assert.notNull((Object)sslContext, (String)"SSL Context must not be null");
        this.useSsl = true;
        this.sslContext = sslContext;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withDefaultHeaders(HttpHeaders defaultHeaders) {
        Assert.notNull((Object)defaultHeaders, (String)"Default HTTP headers must not be null");
        this.headers = new HttpHeaders();
        this.headers.addAll((MultiValueMap)defaultHeaders);
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withConnectTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"I/O timeout must not be null!");
        this.connectTimeout = timeout;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withSocketTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Socket timeout must not be null!");
        this.soTimeout = timeout;
        return this;
    }

    @Override
    public ClientConfiguration.TerminalClientConfigurationBuilder withBasicAuth(String username, String password) {
        Assert.notNull((Object)username, (String)"username must not be null");
        Assert.notNull((Object)password, (String)"password must not be null");
        this.username = username;
        this.password = password;
        return this;
    }

    @Override
    public ClientConfiguration build() {
        if (this.username != null && this.password != null) {
            if (HttpHeaders.EMPTY.equals((Object)this.headers)) {
                this.headers = new HttpHeaders();
            }
            this.headers.setBasicAuth(this.username, this.password);
        }
        return new DefaultClientConfiguration(this.hosts, this.headers, this.useSsl, this.sslContext, this.soTimeout, this.connectTimeout);
    }

    private static InetSocketAddress parse(String hostAndPort) {
        return InetSocketAddressParser.parse(hostAndPort, 9200);
    }
}

