/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Arrays;
import java.util.List;
import org.springframework.data.elasticsearch.annotations.Parent;
import org.springframework.data.elasticsearch.annotations.Score;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class SimpleElasticsearchPersistentProperty
extends AnnotationBasedPersistentProperty<ElasticsearchPersistentProperty>
implements ElasticsearchPersistentProperty {
    private static final List<String> SUPPORTED_ID_PROPERTY_NAMES = Arrays.asList("id", "document");
    private final boolean isScore;
    private final boolean isParent;
    private final boolean isId = super.isIdProperty() || SUPPORTED_ID_PROPERTY_NAMES.contains(this.getFieldName());

    public SimpleElasticsearchPersistentProperty(Property property, PersistentEntity<?, ElasticsearchPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        this.isScore = this.isAnnotationPresent(Score.class);
        this.isParent = this.isAnnotationPresent(Parent.class);
        if (this.isVersionProperty() && this.getType() != Long.class) {
            throw new MappingException(String.format("Version property %s must be of type Long!", property.getName()));
        }
        if (this.isScore && !Arrays.asList(Float.TYPE, Float.class).contains(this.getType())) {
            throw new MappingException(String.format("Score property %s must be either of type float or Float!", property.getName()));
        }
        if (this.isParent && this.getType() != String.class) {
            throw new MappingException(String.format("Parent property %s must be of type String!", property.getName()));
        }
    }

    @Override
    public String getFieldName() {
        return this.getProperty().getName();
    }

    public boolean isIdProperty() {
        return this.isId;
    }

    protected Association<ElasticsearchPersistentProperty> createAssociation() {
        return null;
    }

    @Override
    public boolean isScoreProperty() {
        return this.isScore;
    }

    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isParentProperty() {
        return this.isParent;
    }
}

