/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.facet.request;

import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.springframework.data.elasticsearch.core.facet.AbstractFacetRequest;
import org.springframework.data.elasticsearch.core.facet.request.TermFacetOrder;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Deprecated
public class TermFacetRequest
extends AbstractFacetRequest {
    private String[] fields;
    private String[] excludeTerms;
    private int size = 10;
    private TermFacetOrder order = TermFacetOrder.descCount;
    private boolean allTerms = false;
    private String regex = null;

    public TermFacetRequest(String name) {
        super(name);
    }

    public void setFields(String ... fields) {
        Assert.isTrue((!ObjectUtils.isEmpty((Object[])fields) ? 1 : 0) != 0, (String)"Term agg need one field only");
        Assert.isTrue((fields.length == 1 ? 1 : 0) != 0, (String)"Term agg need one field only");
        this.fields = fields;
    }

    public void setSize(int size) {
        Assert.isTrue((size >= 0 ? 1 : 0) != 0, (String)"Size should be bigger then zero !!!");
        this.size = size;
    }

    public void setOrder(TermFacetOrder order) {
        this.order = order;
    }

    public void setExcludeTerms(String ... excludeTerms) {
        this.excludeTerms = excludeTerms;
    }

    public void setAllTerms(boolean allTerms) {
        this.allTerms = allTerms;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    @Override
    public AbstractAggregationBuilder getFacet() {
        Assert.notEmpty((Object[])this.fields, (String)"Please select at last one field !!!");
        TermsAggregationBuilder termsBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)this.getName()).field(this.fields[0])).size(this.size);
        switch (this.order) {
            case descTerm: {
                termsBuilder.order(Terms.Order.term((boolean)false));
                break;
            }
            case ascTerm: {
                termsBuilder.order(Terms.Order.term((boolean)true));
                break;
            }
            case descCount: {
                termsBuilder.order(Terms.Order.count((boolean)false));
                break;
            }
            default: {
                termsBuilder.order(Terms.Order.count((boolean)true));
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.excludeTerms)) {
            termsBuilder.includeExclude(new IncludeExclude(null, this.excludeTerms));
        }
        if (this.allTerms) {
            termsBuilder.size(Integer.MAX_VALUE);
        }
        if (StringUtils.hasText((String)this.regex)) {
            termsBuilder.includeExclude(new IncludeExclude(new RegExp(this.regex), null));
        }
        return termsBuilder;
    }
}

