/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.CompletionField;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.core.completion.Completion;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.util.StringUtils;

class MappingBuilder {
    public static final String FIELD_STORE = "store";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_INDEX = "index";
    public static final String FIELD_FORMAT = "format";
    public static final String FIELD_SEARCH_ANALYZER = "search_analyzer";
    public static final String FIELD_INDEX_ANALYZER = "analyzer";
    public static final String FIELD_PROPERTIES = "properties";
    public static final String FIELD_PARENT = "_parent";
    public static final String COMPLETION_PAYLOADS = "payloads";
    public static final String COMPLETION_PRESERVE_SEPARATORS = "preserve_separators";
    public static final String COMPLETION_PRESERVE_POSITION_INCREMENTS = "preserve_position_increments";
    public static final String COMPLETION_MAX_INPUT_LENGTH = "max_input_length";
    public static final String INDEX_VALUE_NOT_ANALYZED = "not_analyzed";
    public static final String TYPE_VALUE_STRING = "string";
    public static final String TYPE_VALUE_GEO_POINT = "geo_point";
    public static final String TYPE_VALUE_COMPLETION = "completion";
    public static final String TYPE_VALUE_GEO_HASH_PREFIX = "geohash_prefix";
    public static final String TYPE_VALUE_GEO_HASH_PRECISION = "geohash_precision";
    private static SimpleTypeHolder SIMPLE_TYPE_HOLDER = new SimpleTypeHolder();

    MappingBuilder() {
    }

    static XContentBuilder buildMapping(Class clazz, String indexType, String idFieldName, String parentType) throws IOException {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(indexType);
        if (StringUtils.hasText((String)parentType)) {
            mapping.startObject(FIELD_PARENT).field(FIELD_TYPE, parentType).endObject();
        }
        XContentBuilder xContentBuilder = mapping.startObject(FIELD_PROPERTIES);
        MappingBuilder.mapEntity(xContentBuilder, clazz, true, idFieldName, "", false, FieldType.Auto, null);
        return xContentBuilder.endObject().endObject().endObject();
    }

    private static void mapEntity(XContentBuilder xContentBuilder, Class clazz, boolean isRootObject, String idFieldName, String nestedObjectFieldName, boolean nestedOrObjectField, FieldType fieldType, org.springframework.data.elasticsearch.annotations.Field fieldAnnotation) throws IOException {
        Field[] fields = MappingBuilder.retrieveFields(clazz);
        if (!isRootObject && (MappingBuilder.isAnyPropertyAnnotatedAsField(fields) || nestedOrObjectField)) {
            String type = FieldType.Object.toString().toLowerCase();
            if (nestedOrObjectField) {
                type = fieldType.toString().toLowerCase();
            }
            XContentBuilder t = xContentBuilder.startObject(nestedObjectFieldName).field(FIELD_TYPE, type);
            if (nestedOrObjectField && FieldType.Nested == fieldType && fieldAnnotation.includeInParent()) {
                t.field("include_in_parent", fieldAnnotation.includeInParent());
            }
            t.startObject(FIELD_PROPERTIES);
        }
        for (Field field : fields) {
            ClassPathResource mappings;
            String mappingPath;
            if (field.isAnnotationPresent(Transient.class) || MappingBuilder.isInIgnoreFields(field)) continue;
            if (field.isAnnotationPresent(Mapping.class) && org.apache.commons.lang.StringUtils.isNotBlank((String)(mappingPath = field.getAnnotation(Mapping.class).mappingPath())) && (mappings = new ClassPathResource(mappingPath)).exists()) {
                xContentBuilder.rawField(field.getName(), mappings.getInputStream());
                continue;
            }
            boolean isGeoPointField = MappingBuilder.isGeoPointField(field);
            boolean isCompletionField = MappingBuilder.isCompletionField(field);
            org.springframework.data.elasticsearch.annotations.Field singleField = field.getAnnotation(org.springframework.data.elasticsearch.annotations.Field.class);
            if (!isGeoPointField && !isCompletionField && MappingBuilder.isEntity(field) && MappingBuilder.isAnnotated(field)) {
                if (singleField == null) continue;
                boolean nestedOrObject = MappingBuilder.isNestedOrObjectField(field);
                MappingBuilder.mapEntity(xContentBuilder, MappingBuilder.getFieldType(field), false, "", field.getName(), nestedOrObject, singleField.type(), field.getAnnotation(org.springframework.data.elasticsearch.annotations.Field.class));
                if (nestedOrObject) continue;
            }
            MultiField multiField = field.getAnnotation(MultiField.class);
            if (isGeoPointField) {
                MappingBuilder.applyGeoPointFieldMapping(xContentBuilder, field);
            }
            if (isCompletionField) {
                CompletionField completionField = field.getAnnotation(CompletionField.class);
                MappingBuilder.applyCompletionFieldMapping(xContentBuilder, field, completionField);
            }
            if (isRootObject && singleField != null && MappingBuilder.isIdField(field, idFieldName)) {
                MappingBuilder.applyDefaultIdFieldMapping(xContentBuilder, field);
                continue;
            }
            if (multiField != null) {
                MappingBuilder.addMultiFieldMapping(xContentBuilder, field, multiField, MappingBuilder.isNestedOrObjectField(field));
                continue;
            }
            if (singleField == null) continue;
            MappingBuilder.addSingleFieldMapping(xContentBuilder, field, singleField, MappingBuilder.isNestedOrObjectField(field));
        }
        if (!isRootObject && MappingBuilder.isAnyPropertyAnnotatedAsField(fields) || nestedOrObjectField) {
            xContentBuilder.endObject().endObject();
        }
    }

    private static Field[] retrieveFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class targetClass = clazz;
        do {
            fields.addAll(Arrays.asList(targetClass.getDeclaredFields()));
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return fields.toArray(new Field[fields.size()]);
    }

    private static boolean isAnnotated(Field field) {
        return field.getAnnotation(org.springframework.data.elasticsearch.annotations.Field.class) != null || field.getAnnotation(MultiField.class) != null || field.getAnnotation(GeoPointField.class) != null || field.getAnnotation(CompletionField.class) != null;
    }

    private static void applyGeoPointFieldMapping(XContentBuilder xContentBuilder, Field field) throws IOException {
        xContentBuilder.startObject(field.getName());
        xContentBuilder.field(FIELD_TYPE, TYPE_VALUE_GEO_POINT);
        GeoPointField annotation = field.getAnnotation(GeoPointField.class);
        if (annotation != null && annotation.geoHashPrefix()) {
            xContentBuilder.field(TYPE_VALUE_GEO_HASH_PREFIX, true);
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)annotation.geoHashPrecision())) {
                if (NumberUtils.isNumber((String)annotation.geoHashPrecision())) {
                    xContentBuilder.field(TYPE_VALUE_GEO_HASH_PRECISION, Integer.parseInt(annotation.geoHashPrecision()));
                } else {
                    xContentBuilder.field(TYPE_VALUE_GEO_HASH_PRECISION, annotation.geoHashPrecision());
                }
            }
        }
        xContentBuilder.endObject();
    }

    private static void applyCompletionFieldMapping(XContentBuilder xContentBuilder, Field field, CompletionField annotation) throws IOException {
        xContentBuilder.startObject(field.getName());
        xContentBuilder.field(FIELD_TYPE, TYPE_VALUE_COMPLETION);
        if (annotation != null) {
            xContentBuilder.field(COMPLETION_MAX_INPUT_LENGTH, annotation.maxInputLength());
            xContentBuilder.field(COMPLETION_PAYLOADS, annotation.payloads());
            xContentBuilder.field(COMPLETION_PRESERVE_POSITION_INCREMENTS, annotation.preservePositionIncrements());
            xContentBuilder.field(COMPLETION_PRESERVE_SEPARATORS, annotation.preserveSeparators());
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)annotation.searchAnalyzer())) {
                xContentBuilder.field(FIELD_SEARCH_ANALYZER, annotation.searchAnalyzer());
            }
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)annotation.analyzer())) {
                xContentBuilder.field(FIELD_INDEX_ANALYZER, annotation.analyzer());
            }
        }
        xContentBuilder.endObject();
    }

    private static void applyDefaultIdFieldMapping(XContentBuilder xContentBuilder, Field field) throws IOException {
        xContentBuilder.startObject(field.getName()).field(FIELD_TYPE, TYPE_VALUE_STRING).field(FIELD_INDEX, INDEX_VALUE_NOT_ANALYZED);
        xContentBuilder.endObject();
    }

    private static void addSingleFieldMapping(XContentBuilder xContentBuilder, Field field, org.springframework.data.elasticsearch.annotations.Field fieldAnnotation, boolean nestedOrObjectField) throws IOException {
        xContentBuilder.startObject(field.getName());
        if (!nestedOrObjectField) {
            xContentBuilder.field(FIELD_STORE, fieldAnnotation.store());
        }
        if (FieldType.Auto != fieldAnnotation.type()) {
            xContentBuilder.field(FIELD_TYPE, fieldAnnotation.type().name().toLowerCase());
            if (FieldType.Date == fieldAnnotation.type() && DateFormat.none != fieldAnnotation.format()) {
                xContentBuilder.field(FIELD_FORMAT, DateFormat.custom == fieldAnnotation.format() ? fieldAnnotation.pattern() : fieldAnnotation.format());
            }
        }
        if (FieldIndex.not_analyzed == fieldAnnotation.index() || FieldIndex.no == fieldAnnotation.index()) {
            xContentBuilder.field(FIELD_INDEX, fieldAnnotation.index().name().toLowerCase());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)fieldAnnotation.searchAnalyzer())) {
            xContentBuilder.field(FIELD_SEARCH_ANALYZER, fieldAnnotation.searchAnalyzer());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)fieldAnnotation.analyzer())) {
            xContentBuilder.field(FIELD_INDEX_ANALYZER, fieldAnnotation.analyzer());
        }
        xContentBuilder.endObject();
    }

    private static void addNestedFieldMapping(XContentBuilder builder, Field field, InnerField annotation) throws IOException {
        builder.startObject(annotation.suffix());
        if (FieldType.Auto != annotation.type()) {
            builder.field(FIELD_TYPE, annotation.type().name().toLowerCase());
        }
        if (FieldIndex.not_analyzed == annotation.index()) {
            builder.field(FIELD_INDEX, annotation.index().name().toLowerCase());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)annotation.searchAnalyzer())) {
            builder.field(FIELD_SEARCH_ANALYZER, annotation.searchAnalyzer());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)annotation.indexAnalyzer())) {
            builder.field(FIELD_INDEX_ANALYZER, annotation.indexAnalyzer());
        }
        builder.endObject();
    }

    private static void addMultiFieldMapping(XContentBuilder builder, Field field, MultiField annotation, boolean nestedOrObjectField) throws IOException {
        builder.startObject(field.getName());
        builder.field(FIELD_TYPE, "multi_field");
        builder.startObject("fields");
        MappingBuilder.addSingleFieldMapping(builder, field, annotation.mainField(), nestedOrObjectField);
        for (InnerField innerField : annotation.otherFields()) {
            MappingBuilder.addNestedFieldMapping(builder, field, innerField);
        }
        builder.endObject();
        builder.endObject();
    }

    protected static boolean isEntity(Field field) {
        ClassTypeInformation typeInformation = ClassTypeInformation.from(field.getType());
        Class<?> clazz = MappingBuilder.getFieldType(field);
        boolean isComplexType = !SIMPLE_TYPE_HOLDER.isSimpleType(clazz);
        return isComplexType && !Map.class.isAssignableFrom(typeInformation.getType());
    }

    protected static Class<?> getFieldType(Field field) {
        ResolvableType resolvableType = ResolvableType.forField((Field)field);
        if (resolvableType.isArray()) {
            return resolvableType.getComponentType().getRawClass();
        }
        ResolvableType componentType = resolvableType.getGeneric(new int[]{0});
        if (Iterable.class.isAssignableFrom(field.getType()) && componentType != ResolvableType.NONE) {
            return componentType.getRawClass();
        }
        return resolvableType.getRawClass();
    }

    private static boolean isAnyPropertyAnnotatedAsField(Field[] fields) {
        if (fields != null) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(org.springframework.data.elasticsearch.annotations.Field.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isIdField(Field field, String idFieldName) {
        return idFieldName.equals(field.getName());
    }

    private static boolean isInIgnoreFields(Field field) {
        org.springframework.data.elasticsearch.annotations.Field fieldAnnotation = field.getAnnotation(org.springframework.data.elasticsearch.annotations.Field.class);
        if (null != fieldAnnotation) {
            String[] ignoreFields = fieldAnnotation.ignoreFields();
            return Arrays.asList(ignoreFields).contains(field.getName());
        }
        return false;
    }

    private static boolean isNestedOrObjectField(Field field) {
        org.springframework.data.elasticsearch.annotations.Field fieldAnnotation = field.getAnnotation(org.springframework.data.elasticsearch.annotations.Field.class);
        return fieldAnnotation != null && (FieldType.Nested == fieldAnnotation.type() || FieldType.Object == fieldAnnotation.type());
    }

    private static boolean isGeoPointField(Field field) {
        return field.getType() == GeoPoint.class || field.getAnnotation(GeoPointField.class) != null;
    }

    private static boolean isCompletionField(Field field) {
        return field.getType() == Completion.class;
    }
}

