/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.facet;

import java.util.ArrayList;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.facet.statistical.StatisticalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.springframework.data.elasticsearch.core.facet.FacetResult;
import org.springframework.data.elasticsearch.core.facet.result.HistogramResult;
import org.springframework.data.elasticsearch.core.facet.result.IntervalUnit;
import org.springframework.data.elasticsearch.core.facet.result.Range;
import org.springframework.data.elasticsearch.core.facet.result.RangeResult;
import org.springframework.data.elasticsearch.core.facet.result.StatisticalResult;
import org.springframework.data.elasticsearch.core.facet.result.Term;
import org.springframework.data.elasticsearch.core.facet.result.TermResult;

public class DefaultFacetMapper {
    public static FacetResult parse(Facet facet) {
        if (facet instanceof TermsFacet) {
            return DefaultFacetMapper.parseTerm((TermsFacet)facet);
        }
        if (facet instanceof RangeFacet) {
            return DefaultFacetMapper.parseRange((RangeFacet)facet);
        }
        if (facet instanceof StatisticalFacet) {
            return DefaultFacetMapper.parseStatistical((StatisticalFacet)facet);
        }
        if (facet instanceof HistogramFacet) {
            return DefaultFacetMapper.parseHistogram((HistogramFacet)facet);
        }
        return null;
    }

    private static FacetResult parseTerm(TermsFacet facet) {
        ArrayList<Term> entries = new ArrayList<Term>();
        for (TermsFacet.Entry entry : facet.getEntries()) {
            entries.add(new Term(entry.getTerm().toString(), entry.getCount()));
        }
        return new TermResult(facet.getName(), entries, facet.getTotalCount(), facet.getOtherCount(), facet.getMissingCount());
    }

    private static FacetResult parseRange(RangeFacet facet) {
        ArrayList<Range> entries = new ArrayList<Range>();
        for (RangeFacet.Entry entry : facet.getEntries()) {
            entries.add(new Range(entry.getFrom() == Double.NEGATIVE_INFINITY ? null : Double.valueOf(entry.getFrom()), entry.getTo() == Double.POSITIVE_INFINITY ? null : Double.valueOf(entry.getTo()), entry.getCount(), entry.getTotal(), entry.getTotalCount(), entry.getMin(), entry.getMax()));
        }
        return new RangeResult(facet.getName(), entries);
    }

    private static FacetResult parseStatistical(StatisticalFacet facet) {
        return new StatisticalResult(facet.getName(), facet.getCount(), facet.getMax(), facet.getMin(), facet.getMean(), facet.getStdDeviation(), facet.getSumOfSquares(), facet.getTotal(), facet.getVariance());
    }

    private static FacetResult parseHistogram(HistogramFacet facet) {
        ArrayList<IntervalUnit> entries = new ArrayList<IntervalUnit>();
        for (HistogramFacet.Entry entry : facet.getEntries()) {
            entries.add(new IntervalUnit(entry.getKey(), entry.getCount(), entry.getTotalCount(), entry.getTotal(), entry.getMean(), entry.getMin(), entry.getMax()));
        }
        return new HistogramResult(facet.getName(), entries);
    }
}

