/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.w3c.dom.Element;

public class ElasticsearchRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    public String getRepositoryFactoryClassName() {
        return ElasticsearchRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "elasticsearch";
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("elasticsearchOperations", attributes.getString("elasticsearchTemplateRef"));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        builder.addPropertyReference("elasticsearchOperations", element.getAttribute("elasticsearch-template-ref"));
    }
}

