/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query.support;

import com.couchbase.client.java.json.JsonArray;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.repository.query.ConvertingIterator;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.repository.query.parser.Part;

public class N1qlQueryCreatorUtils {
    public static N1QLExpression prepareExpression(CouchbaseConverter converter, Part part, Iterator<Object> iterator, AtomicInteger position, JsonArray placeHolderValues) {
        boolean isString;
        PersistentPropertyPath<CouchbasePersistentProperty> path = N1qlUtils.getPathWithAlternativeFieldNames(converter, part.getProperty());
        ConvertingIterator parameterValues = new ConvertingIterator(iterator, converter);
        String fieldNamePath = N1qlUtils.getDottedPathWithAlternativeFieldNames(path);
        boolean ignoreCase = false;
        Class<?> leafType = converter.getWriteClassFor(((CouchbasePersistentProperty)path.getLeafProperty()).getType());
        boolean bl = isString = leafType == String.class;
        if (part.shouldIgnoreCase() == Part.IgnoreCaseType.WHEN_POSSIBLE) {
            ignoreCase = isString;
        } else if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS) {
            if (!isString) {
                throw new IllegalArgumentException(String.format("Part %s must be of type String but was %s", fieldNamePath, leafType));
            }
            ignoreCase = true;
        }
        return N1qlQueryCreatorUtils.createExpression(part.getType(), fieldNamePath, ignoreCase, parameterValues, position, placeHolderValues);
    }

    public static N1QLExpression createExpression(Part.Type partType, String fieldNamePath, boolean ignoreCase, Iterator<Object> parameterValues, AtomicInteger position, JsonArray placeHolderValues) {
        N1QLExpression exp;
        N1QLExpression left = ignoreCase ? N1QLExpression.x(fieldNamePath).lower() : N1QLExpression.x(fieldNamePath);
        switch (partType) {
            case BETWEEN: {
                exp = left.between(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase).and(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase)));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case IS_NOT_NULL: {
                exp = left.isNotNull();
                break;
            }
            case IS_NULL: {
                exp = left.isNull();
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                exp = left.ne(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case SIMPLE_PROPERTY: {
                exp = left.eq(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case BEFORE: 
            case LESS_THAN: {
                exp = left.lt(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case LESS_THAN_EQUAL: {
                exp = left.lte(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case GREATER_THAN_EQUAL: {
                exp = left.gte(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case AFTER: 
            case GREATER_THAN: {
                exp = left.gt(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case NOT_LIKE: {
                exp = left.notLike(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case LIKE: {
                exp = left.like(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case STARTING_WITH: {
                exp = left.like(N1QLExpression.x(String.valueOf(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase)) + " || '%'"));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case ENDING_WITH: {
                exp = left.like(N1QLExpression.x("'%' || " + String.valueOf(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase))));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case NOT_CONTAINING: {
                exp = left.notLike(N1QLExpression.x("'%' || " + String.valueOf(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase)) + " || '%'"));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case CONTAINING: {
                exp = left.like(N1QLExpression.x("'%' || " + String.valueOf(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase)) + " || '%'"));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case NOT_IN: {
                exp = left.notIn(N1qlQueryCreatorUtils.getPlaceHolder(position, false));
                placeHolderValues.add(N1qlQueryCreatorUtils.getArray(parameterValues));
                break;
            }
            case IN: {
                exp = left.in(N1qlQueryCreatorUtils.getPlaceHolder(position, false));
                placeHolderValues.add(N1qlQueryCreatorUtils.getArray(parameterValues));
                break;
            }
            case TRUE: {
                exp = left.eq(true);
                break;
            }
            case FALSE: {
                exp = left.eq(false);
                break;
            }
            case REGEX: {
                exp = N1QLExpression.x("REGEXP_LIKE(" + left.toString() + ", " + String.valueOf(N1qlQueryCreatorUtils.getPlaceHolder(position, false)) + ")");
                placeHolderValues.add(N1qlQueryCreatorUtils.getValueAsString(parameterValues));
                break;
            }
            case EXISTS: {
                exp = left.isNotMissing();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyword in N1QL query derivation");
            }
        }
        return exp;
    }

    protected static N1QLExpression getPlaceHolder(AtomicInteger position, boolean ignoreCase) {
        N1QLExpression placeHolder = N1QLExpression.x("$" + position.getAndIncrement());
        if (ignoreCase) {
            placeHolder = placeHolder.lower();
        }
        return placeHolder;
    }

    protected static String getValueAsString(Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        String pattern = next == null ? "" : String.valueOf(next);
        return pattern;
    }

    protected static N1QLExpression like(Iterator<Object> parameterValues, boolean ignoreCase, boolean anyPrefix, boolean anySuffix) {
        N1QLExpression converted;
        Object next = parameterValues.next();
        if (next == null) {
            return N1QLExpression.NULL();
        }
        if (next instanceof String) {
            Object pattern = (String)next;
            if (anyPrefix) {
                pattern = "%" + (String)pattern;
            }
            if (anySuffix) {
                pattern = (String)pattern + "%";
            }
            converted = N1QLExpression.s(new String[]{pattern});
        } else {
            converted = N1QLExpression.x(String.valueOf(next));
        }
        if (ignoreCase) {
            return converted.lower();
        }
        return converted;
    }

    protected static Object getValue(Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        if (next instanceof Enum) {
            next = String.valueOf(next);
        }
        return next;
    }

    protected static JsonArray getArray(Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        Object[] values = next instanceof Collection ? ((Collection)next).toArray() : (next.getClass().isArray() ? (Object[])next : new Object[]{next});
        return JsonArray.from((Object[])values);
    }
}

